/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;

public class ReferencedTypeGenerator
extends TypeGenerator {
    public ReferencedTypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        String extractName;
        try {
            extractName = GeneratorUtils.extractReferenceType(this.schema.get$ref());
        }
        catch (BallerinaOpenApiException e) {
            throw new OASTypeGenException(e.getMessage());
        }
        String typeName = GeneratorUtils.escapeIdentifier(extractName);
        Schema refSchema = (Schema)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getSchemas().get(typeName);
        refSchema = refSchema == null ? (Schema)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getSchemas().get(extractName) : refSchema;
        SimpleNameReferenceNode nameReferenceNode = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)typeName));
        TypeGenerator reffredTypeGenerator = TypeGeneratorUtils.getTypeGenerator(refSchema, extractName, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
        if (!this.pregeneratedTypeMap.containsKey(typeName)) {
            this.pregeneratedTypeMap.put(typeName, NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)typeName)));
            TypeDescriptorNode typeDescriptorNode = reffredTypeGenerator.generateTypeDescriptorNode();
            this.subTypesMap.put(typeName, NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)NodeFactory.createIdentifierToken((String)typeName), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        }
        return TypeGeneratorUtils.getNullableType(refSchema, (TypeDescriptorNode)nameReferenceNode, this.ignoreNullableFlag);
    }
}

