/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class UnionTypeGenerator
extends TypeGenerator {
    public UnionTypeGenerator(Schema<?> schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        List schemas = this.schema.getOneOf() != null ? this.schema.getOneOf() : this.schema.getAnyOf();
        TypeDescriptorNode unionTypeDesc = this.getUnionType(schemas, this.typeName);
        return TypeGeneratorUtils.getNullableType(this.schema, unionTypeDesc, this.ignoreNullableFlag);
    }

    private TypeDescriptorNode getUnionType(List<Schema> schemas, String typeName) throws OASTypeGenException {
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        for (Schema schema : schemas) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(schema, typeName, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode typeDescNode = typeGenerator.generateTypeDescriptorNode();
            this.imports.addAll(typeGenerator.getImports());
            if (typeDescNode instanceof OptionalTypeDescriptorNode && GeneratorMetaData.getInstance().isNullable()) {
                Node internalTypeDesc = ((OptionalTypeDescriptorNode)typeDescNode).typeDescriptor();
                typeDescNode = (TypeDescriptorNode)internalTypeDesc;
            }
            typeDescriptorNodes.add(typeDescNode);
        }
        return this.createUnionTypeNode(typeDescriptorNodes);
    }

    private TypeDescriptorNode createUnionTypeNode(List<TypeDescriptorNode> typeDescNodes) {
        if (typeDescNodes.isEmpty()) {
            return null;
        }
        if (typeDescNodes.size() == 1) {
            return typeDescNodes.get(0);
        }
        if (typeDescNodes.stream().anyMatch(node -> node.kind() == SyntaxKind.OPTIONAL_TYPE_DESC)) {
            typeDescNodes = typeDescNodes.stream().map(node -> {
                if (node instanceof OptionalTypeDescriptorNode) {
                    return (TypeDescriptorNode)((OptionalTypeDescriptorNode)node).typeDescriptor();
                }
                return node;
            }).collect(Collectors.toList());
            OptionalTypeDescriptorNode optionalTypeDesc = NodeFactory.createOptionalTypeDescriptorNode((Node)((Node)typeDescNodes.get(typeDescNodes.size() - 1)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            typeDescNodes.set(typeDescNodes.size() - 1, optionalTypeDesc);
        }
        UnionTypeDescriptorNode unionTypeDescNode = null;
        TypeDescriptorNode leftTypeDesc = typeDescNodes.get(0);
        for (int i = 1; i < typeDescNodes.size(); ++i) {
            TypeDescriptorNode rightTypeDesc = (TypeDescriptorNode)typeDescNodes.get(i);
            unionTypeDescNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)leftTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)rightTypeDesc);
            leftTypeDesc = unionTypeDescNode;
        }
        if (unionTypeDescNode.toSourceCode().contains("anydata")) {
            return NodeParser.parseTypeDescriptor((String)"anydata");
        }
        return unionTypeDescNode;
    }
}

