/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.mqtt.compiler.MqttServiceValidator;
import io.ballerina.stdlib.mqtt.compiler.PluginConstants;
import io.ballerina.stdlib.mqtt.compiler.PluginUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class MqttServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final MqttServiceValidator serviceValidator = new MqttServiceValidator();

    public void perform(SyntaxNodeAnalysisContext context) {
        List diagnostics = context.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        if (!this.isMqttService(context)) {
            return;
        }
        this.serviceValidator.validate(context);
    }

    private boolean isMqttService(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationNode serviceDeclarationNode;
        boolean isMqttService = false;
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)(serviceDeclarationNode = (ServiceDeclarationNode)context.node()));
        if (symbol.isPresent()) {
            ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)symbol.get();
            List listeners = serviceDeclarationSymbol.listenerTypes();
            if (listeners.size() > 1 && this.hasMqttListener(listeners)) {
                context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_MULTIPLE_LISTENERS, DiagnosticSeverity.ERROR, (Location)serviceDeclarationNode.location()));
            } else if (((TypeSymbol)listeners.get(0)).typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)listeners.get(0);
                List members = unionTypeSymbol.memberTypeDescriptors();
                for (TypeSymbol memberSymbol : members) {
                    Optional module = memberSymbol.getModule();
                    if (!module.isPresent()) continue;
                    isMqttService = PluginUtils.validateModuleId((ModuleSymbol)module.get());
                }
            } else {
                Optional module = ((TypeSymbol)listeners.get(0)).getModule();
                if (module.isPresent()) {
                    isMqttService = PluginUtils.validateModuleId((ModuleSymbol)module.get());
                }
            }
        }
        return isMqttService;
    }

    private boolean hasMqttListener(List<TypeSymbol> listeners) {
        for (TypeSymbol listener : listeners) {
            if (!PluginUtils.validateModuleId((ModuleSymbol)listener.getModule().get())) continue;
            return true;
        }
        return false;
    }
}

