/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.compiler;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.mqtt.compiler.MqttFunctionValidator;
import io.ballerina.stdlib.mqtt.compiler.PluginConstants;
import io.ballerina.stdlib.mqtt.compiler.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class MqttServiceValidator {
    public void validate(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)context.node();
        NodeList memberNodes = serviceDeclarationNode.members();
        boolean hasOnMessageRemoteFunction = serviceDeclarationNode.members().stream().anyMatch(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION && PluginUtils.isRemoteFunction(context, (FunctionDefinitionNode)child) && ((FunctionDefinitionNode)child).functionName().toString().equals("onMessage"));
        if (serviceDeclarationNode.members().isEmpty() || !hasOnMessageRemoteFunction) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getErrorCode(), PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getError(), DiagnosticSeverity.INTERNAL);
            context.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
        }
        FunctionDefinitionNode onMessage = null;
        FunctionDefinitionNode onError = null;
        FunctionDefinitionNode onComplete = null;
        for (Node node : memberNodes) {
            if (node.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(context, functionDefinitionNode);
                Optional functionName = methodSymbol.getName();
                if (!functionName.isPresent()) continue;
                if (((String)functionName.get()).equals("onMessage")) {
                    onMessage = functionDefinitionNode;
                    continue;
                }
                if (((String)functionName.get()).equals("onError")) {
                    onError = functionDefinitionNode;
                    continue;
                }
                if (((String)functionName.get()).equals("onComplete")) {
                    onComplete = functionDefinitionNode;
                    continue;
                }
                if (!PluginUtils.isRemoteFunction(context, functionDefinitionNode)) continue;
                context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTION, DiagnosticSeverity.ERROR, (Location)functionDefinitionNode.location()));
                continue;
            }
            if (node.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) continue;
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_RESOURCE_FUNCTION, DiagnosticSeverity.ERROR, (Location)node.location()));
        }
        new MqttFunctionValidator(context, onMessage, onError, onComplete).validate();
    }
}

