/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import java.util.concurrent.CompletableFuture;

public class ModuleUtils {
    private static Module module;

    private ModuleUtils() {
    }

    public static void setModule(Environment environment) {
        module = environment.getCurrentModule();
    }

    public static Module getModule() {
        return module;
    }

    public static void notifySuccess(CompletableFuture<Object> future, Object result) {
        BError error;
        if (result instanceof BError && !ModuleUtils.isModuleDefinedError(error = (BError)result)) {
            error.printStackTrace();
        }
        future.complete(result);
    }

    public static void notifyFailure(BError bError) {
        bError.printStackTrace();
        System.exit(1);
    }

    private static boolean isModuleDefinedError(BError error) {
        Type errorType = error.getType();
        Module packageDetails = errorType.getPackage();
        String orgName = packageDetails.getOrg();
        String packageName = packageDetails.getName();
        return "ballerina".equals(orgName) && "websubhub".equals(packageName);
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

