/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.websubhub.InteropArgs;
import io.ballerina.stdlib.websubhub.ModuleUtils;
import io.ballerina.stdlib.websubhub.NativeHubService;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class NativeHttpToWebsubhubAdaptor {
    private static final PrintStream LOGGER = System.out;

    private NativeHttpToWebsubhubAdaptor() {
    }

    public static void externInit(BObject adaptor, BObject serviceObj) {
        adaptor.addNativeData("NATIVE_HUB_SERVICE", (Object)new NativeHubService(serviceObj));
    }

    public static BArray getServiceMethodNames(BObject adaptor) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        List<BString> remoteMethodNames = nativeHubService.getRemoteMethodNames().stream().map(StringUtils::fromString).toList();
        return ValueCreator.createArrayValue((BString[])((BString[])remoteMethodNames.toArray(BString[]::new)));
    }

    public static Object callRegisterMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onRegisterTopic");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onRegisterTopic", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callRegisterMethod", "onRegisterTopic");
    }

    public static Object callDeregisterMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onDeregisterTopic");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onDeregisterTopic", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callDeregisterMethod", "onDeregisterTopic");
    }

    public static Object callOnUpdateMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onUpdateMessage");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onUpdateMessage", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnUpdateMethod", "onUpdateMessage");
    }

    public static Object callOnSubscriptionMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders, BObject bHubController) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onSubscription");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders, bHubController);
        Object[] args = nativeHubService.resolveArgs("onSubscription", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnSubscriptionMethod", "onSubscription");
    }

    public static Object callOnSubscriptionValidationMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onSubscriptionValidation");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onSubscriptionValidation", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnSubscriptionValidationMethod", "onSubscriptionValidation");
    }

    public static Object callOnSubscriptionIntentVerifiedMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onSubscriptionIntentVerified");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onSubscriptionIntentVerified", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnSubscriptionIntentVerifiedMethod", "onSubscriptionIntentVerified");
    }

    public static Object callOnUnsubscriptionMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders, BObject bHubController) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onUnsubscription");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders, bHubController);
        Object[] args = nativeHubService.resolveArgs("onUnsubscription", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnUnsubscriptionMethod", "onUnsubscription");
    }

    public static Object callOnUnsubscriptionValidationMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onUnsubscriptionValidation");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onUnsubscriptionValidation", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnUnsubscriptionValidationMethod", "onUnsubscriptionValidation");
    }

    public static Object callOnUnsubscriptionIntentVerifiedMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpHeaders) {
        NativeHubService nativeHubService = (NativeHubService)adaptor.getNativeData("NATIVE_HUB_SERVICE");
        BObject bHubService = nativeHubService.getBHubService();
        boolean isReadOnly = NativeHttpToWebsubhubAdaptor.isReadOnlyParam(bHubService, "onUnsubscriptionIntentVerified");
        if (isReadOnly) {
            message.freezeDirect();
        }
        InteropArgs interopArgs = new InteropArgs(message, bHttpHeaders);
        Object[] args = nativeHubService.resolveArgs("onUnsubscriptionIntentVerified", interopArgs);
        return NativeHttpToWebsubhubAdaptor.invokeRemoteFunction(env, bHubService, args, "callOnUnsubscriptionIntentVerifiedMethod", "onUnsubscriptionIntentVerified");
    }

    private static boolean isReadOnlyParam(BObject serviceObj, String remoteMethod) {
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)serviceObj));
        for (MethodType method : objectType.getMethods()) {
            Parameter[] parameters;
            if (!method.getName().equals(remoteMethod) || (parameters = method.getParameters()).length < 1) continue;
            Parameter parameter = parameters[0];
            Type paramType = parameter.type;
            if (!(paramType instanceof IntersectionType)) continue;
            List constituentTypes = ((IntersectionType)paramType).getConstituentTypes();
            return constituentTypes.stream().anyMatch(t -> 51 == t.getTag());
        }
        return false;
    }

    private static Object invokeRemoteFunction(Environment env, BObject bHubService, Object[] args, String parentFunctionName, String remoteFunctionName) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            try {
                Object result = env.getRuntime().callMethod(bHubService, remoteFunctionName, null, args);
                ModuleUtils.notifySuccess(balFuture, result);
                return ModuleUtils.getResult(balFuture);
            }
            catch (BError bError) {
                ModuleUtils.notifyFailure(bError);
                return null;
            }
        });
    }
}

