/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub;

import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.websubhub.InteropArgs;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class NativeHubService {
    private final BObject bHubService;
    private final Map<String, List<Type>> methodParameterMapping = new HashMap<String, List<Type>>();

    NativeHubService(BObject bHubService) {
        RemoteMethodType[] remoteMethods;
        for (RemoteMethodType remoteMethod : remoteMethods = ((ServiceType)TypeUtils.getType((Object)bHubService)).getRemoteMethods()) {
            String methodName = remoteMethod.getName();
            List<Type> paramTypeInOrder = Stream.of(remoteMethod.getParameters()).map(p -> p.type).toList();
            this.methodParameterMapping.put(methodName, paramTypeInOrder);
        }
        this.bHubService = bHubService;
    }

    public BObject getBHubService() {
        return this.bHubService;
    }

    public Set<String> getRemoteMethodNames() {
        return this.methodParameterMapping.keySet();
    }

    public Object[] resolveArgs(String methodName, InteropArgs interopArgs) {
        List argTypes = this.methodParameterMapping.getOrDefault(methodName, Collections.emptyList());
        Object[] args = new Object[argTypes.size()];
        for (int i = 0; i < argTypes.size(); ++i) {
            args[i] = interopArgs.getMappingArg((Type)argTypes.get(i));
        }
        return args;
    }
}

