/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.internal;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.noop.NoOpMetricProvider;
import io.ballerina.runtime.observability.metrics.spi.MetricProvider;
import io.ballerina.runtime.observability.tracer.TracersStore;
import io.ballerina.runtime.observability.tracer.noop.NoOpTracerProvider;
import io.ballerina.runtime.observability.tracer.spi.TracerProvider;
import io.ballerina.stdlib.observe.observers.BallerinaMetricsLogsObserver;
import io.ballerina.stdlib.observe.observers.BallerinaMetricsObserver;
import io.ballerina.stdlib.observe.observers.BallerinaTracingObserver;
import java.io.PrintStream;
import java.util.ServiceLoader;

public class NativeFunctions {
    private static final PrintStream errStream = System.err;

    public static BError enableMetrics(BString providerName) {
        NoOpMetricProvider selectedProvider = null;
        if ("noop".equalsIgnoreCase(providerName.getValue())) {
            selectedProvider = new NoOpMetricProvider();
        } else {
            for (MetricProvider providerFactory : ServiceLoader.load(MetricProvider.class)) {
                if (!providerName.getValue().equalsIgnoreCase(providerFactory.getName())) continue;
                selectedProvider = providerFactory;
                break;
            }
            if (selectedProvider == null) {
                errStream.println("error: metrics provider " + String.valueOf(providerName) + " not found");
                selectedProvider = new NoOpMetricProvider();
            }
        }
        try {
            selectedProvider.init();
            DefaultMetricRegistry.setInstance((MetricRegistry)new MetricRegistry((MetricProvider)selectedProvider));
            ObserveUtils.addObserver((BallerinaObserver)new BallerinaMetricsObserver());
            return null;
        }
        catch (BError e) {
            return e;
        }
    }

    public static BError enableTracing(BString providerName) {
        NoOpTracerProvider selectedProvider = null;
        if ("noop".equalsIgnoreCase(providerName.getValue())) {
            selectedProvider = new NoOpTracerProvider();
        } else {
            for (TracerProvider providerFactory : ServiceLoader.load(TracerProvider.class)) {
                if (!providerName.getValue().equalsIgnoreCase(providerFactory.getName())) continue;
                selectedProvider = providerFactory;
            }
            if (selectedProvider == null) {
                errStream.println("error: tracer provider " + String.valueOf(providerName) + " not found");
                selectedProvider = new NoOpTracerProvider();
            }
        }
        try {
            selectedProvider.init();
            TracersStore.getInstance().setTracerGenerator((TracerProvider)selectedProvider);
            ObserveUtils.addObserver((BallerinaObserver)new BallerinaTracingObserver());
            return null;
        }
        catch (BError e) {
            return e;
        }
    }

    public static BError enableMetricsLogging(Environment env) {
        try {
            ObserveUtils.addObserver((BallerinaObserver)new BallerinaMetricsLogsObserver(env));
            return null;
        }
        catch (BError e) {
            return e;
        }
    }

    public static void printError(BString message) {
        errStream.println("error: " + message.getValue());
    }
}

