/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.crypto.SequentialBufferedPipe;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;

public class PgpEncryptionGenerator {
    private final int compressionAlgorithm;
    private final int symmetricKeyAlgorithm;
    private final boolean armor;
    private final boolean withIntegrityCheck;
    public static final int BUFFER_SIZE = 8192;

    public PgpEncryptionGenerator(int compressionAlgorithm, int symmetricKeyAlgorithm, boolean armor, boolean withIntegrityCheck) {
        this.compressionAlgorithm = compressionAlgorithm;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.armor = armor;
        this.withIntegrityCheck = withIntegrityCheck;
    }

    private void encryptStream(OutputStream encryptOut, InputStream clearIn, InputStream publicKeyIn) throws IOException, PGPException {
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(this.compressionAlgorithm);
        PGPEncryptedDataGenerator pgpEncryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(this.symmetricKeyAlgorithm).setWithIntegrityPacket(this.withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pgpEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(PgpEncryptionGenerator.getPublicKey(publicKeyIn)));
        if (this.armor) {
            encryptOut = new ArmoredOutputStream(encryptOut);
        }
        try (OutputStream cipherOutStream = pgpEncryptedDataGenerator.open(encryptOut, new byte[8192]);){
            PgpEncryptionGenerator.copyAsLiteralData(compressedDataGenerator.open(cipherOutStream), clearIn);
            compressedDataGenerator.close();
        }
        encryptOut.close();
    }

    public void encryptStream(InputStream publicKeyIn, BObject iteratorObj) throws IOException, PGPException {
        SequentialBufferedPipe pipe = new SequentialBufferedPipe();
        OutputStream encryptOut = pipe.getOutputStream();
        iteratorObj.addNativeData("PIPED_OUTPUT_STREAM", (Object)encryptOut);
        InputStream pipedInputStream = pipe.getInputStream();
        iteratorObj.addNativeData("PIPED_INPUT_STREAM", (Object)pipedInputStream);
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(this.compressionAlgorithm);
        PGPEncryptedDataGenerator pgpEncryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(this.symmetricKeyAlgorithm).setWithIntegrityPacket(this.withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pgpEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(PgpEncryptionGenerator.getPublicKey(publicKeyIn)));
        if (this.armor) {
            encryptOut = new ArmoredOutputStream(encryptOut);
        }
        iteratorObj.addNativeData("ENCRYPTED_OUTPUT_STREAM", (Object)encryptOut);
        OutputStream cipherOutStream = pgpEncryptedDataGenerator.open(encryptOut, new byte[8192]);
        OutputStream compressedOutStream = compressedDataGenerator.open(cipherOutStream);
        iteratorObj.addNativeData("DATA_STREAM", (Object)cipherOutStream);
        iteratorObj.addNativeData("COMPRESSED_DATA_STREAM", (Object)compressedOutStream);
        iteratorObj.addNativeData("COMPRESSED_DATA_GENERATOR", (Object)compressedDataGenerator);
        PgpEncryptionGenerator.copyAsLiteralData(compressedOutStream, iteratorObj);
    }

    public Object encrypt(byte[] clearData, InputStream publicKeyIn) throws PGPException, IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(clearData);){
            BArray bArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                this.encryptStream(outputStream, inputStream, publicKeyIn);
                bArray = ValueCreator.createArrayValue((byte[])outputStream.toByteArray());
            }
            return bArray;
        }
    }

    private static PGPPublicKey getPublicKey(InputStream keyInputStream) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpPublicKeyRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyInputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRingIterator = pgpPublicKeyRings.getKeyRings();
        while (keyRingIterator.hasNext()) {
            PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)keyRingIterator.next();
            Optional<PGPPublicKey> pgpPublicKey = PgpEncryptionGenerator.extractPgpKeyFromRing(pgpPublicKeyRing);
            if (!pgpPublicKey.isPresent()) continue;
            return pgpPublicKey.get();
        }
        throw new PGPException("Invalid public key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAsLiteralData(OutputStream outputStream, InputStream in) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        byte[] buff = new byte[8192];
        try (OutputStream pOut = lData.open(outputStream, 'b', "_CONSOLE", Date.from(LocalDateTime.now().toInstant(ZoneOffset.UTC)), new byte[8192]);
             InputStream inputStream = in;){
            int len;
            while ((len = inputStream.read(buff)) > 0) {
                pOut.write(buff, 0, len);
            }
        }
        finally {
            Arrays.fill(buff, (byte)0);
        }
    }

    private static void copyAsLiteralData(OutputStream outputStream, BObject iteratorObj) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(outputStream, 'b', "_CONSOLE", Date.from(LocalDateTime.now().toInstant(ZoneOffset.UTC)), new byte[8192]);
        iteratorObj.addNativeData("TARGET_STREAM", (Object)pOut);
    }

    private static Optional<PGPPublicKey> extractPgpKeyFromRing(PGPPublicKeyRing pgpPublicKeyRing) {
        for (PGPPublicKey publicKey : pgpPublicKeyRing) {
            if (!publicKey.isEncryptionKey()) continue;
            return Optional.of(publicKey);
        }
        return Optional.empty();
    }

    static {
        if (Objects.isNull(Security.getProvider("BC"))) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

