/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.BallerinaInputStream;
import io.ballerina.stdlib.crypto.CryptoUtils;
import io.ballerina.stdlib.crypto.PgpDecryptionGenerator;
import io.ballerina.stdlib.crypto.nativeimpl.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.openpgp.PGPException;

public class Decrypt {
    public static final String ERROR_OCCURRED_WHILE_PGP_DECRYPT = "Error occurred while PGP decrypt: ";
    public static final String ERROR_OCCURRED_WHILE_READING_PRIVATE_KEY = "Error occurred while reading private key: ";
    public static final String UNINITIALIZED_PRIVATE_PUBLIC_KEY = "Uninitialized private/public key.";

    private Decrypt() {
    }

    public static Object decryptAesCbc(BArray inputValue, BArray keyValue, BArray ivValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = ivValue.getBytes();
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.DECRYPT, "CBC", padding.toString(), key, input, iv, -1L);
    }

    public static Object decryptAesEcb(BArray inputValue, BArray keyValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.DECRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }

    public static Object decryptAesGcm(BArray inputValue, BArray keyValue, BArray ivValue, Object padding, long tagSize) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = ivValue.getBytes();
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.DECRYPT, "GCM", padding.toString(), key, input, iv, tagSize);
    }

    public static Object decryptRsaEcb(BArray inputValue, Object keys, Object padding) {
        Key key;
        byte[] input = inputValue.getBytes();
        BMap keyMap = (BMap)keys;
        if (keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY") != null) {
            key = (PrivateKey)keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        } else if (keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY") != null) {
            key = (PublicKey)keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        } else {
            return CryptoUtils.createError(UNINITIALIZED_PRIVATE_PUBLIC_KEY);
        }
        return CryptoUtils.rsaEncryptDecrypt(CryptoUtils.CipherMode.DECRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }

    public static Object decryptPgp(BArray cipherTextValue, BString privateKeyPath, BArray passphrase) {
        Object object;
        byte[] privateKey;
        byte[] cipherText = cipherTextValue.getBytes();
        byte[] passphraseInBytes = passphrase.getBytes();
        try {
            privateKey = Files.readAllBytes(Path.of(privateKeyPath.toString(), new String[0]));
        }
        catch (IOException e) {
            return CryptoUtils.createError(ERROR_OCCURRED_WHILE_READING_PRIVATE_KEY + e.getMessage());
        }
        ByteArrayInputStream keyStream = new ByteArrayInputStream(privateKey);
        try {
            PgpDecryptionGenerator pgpDecryptionGenerator = new PgpDecryptionGenerator(keyStream, passphraseInBytes);
            object = pgpDecryptionGenerator.decrypt(cipherText);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)keyStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PGPException e) {
                return CryptoUtils.createError(ERROR_OCCURRED_WHILE_PGP_DECRYPT + e.getMessage());
            }
        }
        ((InputStream)keyStream).close();
        return object;
    }

    public static Object decryptStreamFromPgp(Environment environment, BStream inputBalStream, BString privateKeyPath, BArray passphrase) {
        BStream bStream;
        byte[] privateKey;
        byte[] passphraseInBytes = passphrase.getBytes();
        try {
            privateKey = Files.readAllBytes(Path.of(privateKeyPath.toString(), new String[0]));
        }
        catch (IOException e) {
            return CryptoUtils.createError(ERROR_OCCURRED_WHILE_READING_PRIVATE_KEY + e.getMessage());
        }
        ByteArrayInputStream keyStream = new ByteArrayInputStream(privateKey);
        try {
            BallerinaInputStream cipherTextStream = new BallerinaInputStream(environment, inputBalStream);
            PgpDecryptionGenerator pgpDecryptionGenerator = new PgpDecryptionGenerator(keyStream, passphraseInBytes);
            BObject iteratorObj = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"DecryptedStreamIterator", (Object[])new Object[0]);
            pgpDecryptionGenerator.decryptStream((InputStream)cipherTextStream, iteratorObj);
            ArrayType constrainedType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE);
            bStream = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)constrainedType), (BObject)iteratorObj);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)keyStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PGPException e) {
                return CryptoUtils.createError(ERROR_OCCURRED_WHILE_PGP_DECRYPT + e.getMessage());
            }
        }
        ((InputStream)keyStream).close();
        return bStream;
    }
}

