/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.CryptoUtils;
import java.util.zip.CRC32;

public class Hash {
    private Hash() {
    }

    public static BString crc32b(BArray input) {
        CRC32 checksum = new CRC32();
        byte[] bytes = input.getBytes();
        checksum.update(bytes, 0, bytes.length);
        long checksumVal = checksum.getValue();
        return StringUtils.fromString((String)Long.toHexString(checksumVal));
    }

    public static BArray hashMd5(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("MD5", inputValue.getBytes(), saltValue));
    }

    public static BArray hashSha1(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("SHA-1", inputValue.getBytes(), saltValue));
    }

    public static BArray hashSha256(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("SHA-256", inputValue.getBytes(), saltValue));
    }

    public static BArray hashSha384(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("SHA-384", inputValue.getBytes(), saltValue));
    }

    public static BArray hashSha512(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("SHA-512", inputValue.getBytes(), saltValue));
    }

    public static BArray hashKeccak256(BArray inputValue, Object saltValue) {
        return ValueCreator.createArrayValue((byte[])CryptoUtils.hash("Keccak-256", inputValue.getBytes(), saltValue));
    }
}

