/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.crypto.CryptoUtils;
import java.security.PrivateKey;
import java.security.PublicKey;

public class Sign {
    private Sign() {
    }

    public static Object signMlDsa65(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("ML-DSA-65", key, input);
    }

    public static Object signRsaMd5(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("MD5withRSA", key, input);
    }

    public static Object signRsaSha1(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA1withRSA", key, input);
    }

    public static Object signRsaSha256(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA256withRSA", key, input);
    }

    public static Object signRsaSha384(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA384withRSA", key, input);
    }

    public static Object signSha384withEcdsa(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA384withECDSA", key, input);
    }

    public static Object signSha256withEcdsa(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA256withECDSA", key, input);
    }

    public static Object signRsaSha512(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA512withRSA", key, input);
    }

    public static Object verifyMlDsa65Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("ML-DSA-65", key, data, signature);
    }

    public static Object verifyRsaMd5Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("MD5withRSA", key, data, signature);
    }

    public static Object verifyRsaSha1Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA1withRSA", key, data, signature);
    }

    public static Object verifyRsaSha256Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA256withRSA", key, data, signature);
    }

    public static Object verifyRsaSha384Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA384withRSA", key, data, signature);
    }

    public static Object verifyRsaSha512Signature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA512withRSA", key, data, signature);
    }

    public static Object verifySha384withEcdsaSignature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA384withECDSA", key, data, signature);
    }

    public static Object verifySha256withEcdsaSignature(BArray dataValue, BArray signatureValue, BMap<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA256withECDSA", key, data, signature);
    }
}

