/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.crypto.CryptoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;

public final class StreamUtils {
    public static final String STREAM_NOT_AVAILABLE = "Stream is not available";
    public static final String ERROR_OCCURRED_WHILE_CLOSING_THE_STREAM = "Error occurred while closing the stream: %s";
    public static final String ERROR_OCCURRED_WHILE_CLOSING_THE_GENERATOR = "Error occurred while closing the generator: %s";
    public static final String ERROR_OCCURRED_WHILE_READING_THE_STREAM = "Error occurred while reading from the stream: %s";
    public static final String NATIVE_DATA_NOT_AVAILABLE_ERROR = "%s is not available";
    public static final String MESSAGE_FAILED_INTEGRITY_CHECK = "Message failed integrity check";
    public static final String ERROR_OCCURRED_WHILE_VERIFYING_THE_INTEGRITY = "Error occurred while verifying the integrity: %s";
    public static final String ERROR_OCCURRED_WHILE_READING_FROM_THE_STREAM = "Error occurred while reading from the stream: %s";

    private StreamUtils() {
    }

    public static Object readDecryptedStream(BObject iterator) {
        Object stream = iterator.getNativeData("TARGET_STREAM");
        if (Objects.isNull(stream) || !(stream instanceof InputStream)) {
            return CryptoUtils.createError(String.format(NATIVE_DATA_NOT_AVAILABLE_ERROR, "TARGET_STREAM"));
        }
        InputStream inputStream = (InputStream)stream;
        try {
            byte[] buffer = new byte[8192];
            int in = inputStream.read(buffer);
            if (in == -1) {
                StreamUtils.closeNativeStream(iterator, "TARGET_STREAM");
                StreamUtils.performIntegrityCheck(iterator);
                return null;
            }
            if (in < buffer.length) {
                byte[] temp = new byte[in];
                System.arraycopy(buffer, 0, temp, 0, in);
                return ValueCreator.createArrayValue((byte[])temp);
            }
            return ValueCreator.createArrayValue((byte[])buffer);
        }
        catch (IOException e) {
            return CryptoUtils.createError(String.format("Error occurred while reading from the stream: %s", e.getMessage()));
        }
    }

    private static void performIntegrityCheck(BObject iterator) throws IOException {
        Object publicKeyEncryptedDataObj = iterator.getNativeData("KEY_ENCRYPTED_DATA");
        if (Objects.isNull(publicKeyEncryptedDataObj) || !(publicKeyEncryptedDataObj instanceof PGPPublicKeyEncryptedData)) {
            throw CryptoUtils.createError(STREAM_NOT_AVAILABLE);
        }
        PGPPublicKeyEncryptedData publicKeyEncryptedData = (PGPPublicKeyEncryptedData)publicKeyEncryptedDataObj;
        try {
            if (publicKeyEncryptedData.isIntegrityProtected() && !publicKeyEncryptedData.verify()) {
                throw CryptoUtils.createError(MESSAGE_FAILED_INTEGRITY_CHECK);
            }
        }
        catch (PGPException e) {
            throw CryptoUtils.createError(String.format(ERROR_OCCURRED_WHILE_VERIFYING_THE_INTEGRITY, e.getMessage()));
        }
    }

    public static Object readEncryptedStream(BObject iterator) {
        NativeData nativeData = StreamUtils.getNativeData(iterator);
        try {
            if (Boolean.FALSE.equals(nativeData.endOfStream())) {
                StreamUtils.writeToOutStream(iterator, nativeData.inputStream(), nativeData.outputStream());
            }
            return StreamUtils.readFromPipedStream(iterator, nativeData.pipedInStream());
        }
        catch (IOException e) {
            return CryptoUtils.createError(String.format("Error occurred while reading from the stream: %s", e.getMessage()));
        }
        catch (BError e) {
            return e;
        }
    }

    private static NativeData getNativeData(BObject iterator) {
        Object inputStreamToEncrypt = iterator.getNativeData("INPUT_STREAM_TO_ENCRYPT");
        if (Objects.isNull(inputStreamToEncrypt) || !(inputStreamToEncrypt instanceof InputStream)) {
            throw CryptoUtils.createError(String.format(NATIVE_DATA_NOT_AVAILABLE_ERROR, "INPUT_STREAM_TO_ENCRYPT"));
        }
        InputStream inputStream = (InputStream)inputStreamToEncrypt;
        Object targetStream = iterator.getNativeData("TARGET_STREAM");
        if (Objects.isNull(targetStream) || !(targetStream instanceof OutputStream)) {
            throw CryptoUtils.createError(String.format(NATIVE_DATA_NOT_AVAILABLE_ERROR, "TARGET_STREAM"));
        }
        OutputStream outputStream = (OutputStream)targetStream;
        Object pipelinedInputStream = iterator.getNativeData("PIPED_INPUT_STREAM");
        if (Objects.isNull(pipelinedInputStream) || !(pipelinedInputStream instanceof InputStream)) {
            throw CryptoUtils.createError(String.format(NATIVE_DATA_NOT_AVAILABLE_ERROR, "PIPED_INPUT_STREAM"));
        }
        InputStream pipedInStream = (InputStream)pipelinedInputStream;
        Object endOfInputStream = iterator.getNativeData("END_OF_INPUT_STREAM");
        if (Objects.isNull(endOfInputStream) || !(endOfInputStream instanceof Boolean)) {
            throw CryptoUtils.createError(String.format(NATIVE_DATA_NOT_AVAILABLE_ERROR, "END_OF_INPUT_STREAM"));
        }
        Boolean endOfStream = (Boolean)endOfInputStream;
        return new NativeData(inputStream, outputStream, pipedInStream, endOfStream);
    }

    private static BArray readFromPipedStream(BObject iterator, InputStream pipedInStream) throws IOException {
        byte[] pipelinedBuffer = new byte[8192];
        int pipelinedIn = pipedInStream.read(pipelinedBuffer);
        if (pipelinedIn == -1) {
            StreamUtils.closeNativeStream(iterator, "PIPED_INPUT_STREAM");
            return null;
        }
        if (pipelinedIn < pipelinedBuffer.length) {
            byte[] temp = new byte[pipelinedIn];
            System.arraycopy(pipelinedBuffer, 0, temp, 0, pipelinedIn);
            return ValueCreator.createArrayValue((byte[])temp);
        }
        return ValueCreator.createArrayValue((byte[])pipelinedBuffer);
    }

    private static void writeToOutStream(BObject iterator, InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] inputBuffer = new byte[8192];
        int result = inputStream.read(inputBuffer);
        if (result == -1) {
            iterator.addNativeData("END_OF_INPUT_STREAM", (Object)true);
            StreamUtils.closeEncryptedSourceStreams(iterator);
        }
        if (result > 0) {
            outputStream.write(inputBuffer, 0, result);
        }
    }

    public static void closeDecryptedStream(BObject iterator) throws BError {
        StreamUtils.closeNativeStream(iterator, "TARGET_STREAM");
        StreamUtils.closeNativeStream(iterator, "COMPRESSED_DATA_STREAM");
        StreamUtils.closeNativeStream(iterator, "DATA_STREAM");
    }

    public static void closeEncryptedStream(BObject iterator) throws BError {
        StreamUtils.closeNativeStream(iterator, "TARGET_STREAM");
        StreamUtils.closeNativeStream(iterator, "COMPRESSED_DATA_STREAM");
        StreamUtils.closeDataGenerator(iterator);
        StreamUtils.closeNativeStream(iterator, "DATA_STREAM");
        StreamUtils.closeNativeStream(iterator, "ENCRYPTED_OUTPUT_STREAM");
        StreamUtils.closeNativeStream(iterator, "PIPED_OUTPUT_STREAM");
        StreamUtils.closeNativeStream(iterator, "PIPED_INPUT_STREAM");
    }

    public static void closeEncryptedSourceStreams(BObject iterator) throws BError {
        StreamUtils.closeNativeStream(iterator, "INPUT_STREAM_TO_ENCRYPT");
        StreamUtils.closeNativeStream(iterator, "TARGET_STREAM");
        StreamUtils.closeNativeStream(iterator, "COMPRESSED_DATA_STREAM");
        StreamUtils.closeDataGenerator(iterator);
        StreamUtils.closeNativeStream(iterator, "DATA_STREAM");
        StreamUtils.closeNativeStream(iterator, "ENCRYPTED_OUTPUT_STREAM");
        StreamUtils.closeNativeStream(iterator, "PIPED_OUTPUT_STREAM");
    }

    public static void closeNativeStream(BObject iterator, String streamName) throws BError {
        Object streamObj = iterator.getNativeData(streamName);
        if (Objects.isNull(streamObj) || !(streamObj instanceof Closeable)) {
            throw CryptoUtils.createError(STREAM_NOT_AVAILABLE);
        }
        Closeable stream = (Closeable)streamObj;
        try {
            stream.close();
        }
        catch (IOException e) {
            throw CryptoUtils.createError(String.format(ERROR_OCCURRED_WHILE_CLOSING_THE_STREAM, e.getMessage()));
        }
    }

    public static void closeDataGenerator(BObject iterator) throws BError {
        Object generatorObj = iterator.getNativeData("COMPRESSED_DATA_GENERATOR");
        if (Objects.isNull(generatorObj) || !(generatorObj instanceof PGPCompressedDataGenerator)) {
            throw CryptoUtils.createError(STREAM_NOT_AVAILABLE);
        }
        PGPCompressedDataGenerator generator = (PGPCompressedDataGenerator)generatorObj;
        try {
            generator.close();
        }
        catch (IOException e) {
            throw CryptoUtils.createError(String.format(ERROR_OCCURRED_WHILE_CLOSING_THE_GENERATOR, e.getMessage()));
        }
    }

    private record NativeData(InputStream inputStream, OutputStream outputStream, InputStream pipedInStream, Boolean endOfStream) {
    }
}

