/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.utils;

import io.ballerina.stdlib.graphql.commons.types.DefaultDirective;
import io.ballerina.stdlib.graphql.commons.types.Directive;
import io.ballerina.stdlib.graphql.commons.types.DirectiveLocation;
import io.ballerina.stdlib.graphql.commons.types.EnumValue;
import io.ballerina.stdlib.graphql.commons.types.FederatedDirective;
import io.ballerina.stdlib.graphql.commons.types.FederatedEnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.IntrospectionType;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.commons.utils.KeyDirectivesArgumentHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SdlSchemaStringGenerator {
    private static final String SCHEMA_FORMAT = "%s%s%s%s";
    private static final String FEDERATION2_SCHEMA_EXTENSION = "extend schema %s %s";
    private static final String DIRECTIVE_TYPE_FORMAT = "%sdirective @%s%s%s on %s";
    private static final String INTERFACE_TYPE_FORMAT = "%sinterface %s%s %s";
    private static final String UNION_TYPE_FORMAT = "%sunion %s%s";
    private static final String SCALAR_TYPE_FORMAT = "%sscalar %s%s";
    private static final String OBJECT_TYPE_FORMAT = "%stype %s%s %s";
    private static final String ENTITY_TYPE_FORMAT = "%stype %s%s%s %s";
    private static final String ENTITY_KEY_DIRECTIVE = " @key(fields: \"%s\"%s)";
    private static final String RESOLVABLE_ARGUMENT = ", resolvable: %s";
    private static final String LINK_DIRECTIVE = "@link(url: \"%s\", import: [%s])";
    private static final String ENUM_TYPE_FORMAT = "%senum %s %s";
    private static final String INPUT_TYPE_FORMAT = "%sinput %s %s";
    private static final String FIELD_FORMAT = "%s  %s%s: %s%s";
    private static final String FIELD_BLOCK_FORMAT = "{%n%s%n}";
    private static final String ARGS_FORMAT = "(%s%s%s%s)";
    private static final String DESC_FORMAT = "%s%n";
    private static final String DEPRECATE_FORMAT = "%s(reason: \"%s\")";
    private static final String DOCUMENT_FORMAT = "%s\"%s\"";
    private static final String BLOCK_STRING_FORMAT = "%s\"\"\"%n%s%s%n%s\"\"\"";
    private static final String IMPLEMENT_FORMAT = " implements %s";
    private static final String POSSIBLE_TYPE_FORMAT = " = %s";
    private static final String INPUT_FIELD_FORMAT = "%s  %s: %s";
    private static final String ARGS_TYPE_FORMAT = "%s = %s";
    private static final String ARGS_VALUE_FORMAT = "%s%s%s: %s";
    private static final String ENUM_VALUE_FORMAT = "%s  %s%s";
    private static final String NON_NULL_FORMAT = "%s!";
    private static final String LIST_FORMAT = "[%s]";
    private static final String DEPRECATE = " @deprecated";
    private static final String REPEATABLE = " repeatable";
    private static final String FEDERATION_SPEC_LINK = "https://specs.apollo.dev/federation/v2.0";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LINE_SEPARATOR_REGEX = "\\r\\n?|\\n";
    private static final String INDENTATION = "  ";
    private static final String DOUBLE_INDENTATION = "    ";
    private static final String EMPTY_STRING = "";
    private static final String COMMA_SIGN = ",";
    private static final String AMPERSAND_SIGN = "&";
    private static final String PIPE_SIGN = "|";
    private static final String SPACE = " ";
    private static final String AT_SYMBOL = "@";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String[] SUBGRAPH_QUERY_FIELDS = new String[]{"_entities", "_service"};
    private static boolean isSubgraphSdlIntrospection;
    private final boolean isSubgraph;
    private final Map<String, KeyDirectivesArgumentHolder> entityKeyDirectiveArgumentHolders;
    private final Schema schema;

    public static String generate(Schema schema) {
        return SdlSchemaStringGenerator.generate(schema, false);
    }

    public static String generate(Schema schema, boolean isSubgraphSdlIntrospection) {
        SdlSchemaStringGenerator.isSubgraphSdlIntrospection = isSubgraphSdlIntrospection;
        schema.addSubgraphSchemaAdditions();
        SdlSchemaStringGenerator sdlGenerator = new SdlSchemaStringGenerator(schema);
        return sdlGenerator.getSDLSchemaString();
    }

    private SdlSchemaStringGenerator(Schema schema) {
        this.schema = schema;
        this.isSubgraph = schema.isSubgraph();
        this.entityKeyDirectiveArgumentHolders = schema.getEntityKeyDirectiveArgumentHolders();
    }

    private String getSDLSchemaString() {
        String directives = this.getDirectives();
        String types = this.getTypes();
        String schemaExtension = this.getFederationSchemaExtensionLink();
        return this.getFormattedString(SCHEMA_FORMAT, schemaExtension, this.createTypeDescription(this.schema.getDescription()), directives, types);
    }

    private String getFederationSchemaExtensionLink() {
        if (!this.isSubgraph) {
            return EMPTY_STRING;
        }
        String linkDirective = this.getLinkDirective();
        return this.getFormattedString(FEDERATION2_SCHEMA_EXTENSION, linkDirective, LINE_SEPARATOR + LINE_SEPARATOR);
    }

    private String getLinkDirective() {
        String imports = this.getImportsArgumentValueOfLinkDirective();
        return this.getFormattedString(LINK_DIRECTIVE, FEDERATION_SPEC_LINK, imports);
    }

    private String getImportsArgumentValueOfLinkDirective() {
        List imports = Arrays.stream(FederatedDirective.values()).filter(directive -> !FederatedDirective.canImportInLinkDirective(directive.getName())).map(directive -> "\"@" + directive.getName() + DOUBLE_QUOTE).collect(Collectors.toList());
        if (isSubgraphSdlIntrospection) {
            imports.add(DOUBLE_QUOTE + TypeName.FIELD_SET.getName() + DOUBLE_QUOTE);
        }
        return String.join((CharSequence)" ,", imports);
    }

    private String getDirectives() {
        ArrayList<String> directives = new ArrayList<String>();
        for (Directive directive : this.schema.getDirectives()) {
            if (this.isDefaultDirective(directive).booleanValue() || !isSubgraphSdlIntrospection && this.isFederatedDirective(directive)) continue;
            directives.add(this.createDirective(directive));
        }
        String formattedDirectives = String.join((CharSequence)(LINE_SEPARATOR + LINE_SEPARATOR), directives);
        if (directives.isEmpty()) {
            return formattedDirectives;
        }
        return formattedDirectives + LINE_SEPARATOR + LINE_SEPARATOR;
    }

    private boolean isFederatedDirective(Directive directive) {
        return this.isSubgraph && Arrays.stream(FederatedDirective.values()).anyMatch(federatedDirective -> Objects.equals(directive.getName(), federatedDirective.getName()));
    }

    private String getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (Map.Entry<String, Type> entry : this.schema.getTypes().entrySet()) {
            if (this.isIntrospectionType(entry.getValue()).booleanValue() || this.isBuiltInScalarType(entry.getValue()).booleanValue() || !isSubgraphSdlIntrospection && this.isDefaultFederatedType(entry.getValue())) continue;
            types.add(this.createType(entry.getValue()));
        }
        return String.join((CharSequence)(LINE_SEPARATOR + LINE_SEPARATOR), types);
    }

    private boolean isDefaultFederatedType(Type type) {
        if (!this.isSubgraph) {
            return false;
        }
        if (type.getKind() == TypeKind.SCALAR) {
            return this.isDefaultFederatedScalarType(type);
        }
        if (type.getKind() == TypeKind.ENUM) {
            return this.isDefaultFederatedEnumType(type);
        }
        if (type.getKind() == TypeKind.OBJECT) {
            return this.isDefaultFederatedObjectType(type);
        }
        if (type.getKind() == TypeKind.UNION) {
            return this.isFederatedEntityUnionType(type);
        }
        return false;
    }

    private boolean isDefaultFederatedScalarType(Type type) {
        return Objects.equals(type.getName(), TypeName.ANY.getName()) || Objects.equals(type.getName(), TypeName.FIELD_SET.getName()) || type.getName().equals(TypeName.LINK_IMPORT.getName());
    }

    private boolean isDefaultFederatedEnumType(Type type) {
        return Arrays.stream(FederatedEnumValue.values()).anyMatch(federatedEnum -> type.getName().equals(federatedEnum.getName()));
    }

    private boolean isDefaultFederatedObjectType(Type type) {
        return type.getName().equals(TypeName.SERVICE.getName());
    }

    private boolean isFederatedEntityUnionType(Type type) {
        return type.getName().equals(TypeName.ENTITY.getName());
    }

    private String createDirective(Directive directive) {
        return this.getFormattedString(DIRECTIVE_TYPE_FORMAT, this.createTypeDescription(directive.getDescription()), directive.getName(), this.createArgs(directive.getArgs()), this.createIsRepeatable(directive), this.createDirectiveLocation(directive.getLocations()));
    }

    private String createType(Type type) {
        if (type.getKind().equals((Object)TypeKind.SCALAR)) {
            return this.createScalarType(type);
        }
        if (type.getKind().equals((Object)TypeKind.OBJECT)) {
            return this.createObjectType(type);
        }
        if (type.getKind().equals((Object)TypeKind.INTERFACE)) {
            return this.createInterfaceType(type);
        }
        if (type.getKind().equals((Object)TypeKind.UNION)) {
            return this.createUnionType(type);
        }
        if (type.getKind().equals((Object)TypeKind.ENUM)) {
            return this.createEnumType(type);
        }
        if (type.getKind().equals((Object)TypeKind.INPUT_OBJECT)) {
            return this.createInputObjectType(type);
        }
        return EMPTY_STRING;
    }

    private String createScalarType(Type type) {
        return this.getFormattedString(SCALAR_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), type.getName(), this.createSpecifiedByUrl(type));
    }

    private String createObjectType(Type type) {
        String typeName = type.getName();
        if (this.isSubgraph && this.entityKeyDirectiveArgumentHolders.containsKey(typeName)) {
            return this.getFormattedString(ENTITY_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), typeName, this.createInterfaceImplements(type), this.createEntityKeyDirectives(typeName), this.createFields(type));
        }
        return this.getFormattedString(OBJECT_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), typeName, this.createInterfaceImplements(type), this.createFields(type));
    }

    private String createEntityKeyDirectives(String entityName) {
        KeyDirectivesArgumentHolder arguments = this.entityKeyDirectiveArgumentHolders.get(entityName);
        List<String> keyDirectiveFields = arguments.getFieldNames();
        List keyDirectives = keyDirectiveFields.stream().map(fields -> this.createEntityKeyDirective((String)fields, arguments.isResolvable())).collect(Collectors.toList());
        return String.join((CharSequence)EMPTY_STRING, keyDirectives);
    }

    private String createEntityKeyDirective(String fieldArgument, Boolean resolvable) {
        String resolvableArgument = resolvable != false ? EMPTY_STRING : this.getFormattedString(RESOLVABLE_ARGUMENT, resolvable.toString());
        return this.getFormattedString(ENTITY_KEY_DIRECTIVE, fieldArgument, resolvableArgument);
    }

    private String createInterfaceType(Type type) {
        return this.getFormattedString(INTERFACE_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), type.getName(), this.createInterfaceImplements(type), this.createFields(type));
    }

    private String createUnionType(Type type) {
        return this.getFormattedString(UNION_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), type.getName(), this.createPossibleTypes(type));
    }

    private String createInputObjectType(Type type) {
        return this.getFormattedString(INPUT_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), type.getName(), this.createInputValues(type));
    }

    private String createEnumType(Type type) {
        return this.getFormattedString(ENUM_TYPE_FORMAT, this.createTypeDescription(type.getDescription()), type.getName(), this.createEnumValues(type));
    }

    private String createTypeDescription(String description) {
        if (description == null) {
            return EMPTY_STRING;
        }
        CharSequence[] lines = description.trim().split(LINE_SEPARATOR_REGEX);
        if (lines.length == 1) {
            return this.getFormattedString(DESC_FORMAT, this.getFormattedString(DOCUMENT_FORMAT, new String[]{EMPTY_STRING, lines[0]}));
        }
        String formattedDesc = this.getFormattedString(BLOCK_STRING_FORMAT, EMPTY_STRING, EMPTY_STRING, String.join((CharSequence)LINE_SEPARATOR, lines), EMPTY_STRING);
        return this.getFormattedString(DESC_FORMAT, formattedDesc);
    }

    private String createFields(Type type) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Field field : type.getFields()) {
            if (this.isSubgraph && !isSubgraphSdlIntrospection && Arrays.asList(SUBGRAPH_QUERY_FIELDS).contains(field.getName())) continue;
            fields.add(this.getFormattedString(FIELD_FORMAT, this.createFieldDescription(field.getDescription()), field.getName(), this.createArgs(field.getArgs()), this.createFieldType(field.getType()), this.createDeprecate(field)));
        }
        return this.getFormattedString(FIELD_BLOCK_FORMAT, String.join((CharSequence)LINE_SEPARATOR, fields));
    }

    private String createEnumValues(Type type) {
        ArrayList<String> enumValues = new ArrayList<String>();
        for (EnumValue enumValue : type.getEnumValues()) {
            enumValues.add(this.getFormattedString(ENUM_VALUE_FORMAT, this.createFieldDescription(enumValue.getDescription()), enumValue.getName(), this.createDeprecate(enumValue)));
        }
        return this.getFormattedString(FIELD_BLOCK_FORMAT, String.join((CharSequence)LINE_SEPARATOR, enumValues));
    }

    private String createInputValues(Type type) {
        ArrayList<String> inputFields = new ArrayList<String>();
        for (InputValue inputField : type.getInputFields()) {
            inputFields.add(this.getFormattedString(INPUT_FIELD_FORMAT, this.createFieldDescription(inputField.getDescription()), inputField.getName(), this.createArgType(inputField)));
        }
        return this.getFormattedString(FIELD_BLOCK_FORMAT, String.join((CharSequence)LINE_SEPARATOR, inputFields));
    }

    private String createPossibleTypes(Type type) {
        ArrayList<String> possibleTypes = new ArrayList<String>();
        for (Type possibleType : type.getPossibleTypes()) {
            possibleTypes.add(possibleType.getName());
        }
        return this.getFormattedString(POSSIBLE_TYPE_FORMAT, String.join((CharSequence)PIPE_SIGN, possibleTypes));
    }

    private String createArgs(List<InputValue> inputValues) {
        ArrayList<String> args = new ArrayList<String>();
        if (inputValues.isEmpty()) {
            return EMPTY_STRING;
        }
        boolean hasDescription = inputValues.stream().anyMatch(input -> input.getDescription() != null && !input.getDescription().isEmpty());
        if (hasDescription) {
            for (InputValue arg : inputValues) {
                args.add(this.getFormattedString(ARGS_VALUE_FORMAT, this.createArgDescription(arg.getDescription()), DOUBLE_INDENTATION, arg.getName(), this.createArgType(arg)));
            }
            return this.getFormattedString(ARGS_FORMAT, LINE_SEPARATOR, String.join((CharSequence)LINE_SEPARATOR, args), LINE_SEPARATOR, INDENTATION);
        }
        for (InputValue arg : inputValues) {
            args.add(this.getFormattedString(ARGS_VALUE_FORMAT, EMPTY_STRING, EMPTY_STRING, arg.getName(), this.createArgType(arg)));
        }
        return this.getFormattedString(ARGS_FORMAT, EMPTY_STRING, String.join((CharSequence)", ", args), EMPTY_STRING, EMPTY_STRING);
    }

    private String createFieldType(Type type) {
        if (type.getKind().equals((Object)TypeKind.NON_NULL)) {
            return this.getFormattedString(NON_NULL_FORMAT, this.createFieldType(type.getOfType()));
        }
        if (type.getKind().equals((Object)TypeKind.LIST)) {
            return this.getFormattedString(LIST_FORMAT, this.createFieldType(type.getOfType()));
        }
        return type.getName();
    }

    private String createArgType(InputValue arg) {
        if (arg.getDefaultValue() == null) {
            return this.createFieldType(arg.getType());
        }
        return this.getFormattedString(ARGS_TYPE_FORMAT, this.createFieldType(arg.getType()), arg.getDefaultValue());
    }

    private String createInterfaceImplements(Type type) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (type.getInterfaces().isEmpty()) {
            return EMPTY_STRING;
        }
        for (Type interfaceType : type.getInterfaces()) {
            interfaces.add(interfaceType.getName());
        }
        return this.getFormattedString(IMPLEMENT_FORMAT, String.join((CharSequence)" & ", interfaces));
    }

    private String createFieldDescription(String description) {
        if (description == null) {
            return EMPTY_STRING;
        }
        CharSequence[] lines = description.trim().split(LINE_SEPARATOR_REGEX);
        if (lines.length == 1) {
            return this.getFormattedString(DESC_FORMAT, this.getFormattedString(DOCUMENT_FORMAT, new String[]{INDENTATION, lines[0]}));
        }
        String formattedDesc = this.getFormattedString(BLOCK_STRING_FORMAT, INDENTATION, INDENTATION, String.join((CharSequence)(LINE_SEPARATOR + INDENTATION), lines), INDENTATION);
        return this.getFormattedString(DESC_FORMAT, formattedDesc);
    }

    private String createArgDescription(String description) {
        if (description == null) {
            return EMPTY_STRING;
        }
        CharSequence[] lines = description.trim().split(LINE_SEPARATOR_REGEX);
        if (lines.length == 1) {
            return this.getFormattedString(DESC_FORMAT, this.getFormattedString(DOCUMENT_FORMAT, new String[]{DOUBLE_INDENTATION, lines[0]}));
        }
        String formattedDesc = this.getFormattedString(BLOCK_STRING_FORMAT, DOUBLE_INDENTATION, DOUBLE_INDENTATION, String.join((CharSequence)(LINE_SEPARATOR + DOUBLE_INDENTATION), lines), DOUBLE_INDENTATION);
        return this.getFormattedString(DESC_FORMAT, formattedDesc);
    }

    private String createDirectiveLocation(List<DirectiveLocation> location) {
        ArrayList<String> locations = new ArrayList<String>();
        for (DirectiveLocation directiveLocation : location) {
            locations.add(directiveLocation.name());
        }
        return String.join((CharSequence)PIPE_SIGN, locations);
    }

    private String createDeprecate(EnumValue enumValue) {
        if (enumValue.isDeprecated()) {
            if (enumValue.getDeprecationReason() != null) {
                return this.getFormattedString(DEPRECATE_FORMAT, DEPRECATE, this.createDeprecateReason(enumValue.getDeprecationReason()));
            }
            return DEPRECATE;
        }
        return EMPTY_STRING;
    }

    private String createDeprecate(Field field) {
        if (field.isDeprecated()) {
            if (field.getDeprecationReason() != null) {
                return this.getFormattedString(DEPRECATE_FORMAT, DEPRECATE, this.createDeprecateReason(field.getDeprecationReason()));
            }
            return DEPRECATE;
        }
        return EMPTY_STRING;
    }

    private String createDeprecateReason(String reason) {
        return reason.replaceAll(LINE_SEPARATOR_REGEX, SPACE);
    }

    private String createSpecifiedByUrl(Type type) {
        return EMPTY_STRING;
    }

    private String createIsRepeatable(Directive directive) {
        if (this.isRepeatableFederatedDirective(directive)) {
            return REPEATABLE;
        }
        return EMPTY_STRING;
    }

    private boolean isRepeatableFederatedDirective(Directive directive) {
        Optional<FederatedDirective> filteredDirective = Arrays.stream(FederatedDirective.values()).filter(federatedDirective -> directive.getName().equals(federatedDirective.getName())).findFirst();
        if (filteredDirective.isEmpty()) {
            return false;
        }
        return filteredDirective.get().isRepeatable();
    }

    private Boolean isIntrospectionType(Type type) {
        for (IntrospectionType value : IntrospectionType.values()) {
            if (!value.getName().equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    private Boolean isBuiltInScalarType(Type type) {
        for (ScalarType value : ScalarType.values()) {
            if (!value.getName().equals(type.getName()) || !value.isInbuiltType().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Boolean isDefaultDirective(Directive directive) {
        for (DefaultDirective value : DefaultDirective.values()) {
            if (!value.getName().equals(directive.getName())) continue;
            return true;
        }
        return false;
    }

    private String getFormattedString(String format, String ... args) {
        return String.format(format, args);
    }
}

