/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.compiler;

import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.testerina.compiler.TestFunctionVisitor;
import org.ballerinalang.testerina.compiler.TesterinaCompilerPluginUtils;

public class TestExecutionModificationTask
implements ModifierTask<SourceModifierContext> {
    public void modify(SourceModifierContext modifierContext) {
        if (modifierContext.currentPackage().project().kind() != ProjectKind.SINGLE_FILE_PROJECT) {
            return;
        }
        for (ModuleId moduleId : modifierContext.currentPackage().moduleIds()) {
            Module module = modifierContext.currentPackage().module(moduleId);
            for (DocumentId documentId : module.documentIds()) {
                Document document = module.document(documentId);
                TextDocument updatedTextDocument = TestExecutionModificationTask.modifyDocument(document);
                modifierContext.modifySourceFile(updatedTextDocument, documentId);
            }
        }
    }

    private static TextDocument modifyDocument(Document document) {
        ArrayList<ModuleMemberDeclarationNode> functionsList = new ArrayList<ModuleMemberDeclarationNode>();
        ArrayList<StatementNode> statements = new ArrayList<StatementNode>();
        TesterinaCompilerPluginUtils.addExitCodeGlobalVariable(functionsList);
        TesterinaCompilerPluginUtils.addSetTestOptionsCall(statements);
        ModulePartNode node = (ModulePartNode)document.syntaxTree().rootNode();
        TestFunctionVisitor testFunctionVisitor = new TestFunctionVisitor();
        node.accept((NodeVisitor)testFunctionVisitor);
        AtomicInteger testIndex = new AtomicInteger(0);
        AtomicInteger group = new AtomicInteger(0);
        ArrayList<StatementNode> registrarStatements = new ArrayList<StatementNode>();
        TesterinaCompilerPluginUtils.traverseTestRegistrars(testIndex, group, registrarStatements, functionsList, testFunctionVisitor, statements);
        if (testIndex.get() > 0) {
            TesterinaCompilerPluginUtils.populateTestRegistrarStatements(group, registrarStatements, functionsList, statements);
        }
        TesterinaCompilerPluginUtils.addStartSuiteCall(statements);
        functionsList.add((ModuleMemberDeclarationNode)TesterinaCompilerPluginUtils.createTestExecutionFunction(statements));
        NodeList newMembers = node.members().addAll(functionsList);
        ModulePartNode newModulePart = node.modify(node.imports(), newMembers, node.eofToken());
        SyntaxTree updatedSyntaxTree = document.syntaxTree().modifyWith((Node)newModulePart);
        return updatedSyntaxTree.textDocument();
    }
}

