/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.extension.architecture;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.ballerina.architecturemodelgenerator.core.ArchitectureModel;
import io.ballerina.architecturemodelgenerator.core.ArchitectureModelBuilder;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelException;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticUtils;
import io.ballerina.architecturemodelgenerator.extension.Utils;
import io.ballerina.architecturemodelgenerator.extension.architecture.ArchitectureModelRequest;
import io.ballerina.architecturemodelgenerator.extension.architecture.ArchitectureModelResponse;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="projectDesignService")
public class ArchitectureModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<ArchitectureModelResponse> getProjectComponentModels(ArchitectureModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ArchitectureModelResponse response = new ArchitectureModelResponse();
            HashMap<String, JsonObject> componentModelMap = new HashMap<String, JsonObject>();
            for (String documentUri : request.getDocumentUris()) {
                DiagnosticMessage message;
                Path path = Path.of(documentUri, new String[0]);
                try {
                    Project project = this.getCurrentProject(path);
                    if (Utils.modelAlreadyExists(componentModelMap, project.currentPackage())) continue;
                    ArchitectureModelBuilder architectureModelBuilder = new ArchitectureModelBuilder();
                    ArchitectureModel projectModel = architectureModelBuilder.constructComponentModel(project.currentPackage());
                    Gson gson = new GsonBuilder().serializeNulls().create();
                    JsonObject componentModelJson = (JsonObject)gson.toJsonTree((Object)projectModel);
                    componentModelMap.put(projectModel.getId(), componentModelJson);
                }
                catch (ArchitectureModelException | EventSyncException | WorkspaceDocumentException e) {
                    message = DiagnosticMessage.ballerinaProjectNotFound((String)documentUri);
                    response.addDiagnostics(DiagnosticUtils.getDiagnosticResponse(List.of(message), response.getDiagnostics()));
                }
                catch (Exception e) {
                    message = DiagnosticMessage.failedToResolveBallerinaPackage((String)e.getMessage(), (String)Arrays.toString(e.getStackTrace()), (String)documentUri);
                    response.addDiagnostics(DiagnosticUtils.getDiagnosticResponse(List.of(message), response.getDiagnostics()));
                }
            }
            response.setComponentModels(componentModelMap);
            return response;
        });
    }

    private Project getCurrentProject(Path path) throws ArchitectureModelException, WorkspaceDocumentException, EventSyncException {
        Optional project = this.workspaceManager.project(path);
        if (project.isEmpty()) {
            return this.workspaceManager.loadProject(path);
        }
        return (Project)project.get();
    }
}

