/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.extension.persist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.ballerina.architecturemodelgenerator.core.ArchitectureModel;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelException;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticUtils;
import io.ballerina.architecturemodelgenerator.core.generators.entity.EntityModelGenerator;
import io.ballerina.architecturemodelgenerator.extension.persist.PersistERModelRequest;
import io.ballerina.architecturemodelgenerator.extension.persist.PersistERModelResponse;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="persistERGeneratorService")
public class PersistERModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<PersistERModelResponse> getPersistERModels(PersistERModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DiagnosticMessage message;
            PersistERModelResponse response = new PersistERModelResponse();
            Path path = Path.of(request.getDocumentUri(), new String[0]);
            AtomicBoolean hasDiagnosticErrors = new AtomicBoolean(false);
            Map entities = new HashMap();
            try {
                Project project = this.getCurrentProject(path);
                PackageCompilation currentPackageCompilation = project.currentPackage().getCompilation();
                EntityModelGenerator entityModelGenerator = new EntityModelGenerator(currentPackageCompilation, project.currentPackage().getDefaultModule());
                entities = entityModelGenerator.generate();
                if (currentPackageCompilation.diagnosticResult().hasErrors()) {
                    hasDiagnosticErrors.set(true);
                    ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
                    currentPackageCompilation.diagnosticResult().errors().forEach(diagnostic -> {
                        ArchitectureModelDiagnostic architectureModelDiagnostic = new ArchitectureModelDiagnostic(diagnostic.diagnosticInfo().code(), diagnostic.diagnosticInfo().messageFormat(), diagnostic.diagnosticInfo().severity(), diagnostic.location(), null);
                        diagnostics.add(architectureModelDiagnostic);
                    });
                    response.addDiagnostics(diagnostics);
                }
            }
            catch (ArchitectureModelException | EventSyncException | WorkspaceDocumentException e) {
                hasDiagnosticErrors.set(true);
                message = DiagnosticMessage.ballerinaProjectNotFound((String)path.toString());
                response.addDiagnostics(DiagnosticUtils.getDiagnosticResponse(List.of(message), response.getDiagnostics()));
            }
            catch (Exception e) {
                hasDiagnosticErrors.set(true);
                message = DiagnosticMessage.failedToResolveBallerinaPackage((String)path.toString(), (String)e.getMessage(), (String)Arrays.toString(e.getStackTrace()));
                response.addDiagnostics(DiagnosticUtils.getDiagnosticResponse(List.of(message), response.getDiagnostics()));
            }
            ArchitectureModel architectureModel = new ArchitectureModel("0.4.0", null, null, null, response.getDiagnostics(), new HashMap(), entities, null, hasDiagnosticErrors.get(), null);
            Gson gson = new GsonBuilder().serializeNulls().create();
            JsonObject persistERModel = (JsonObject)gson.toJsonTree((Object)architectureModel);
            response.setPersistERModels(persistERModel);
            return response;
        });
    }

    private Project getCurrentProject(Path path) throws ArchitectureModelException, WorkspaceDocumentException, EventSyncException {
        Optional project = this.workspaceManager.project(path);
        if (project.isEmpty()) {
            return this.workspaceManager.loadProject(path);
        }
        return (Project)project.get();
    }
}

