/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FtpFunctionValidator {
    private final SyntaxNodeAnalysisContext context;
    private final ServiceDeclarationNode serviceDeclarationNode;
    FunctionDefinitionNode onFileChange;

    public FtpFunctionValidator(SyntaxNodeAnalysisContext context, FunctionDefinitionNode onFileChange) {
        this.context = context;
        this.serviceDeclarationNode = (ServiceDeclarationNode)context.node();
        this.onFileChange = onFileChange;
    }

    public void validate() {
        if (Objects.isNull(this.onFileChange)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.NO_ON_FILE_CHANGE, (Location)this.serviceDeclarationNode.location());
        } else {
            if (!PluginUtils.isRemoteFunction(this.context, this.onFileChange)) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.METHOD_MUST_BE_REMOTE, (Location)this.onFileChange.location());
            }
            SeparatedNodeList parameters = this.onFileChange.functionSignature().parameters();
            this.validateFunctionArguments((SeparatedNodeList<ParameterNode>)parameters, this.onFileChange);
            this.validateReturnTypeErrorOrNil(this.onFileChange);
        }
    }

    private void validateFunctionArguments(SeparatedNodeList<ParameterNode> parameters, FunctionDefinitionNode functionDefinitionNode) {
        if (parameters.size() == 1) {
            this.validateSingleArgumentScenario(parameters);
        } else if (parameters.size() == 2) {
            this.validateTwoArgumentScenario(parameters, functionDefinitionNode);
        } else if (parameters.size() > 2) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.ONLY_PARAMS_ALLOWED, (Location)functionDefinitionNode.location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.MUST_HAVE_WATCHEVENT, (Location)functionDefinitionNode.location());
        }
    }

    private void validateTwoArgumentScenario(SeparatedNodeList<ParameterNode> parameters, FunctionDefinitionNode functionDefinitionNode) {
        ParameterNode firstParamNode = (ParameterNode)parameters.get(0);
        ParameterNode secondParamNode = (ParameterNode)parameters.get(1);
        SyntaxKind firstParamSyntaxKind = ((RequiredParameterNode)firstParamNode).typeName().kind();
        SyntaxKind secondParamSyntaxKind = ((RequiredParameterNode)secondParamNode).typeName().kind();
        if (firstParamSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) && secondParamSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
            this.validateCallerAndWatchEvent(firstParamNode, secondParamNode);
        } else if (firstParamSyntaxKind.equals((Object)SyntaxKind.INTERSECTION_TYPE_DESC) && secondParamSyntaxKind.equals((Object)SyntaxKind.INTERSECTION_TYPE_DESC)) {
            this.validateInvalidReadonlyArguments(firstParamNode, secondParamNode);
        } else if (firstParamSyntaxKind.equals((Object)SyntaxKind.INTERSECTION_TYPE_DESC)) {
            this.validateCallerAndReadonlyWatchEvent(firstParamNode, secondParamNode, secondParamSyntaxKind);
        } else if (secondParamSyntaxKind.equals((Object)SyntaxKind.INTERSECTION_TYPE_DESC)) {
            this.validateCallerAndReadonlyWatchEvent(secondParamNode, firstParamNode, firstParamSyntaxKind);
        } else if (firstParamSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
            this.validateInvalidArgument(firstParamNode, secondParamNode);
        } else if (secondParamSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
            this.validateInvalidArgument(secondParamNode, firstParamNode);
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_PARAMETERS, (Location)functionDefinitionNode.functionSignature().location());
        }
    }

    private void validateSingleArgumentScenario(SeparatedNodeList<ParameterNode> parameters) {
        ParameterNode paramNode = (ParameterNode)parameters.get(0);
        SyntaxKind paramSyntaxKind = ((RequiredParameterNode)paramNode).typeName().kind();
        if (!(paramSyntaxKind.equals((Object)SyntaxKind.INTERSECTION_TYPE_DESC) && this.validateIntersectionParam(paramNode) || paramSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) && this.validateWatchEventParam(paramNode))) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)paramNode.location());
        }
    }

    private void validateInvalidArgument(ParameterNode qualifiedRefParamNode, ParameterNode invalidParamNode) {
        if (this.validateCallerParam(qualifiedRefParamNode)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)invalidParamNode.location());
        } else if (this.validateWatchEventParam(qualifiedRefParamNode)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)invalidParamNode.location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)qualifiedRefParamNode.location());
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)invalidParamNode.location());
        }
    }

    private void validateCallerAndReadonlyWatchEvent(ParameterNode intersectionParamNode, ParameterNode secondParamNode, SyntaxKind secondParamSyntaxKind) {
        boolean intersectionParamWatchEvent = this.validateIntersectionParam(intersectionParamNode);
        boolean secondParamCaller = this.validateCallerParam(secondParamNode);
        if (!secondParamCaller && !intersectionParamWatchEvent) {
            boolean secondParamWatchEvent;
            if (secondParamSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) && (secondParamWatchEvent = this.validateWatchEventParam(secondParamNode))) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)intersectionParamNode.location());
                return;
            }
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)secondParamNode.location());
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)intersectionParamNode.location());
        } else if (!intersectionParamWatchEvent) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)intersectionParamNode.location());
        } else if (!secondParamCaller) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)secondParamNode.location());
        }
    }

    private void validateInvalidReadonlyArguments(ParameterNode firstParamNode, ParameterNode secondParamNode) {
        boolean firstParamWatchEvent = this.validateIntersectionParam(firstParamNode);
        if (!firstParamWatchEvent) {
            boolean secondParamWatchEvent = this.validateIntersectionParam(secondParamNode);
            if (!secondParamWatchEvent) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)secondParamNode.location());
            }
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)firstParamNode.location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)secondParamNode.location());
        }
    }

    private void validateCallerAndWatchEvent(ParameterNode firstParamNode, ParameterNode secondParamNode) {
        boolean firstParamCaller = this.validateCallerParam(firstParamNode);
        boolean secondParamWatchEvent = this.validateWatchEventParam(secondParamNode);
        if (firstParamCaller && secondParamWatchEvent) {
            return;
        }
        boolean firstParamWatchEvent = this.validateWatchEventParam(firstParamNode);
        boolean secondParamCaller = this.validateCallerParam(secondParamNode);
        if (secondParamCaller && firstParamWatchEvent) {
            return;
        }
        if (!firstParamCaller && secondParamWatchEvent) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)firstParamNode.location());
        } else if (!secondParamCaller && firstParamWatchEvent) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)secondParamNode.location());
        } else if (firstParamCaller) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)secondParamNode.location());
        } else if (secondParamCaller) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)firstParamNode.location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)firstParamNode.location());
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_WATCHEVENT_PARAMETER, (Location)secondParamNode.location());
        }
    }

    private boolean validateIntersectionParam(ParameterNode parameterNode) {
        IntersectionTypeSymbol intersectionTypeSymbol;
        boolean watchEventExists;
        ParameterSymbol parameterSymbol;
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
        SemanticModel semanticModel = this.context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)requiredParameterNode);
        return symbol.isPresent() && (parameterSymbol = (ParameterSymbol)symbol.get()).typeDescriptor() instanceof IntersectionTypeSymbol && (watchEventExists = (intersectionTypeSymbol = (IntersectionTypeSymbol)parameterSymbol.typeDescriptor()).memberTypeDescriptors().stream().anyMatch(typeSymbol -> typeSymbol.nameEquals("WatchEvent") && typeSymbol.getModule().isPresent() && PluginUtils.validateModuleId((ModuleSymbol)typeSymbol.getModule().get())));
    }

    private boolean validateWatchEventParam(ParameterNode parameterNode) {
        Optional moduleSymbol;
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
        Node parameterTypeNode = requiredParameterNode.typeName();
        SemanticModel semanticModel = this.context.semanticModel();
        Optional paramSymbol = semanticModel.symbol(parameterTypeNode);
        if (paramSymbol.isPresent() && (moduleSymbol = ((Symbol)paramSymbol.get()).getModule()).isPresent()) {
            String paramName;
            String string = paramName = ((Symbol)paramSymbol.get()).getName().isPresent() ? (String)((Symbol)paramSymbol.get()).getName().get() : "";
            if (PluginUtils.validateModuleId((ModuleSymbol)moduleSymbol.get()) && paramName.equals("WatchEvent")) {
                return true;
            }
        }
        return false;
    }

    private boolean validateCallerParam(ParameterNode parameterNode) {
        Optional moduleSymbol;
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
        Node parameterTypeNode = requiredParameterNode.typeName();
        SemanticModel semanticModel = this.context.semanticModel();
        Optional paramSymbol = semanticModel.symbol(parameterTypeNode);
        if (paramSymbol.isPresent() && (moduleSymbol = ((Symbol)paramSymbol.get()).getModule()).isPresent()) {
            String paramName;
            String string = paramName = ((Symbol)paramSymbol.get()).getName().isPresent() ? (String)((Symbol)paramSymbol.get()).getName().get() : "";
            if (PluginUtils.validateModuleId((ModuleSymbol)moduleSymbol.get()) && paramName.equals("Caller")) {
                return true;
            }
        }
        return false;
    }

    private void validateReturnTypeErrorOrNil(FunctionDefinitionNode functionDefinitionNode) {
        Optional returnTypeDesc;
        MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(this.context, functionDefinitionNode);
        if (methodSymbol != null && (returnTypeDesc = methodSymbol.typeDescriptor().returnTypeDescriptor()).isPresent()) {
            if (((TypeSymbol)returnTypeDesc.get()).typeKind() == TypeDescKind.NIL) {
                return;
            }
            if (((TypeSymbol)returnTypeDesc.get()).typeKind() == TypeDescKind.UNION) {
                List returnTypeMembers = ((UnionTypeSymbol)returnTypeDesc.get()).memberTypeDescriptors();
                for (TypeSymbol returnType : returnTypeMembers) {
                    if (returnType.typeKind() == TypeDescKind.NIL) continue;
                    if (returnType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                        if (returnType.signature().equals("error") || PluginUtils.validateModuleId((ModuleSymbol)returnType.getModule().get())) continue;
                        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)functionDefinitionNode.functionSignature().location());
                        continue;
                    }
                    if (returnType.typeKind() == TypeDescKind.ERROR) continue;
                    this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)functionDefinitionNode.functionSignature().location());
                }
            } else {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)functionDefinitionNode.functionSignature().location());
            }
        }
    }

    public void reportErrorDiagnostic(PluginConstants.CompilationErrors error, Location location) {
        this.context.reportDiagnostic(PluginUtils.getDiagnostic(error, DiagnosticSeverity.ERROR, location));
    }
}

