/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.FtpServiceValidator;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;
import java.util.Optional;

public class FtpServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final FtpServiceValidator serviceValidator = new FtpServiceValidator();

    public void perform(SyntaxNodeAnalysisContext context) {
        List diagnostics = context.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        if (!this.isFtpService(context)) {
            return;
        }
        this.serviceValidator.validate(context);
    }

    private boolean isFtpService(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationNode serviceDeclarationNode;
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)(serviceDeclarationNode = (ServiceDeclarationNode)context.node()));
        if (symbol.isPresent()) {
            ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)symbol.get();
            List listeners = serviceDeclarationSymbol.listenerTypes();
            for (TypeSymbol listener : listeners) {
                if (this.isFtpListener(listener)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isFtpListener(TypeSymbol listener) {
        boolean isFtpListener = false;
        if (listener.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)listener;
            List members = unionTypeSymbol.memberTypeDescriptors();
            for (TypeSymbol memberSymbol : members) {
                Optional module = memberSymbol.getModule();
                if (!module.isPresent()) continue;
                isFtpListener = PluginUtils.validateModuleId((ModuleSymbol)module.get());
            }
        } else {
            Optional module = listener.getModule();
            if (module.isPresent()) {
                isFtpListener = PluginUtils.validateModuleId((ModuleSymbol)module.get());
            }
        }
        return isFtpListener;
    }
}

