/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.lib.data.yaml.compiler.YamlDataDiagnosticCodes;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class YamlDataTypeValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private SemanticModel semanticModel;
    private final HashMap<Location, DiagnosticInfo> allDiagnosticInfo = new HashMap();
    Location currentLocation;
    private String modulePrefix = "yaml";

    public void perform(SyntaxNodeAnalysisContext ctx) {
        this.semanticModel = ctx.semanticModel();
        List diagnostics = this.semanticModel.diagnostics();
        boolean erroneousCompilation = diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (erroneousCompilation) {
            return;
        }
        ModulePartNode rootNode = (ModulePartNode)ctx.node();
        for (ImportDeclarationNode importDeclarationNode : rootNode.imports()) {
            ModuleSymbol moduleSymbol;
            Optional symbol = this.semanticModel.symbol((Node)importDeclarationNode);
            if (!symbol.isPresent() || ((Symbol)symbol.get()).kind() != SymbolKind.MODULE || !YamlDataTypeValidator.isYamlImport(moduleSymbol = (ModuleSymbol)symbol.get())) continue;
            this.modulePrefix = moduleSymbol.id().modulePrefix();
            break;
        }
        NodeList members = rootNode.members();
        block6: for (int i = 0; i < members.size(); ++i) {
            ModuleMemberDeclarationNode member = (ModuleMemberDeclarationNode)members.get(i);
            switch (member.kind()) {
                case FUNCTION_DEFINITION: {
                    this.processFunctionDefinitionNode((FunctionDefinitionNode)member, ctx);
                    continue block6;
                }
                case MODULE_VAR_DECL: {
                    this.processModuleVariableDeclarationNode((ModuleVariableDeclarationNode)member, ctx);
                    continue block6;
                }
                case TYPE_DEFINITION: {
                    this.processTypeDefinitionNode((TypeDefinitionNode)member, ctx);
                    continue block6;
                }
            }
        }
    }

    private void processFunctionDefinitionNode(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        ChildNodeList childNodeList = functionDefinitionNode.functionBody().children();
        for (Node node : childNodeList) {
            VariableDeclarationNode variableDeclarationNode;
            Optional initializer;
            if (node.kind() != SyntaxKind.LOCAL_VAR_DECL || (initializer = (variableDeclarationNode = (VariableDeclarationNode)node).initializer()).isEmpty()) continue;
            this.currentLocation = variableDeclarationNode.typedBindingPattern().typeDescriptor().location();
            Optional symbol = this.semanticModel.symbol((Node)variableDeclarationNode.typedBindingPattern());
            if (symbol.isEmpty()) continue;
            TypeSymbol typeSymbol = ((VariableSymbol)symbol.get()).typeDescriptor();
            if (!this.isParseFunctionOfStringSource((ExpressionNode)initializer.get())) {
                this.checkTypeAndDetectDuplicateFields(typeSymbol, ctx);
                continue;
            }
            this.validateExpectedType(typeSymbol, ctx);
        }
    }

    private void checkTypeAndDetectDuplicateFields(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext ctx) {
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                this.detectDuplicateFields((RecordTypeSymbol)typeSymbol, ctx);
                break;
            }
            case ARRAY: {
                this.checkTypeAndDetectDuplicateFields(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), ctx);
                break;
            }
            case TUPLE: {
                for (TypeSymbol memberType : ((TupleTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    this.checkTypeAndDetectDuplicateFields(memberType, ctx);
                }
                break;
            }
            case UNION: {
                for (TypeSymbol memberType : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    this.checkTypeAndDetectDuplicateFields(memberType, ctx);
                }
                break;
            }
            case TYPE_REFERENCE: {
                this.checkTypeAndDetectDuplicateFields(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), ctx);
                break;
            }
            case INTERSECTION: {
                this.checkTypeAndDetectDuplicateFields(YamlDataTypeValidator.getRawType(typeSymbol), ctx);
            }
        }
    }

    private boolean isParseFunctionOfStringSource(ExpressionNode expressionNode) {
        if (expressionNode.kind() == SyntaxKind.CHECK_EXPRESSION) {
            expressionNode = ((CheckExpressionNode)expressionNode).expression();
        }
        if (expressionNode.kind() != SyntaxKind.FUNCTION_CALL) {
            return false;
        }
        NameReferenceNode nameReferenceNode = ((FunctionCallExpressionNode)expressionNode).functionName();
        if (nameReferenceNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        String prefix = ((QualifiedNameReferenceNode)nameReferenceNode).modulePrefix().text();
        if (!prefix.equals(this.modulePrefix)) {
            return false;
        }
        String functionName = ((FunctionCallExpressionNode)expressionNode).functionName().toString().trim();
        return functionName.contains("parseString") || functionName.contains("parseBytes") || functionName.contains("parseStream");
    }

    private void validateExpectedType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext ctx) {
        typeSymbol.getLocation().ifPresent(location -> {
            this.currentLocation = location;
        });
        switch (typeSymbol.typeKind()) {
            case UNION: {
                this.validateUnionType((UnionTypeSymbol)typeSymbol, ctx);
                break;
            }
            case RECORD: {
                this.validateRecordType((RecordTypeSymbol)typeSymbol, ctx);
                break;
            }
            case ARRAY: {
                this.validateExpectedType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), ctx);
                break;
            }
            case TUPLE: {
                this.validateTupleType((TupleTypeSymbol)typeSymbol, ctx);
                break;
            }
            case TABLE: 
            case XML: {
                this.reportDiagnosticInfo(ctx, typeSymbol.getLocation(), YamlDataDiagnosticCodes.UNSUPPORTED_TYPE);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateExpectedType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), ctx);
                break;
            }
            case INTERSECTION: {
                this.validateExpectedType(YamlDataTypeValidator.getRawType(typeSymbol), ctx);
                break;
            }
        }
    }

    private void validateTupleType(TupleTypeSymbol tupleTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        for (TypeSymbol memberType : tupleTypeSymbol.memberTypeDescriptors()) {
            this.validateExpectedType(memberType, ctx);
        }
        Optional restTypeSymbol = tupleTypeSymbol.restTypeDescriptor();
        restTypeSymbol.ifPresent(typeSymbol -> this.validateExpectedType((TypeSymbol)typeSymbol, ctx));
    }

    private void validateRecordType(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        ArrayList<String> fieldMembers = new ArrayList<String>();
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            this.currentLocation = fieldSymbol.getLocation().orElseGet(() -> this.currentLocation);
            this.validateExpectedType(fieldSymbol.typeDescriptor(), ctx);
            String name = this.getNameFromAnnotation((String)entry.getKey(), fieldSymbol.annotAttachments());
            if (fieldMembers.contains(name)) {
                this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), YamlDataDiagnosticCodes.DUPLICATE_FIELD);
                continue;
            }
            fieldMembers.add(name);
        }
    }

    private void validateUnionType(UnionTypeSymbol unionTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        List memberTypeSymbols = unionTypeSymbol.memberTypeDescriptors();
        for (TypeSymbol memberTypeSymbol : memberTypeSymbols) {
            this.validateExpectedType(YamlDataTypeValidator.getRawType(memberTypeSymbol), ctx);
        }
    }

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return YamlDataTypeValidator.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return YamlDataTypeValidator.getRawType(((TypeReferenceTypeSymbol)typeDescriptor).typeDescriptor());
        }
        return typeDescriptor;
    }

    private void reportDiagnosticInfo(SyntaxNodeAnalysisContext ctx, Optional<Location> location, YamlDataDiagnosticCodes diagnosticsCodes) {
        Location pos = location.orElseGet(() -> this.currentLocation);
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticsCodes.getCode(), diagnosticsCodes.getMessage(), diagnosticsCodes.getSeverity());
        if (pos == null || this.allDiagnosticInfo.containsKey(pos) && this.allDiagnosticInfo.get(pos).equals((Object)diagnosticInfo)) {
            return;
        }
        this.allDiagnosticInfo.put(pos, diagnosticInfo);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)pos, (Object[])new Object[0]));
    }

    private void processModuleVariableDeclarationNode(ModuleVariableDeclarationNode moduleVariableDeclarationNode, SyntaxNodeAnalysisContext ctx) {
        Optional initializer = moduleVariableDeclarationNode.initializer();
        if (initializer.isEmpty() || !this.isParseFunctionOfStringSource((ExpressionNode)initializer.get())) {
            return;
        }
        this.semanticModel.symbol((Node)moduleVariableDeclarationNode.typedBindingPattern()).ifPresent(symbol -> this.validateExpectedType(((VariableSymbol)symbol).typeDescriptor(), ctx));
    }

    private void processTypeDefinitionNode(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        Node typeDescriptor = typeDefinitionNode.typeDescriptor();
        if (typeDescriptor.kind() != SyntaxKind.RECORD_TYPE_DESC) {
            return;
        }
        this.validateRecordTypeDefinition(typeDefinitionNode, ctx);
    }

    private void validateRecordTypeDefinition(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        this.semanticModel.symbol((Node)typeDefinitionNode).map(symbol -> (TypeDefinitionSymbol)symbol).ifPresent(typeDefinitionSymbol -> this.detectDuplicateFields((RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor(), ctx));
    }

    private void detectDuplicateFields(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        ArrayList<String> fieldMembers = new ArrayList<String>();
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            String name = this.getNameFromAnnotation((String)entry.getKey(), fieldSymbol.annotAttachments());
            if (fieldMembers.contains(name)) {
                this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), YamlDataDiagnosticCodes.DUPLICATE_FIELD);
                continue;
            }
            fieldMembers.add(name);
        }
    }

    private String getNameFromAnnotation(String fieldName, List<AnnotationAttachmentSymbol> annotationAttachments) {
        for (AnnotationAttachmentSymbol annotAttSymbol : annotationAttachments) {
            String value;
            Optional nameAnnot;
            AnnotationSymbol annotation = annotAttSymbol.typeDescriptor();
            if (!this.getAnnotModuleName(annotation).equals("data.yaml") || (nameAnnot = annotation.getName()).isEmpty() || !(value = (String)nameAnnot.get()).equals("Name")) continue;
            return ((LinkedHashMap)((ConstantValue)annotAttSymbol.attachmentValue().orElseThrow()).value()).get("value").toString();
        }
        return fieldName;
    }

    private String getAnnotModuleName(AnnotationSymbol annotation) {
        return annotation.getModule().flatMap(Symbol::getName).orElse("");
    }

    private static boolean isYamlImport(ModuleSymbol moduleSymbol) {
        return "ballerina".equals(moduleSymbol.id().orgName()) && "data.yaml".equals(moduleSymbol.id().moduleName());
    }
}

