/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.coordination;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.coordination.DatabaseConfig;
import io.ballerina.stdlib.task.coordination.HealthCheckScheduler;
import io.ballerina.stdlib.task.server.TaskServerJob;
import io.ballerina.stdlib.task.utils.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

public final class TokenAcquisition {
    public static final BString DB_HOST = StringUtils.fromString((String)"host");
    public static final BString DB_USER = StringUtils.fromString((String)"user");
    public static final BString DB_PASSWORD = StringUtils.fromString((String)"password");
    public static final BString DB_PORT = StringUtils.fromString((String)"port");
    public static final BString DATABASE = StringUtils.fromString((String)"database");
    public static final BString DB_TYPE = StringUtils.fromString((String)"dbType");
    public static final BString DATABASE_CONFIG = StringUtils.fromString((String)"databaseConfig");
    public static final BString STATUS = StringUtils.fromString((String)"status");
    public static final BString ACTIVE_STATUS = StringUtils.fromString((String)"active");
    public static final BString STANDBY_STATUS = StringUtils.fromString((String)"standby");
    public static final BString TASK_ID = StringUtils.fromString((String)"taskId");
    public static final BString GROUP_ID = StringUtils.fromString((String)"groupId");
    public static final BString TOKEN_HOLDER = StringUtils.fromString((String)"tokenholder");
    public static final BString HEARTBEAT_FREQUENCY = StringUtils.fromString((String)"heartbeatFrequency");
    public static final BString LIVENESS_CHECK_INTERVAL = StringUtils.fromString((String)"livenessCheckInterval");
    public static final String LAST_HEARTBEAT = "last_heartbeat";
    public static final String ID = "task_id";
    public static final String DB_TYPE_POSTGRESQL = "postgresql";
    public static final String DB_TYPE_MYSQL = "mysql";
    public static final String POSTGRESQL_JDBC_URL = "jdbc:postgresql://%s:%d/%s";
    public static final String MYSQL_JDBC_URL = "jdbc:mysql://%s:%d/%s";
    public static final String HAS_ACTIVE_TOKEN_QUERY = "SELECT task_id FROM token_holder WHERE task_id = ? AND group_id = ?";
    public static final String GET_CURRENT_TOKEN_QUERY = "SELECT task_id FROM token_holder WHERE group_id = ?";
    public static final String CURRENT_TIMESTAMP_QUERY = "SELECT CURRENT_TIMESTAMP";
    public static final String HEALTH_CHECK_QUERY = "SELECT last_heartbeat FROM health_check WHERE task_id = ? AND group_id = ? ORDER BY last_heartbeat DESC LIMIT 1";
    public static final String POSTGRESQL_UPSERT_TOKEN_QUERY = "INSERT INTO token_holder(task_id, group_id, term) VALUES (?, ?, 1) ON CONFLICT (group_id) DO UPDATE SET task_id = EXCLUDED.task_id, term = token_holder.term + 1";
    public static final String MYSQL_UPSERT_TOKEN_QUERY = "INSERT INTO token_holder(task_id, group_id, term) VALUES (?, ?, 1) ON DUPLICATE KEY UPDATE task_id = VALUES(task_id), term = term + 1";
    public static final String POSTGRESQL_CONFIG = "PostgresqlConfig";

    private TokenAcquisition() {
    }

    public static Object acquireToken(BMap<Object, Object> databaseConfig, BString id, BString groupId, boolean tokenAcquired, int livenessInterval, int heartbeatFrequency) throws SQLException {
        String dbType;
        String string = dbType = TypeUtils.getType(databaseConfig).getName().contains(POSTGRESQL_CONFIG) ? DB_TYPE_POSTGRESQL : DB_TYPE_MYSQL;
        if (databaseConfig.containsKey((Object)DB_TYPE)) {
            dbType = databaseConfig.getStringValue(DB_TYPE).getValue().toLowerCase();
        }
        DatabaseConfig dbConfig = new DatabaseConfig(databaseConfig.getStringValue(DB_HOST).getValue(), databaseConfig.getStringValue(DB_USER).getValue(), databaseConfig.getStringValue(DB_PASSWORD).getValue(), databaseConfig.getIntValue(DB_PORT).intValue(), databaseConfig.getStringValue(DATABASE).getValue(), dbType);
        Connection connection = null;
        try {
            String instanceId = id.getValue();
            String jdbcUrl = TokenAcquisition.getJdbcUrl(dbConfig);
            connection = DriverManager.getConnection(jdbcUrl, dbConfig.user(), dbConfig.password());
            connection.setAutoCommit(false);
            tokenAcquired = TokenAcquisition.attemptTokenAcquisition(connection, instanceId, groupId.getValue(), tokenAcquired, livenessInterval, dbType);
            connection.commit();
            HealthCheckScheduler.startHealthCheckUpdater(dbConfig, instanceId, groupId.getValue(), heartbeatFrequency);
            return TokenAcquisition.generateResponse(tokenAcquired, livenessInterval, instanceId, groupId.getValue(), dbConfig);
        }
        catch (Exception e) {
            TaskServerJob.handleRollback(connection);
            throw Utils.createTaskError(e.getMessage());
        }
    }

    public static String getJdbcUrl(DatabaseConfig dbConfig) {
        String dbType = dbConfig.dbType();
        if (DB_TYPE_MYSQL.equals(dbType)) {
            return String.format(MYSQL_JDBC_URL, dbConfig.host(), dbConfig.port(), dbConfig.database());
        }
        return String.format(POSTGRESQL_JDBC_URL, dbConfig.host(), dbConfig.port(), dbConfig.database());
    }

    private static BMap<BString, Object> generateResponse(boolean tokenAcquired, int interval, String instanceId, String groupId, DatabaseConfig databaseConfig) {
        BMap response = ValueCreator.createMapValue();
        response.put((Object)STATUS, (Object)(tokenAcquired ? ACTIVE_STATUS : STANDBY_STATUS));
        response.put((Object)TASK_ID, (Object)StringUtils.fromString((String)instanceId));
        response.put((Object)GROUP_ID, (Object)StringUtils.fromString((String)groupId));
        response.put((Object)TOKEN_HOLDER, (Object)tokenAcquired);
        response.put((Object)DATABASE_CONFIG, (Object)databaseConfig);
        response.put((Object)LIVENESS_CHECK_INTERVAL, (Object)interval);
        return response;
    }

    public static boolean hasActiveToken(Connection connection, String taskId, String groupId) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement(HAS_ACTIVE_TOKEN_QUERY);){
            stmt.setString(1, taskId);
            stmt.setString(2, groupId);
            ResultSet rs = stmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
    }

    public static boolean attemptTokenAcquisition(Connection connection, String taskId, String groupId, boolean hasToken, int livenessInterval, String dbType) throws SQLException {
        boolean acquiredToken = hasToken;
        try (PreparedStatement stmt = connection.prepareStatement(GET_CURRENT_TOKEN_QUERY);){
            stmt.setString(1, groupId);
            ResultSet result = stmt.executeQuery();
            if (!result.next()) {
                String upsertQuery = DB_TYPE_MYSQL.equals(dbType) ? MYSQL_UPSERT_TOKEN_QUERY : POSTGRESQL_UPSERT_TOKEN_QUERY;
                PreparedStatement upsertStmt = connection.prepareStatement(upsertQuery);
                upsertStmt.setString(1, taskId);
                upsertStmt.setString(2, groupId);
                upsertStmt.executeUpdate();
                boolean bl = true;
                return bl;
            }
            String existingTokenId = result.getString(ID);
            if (existingTokenId.equals(taskId)) {
                boolean upsertStmt = true;
                return upsertStmt;
            }
            try (PreparedStatement currentTimeStmt = connection.prepareStatement(CURRENT_TIMESTAMP_QUERY);){
                ResultSet timeResult = currentTimeStmt.executeQuery();
                Timestamp currentTime = timeResult.next() ? timeResult.getTimestamp(1) : Timestamp.from(Instant.now());
                PreparedStatement healthStmt = connection.prepareStatement(HEALTH_CHECK_QUERY);
                healthStmt.setString(1, existingTokenId);
                healthStmt.setString(2, groupId);
                ResultSet healthCheckRs = healthStmt.executeQuery();
                if (healthCheckRs.next()) {
                    Timestamp lastHeartbeat = healthCheckRs.getTimestamp(LAST_HEARTBEAT);
                    long timeDiffSeconds = (currentTime.getTime() - lastHeartbeat.getTime()) / 1000L;
                    if (timeDiffSeconds > (long)livenessInterval) {
                        String upsertQuery = DB_TYPE_MYSQL.equals(dbType) ? MYSQL_UPSERT_TOKEN_QUERY : POSTGRESQL_UPSERT_TOKEN_QUERY;
                        PreparedStatement upsertStmt = connection.prepareStatement(upsertQuery);
                        upsertStmt.setString(1, taskId);
                        upsertStmt.setString(2, groupId);
                        upsertStmt.executeUpdate();
                        acquiredToken = true;
                    }
                } else {
                    String upsertQuery = DB_TYPE_MYSQL.equals(dbType) ? MYSQL_UPSERT_TOKEN_QUERY : POSTGRESQL_UPSERT_TOKEN_QUERY;
                    PreparedStatement upsertStmt = connection.prepareStatement(upsertQuery);
                    upsertStmt.setString(1, taskId);
                    upsertStmt.setString(2, groupId);
                    upsertStmt.executeUpdate();
                    acquiredToken = true;
                }
            }
        }
        return acquiredToken;
    }
}

