/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.listener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.listener.TaskListener;
import io.ballerina.stdlib.task.objects.TaskManager;
import io.ballerina.stdlib.task.utils.ModuleUtils;
import io.ballerina.stdlib.task.utils.Utils;
import java.util.Map;

public class ListenerAction {
    private static final String NATIVE_LISTENER_KEY = "TASK_NATIVE_LISTENER";
    private static final String LISTENER_NOT_INITIALIZED_ERROR = "Listener not initialized";
    private static final BString TRIGGER = StringUtils.fromString((String)"trigger");
    private static final BString INTERVAL = StringUtils.fromString((String)"interval");
    private static final BString MAX_COUNT = StringUtils.fromString((String)"maxCount");
    private static final BString START_TIME = StringUtils.fromString((String)"startTime");
    private static final BString END_TIME = StringUtils.fromString((String)"endTime");
    private static final BString TASK_POLICY = StringUtils.fromString((String)"taskPolicy");
    public static final BString WARM_BACKUP_CONFIG = StringUtils.fromString((String)"warmBackupConfig");
    public static final BString RETRY_CONFIG = StringUtils.fromString((String)"retryConfig");
    public static final BString MAX_ATTEMPTS = StringUtils.fromString((String)"maxAttempts");
    public static final BString BACKOFF_STRATEGY = StringUtils.fromString((String)"backoffStrategy");
    public static final BString RETRY_INTERVAL = StringUtils.fromString((String)"retryInterval");
    public static final BString MAX_INTERVAL = StringUtils.fromString((String)"maxInterval");
    public static final String GET_TIME_IN_MILLISECONDS = "getTimeInMillies";

    private ListenerAction() {
    }

    public static Object initListener(BObject listener, BMap<BString, Object> listenerConfig) {
        BMap configs = listenerConfig.getMapValue(TRIGGER);
        TaskListener taskListener = new TaskListener(TaskManager.getInstance());
        taskListener.setConfigs(configs);
        BMap warmBackupConfig = listenerConfig.getMapValue(WARM_BACKUP_CONFIG);
        if (warmBackupConfig != null) {
            taskListener.setConfig(WARM_BACKUP_CONFIG, warmBackupConfig);
        }
        BMap retryConfig = configs.getMapValue(RETRY_CONFIG);
        taskListener.setConfig(RETRY_CONFIG, retryConfig);
        listener.addNativeData(NATIVE_LISTENER_KEY, (Object)taskListener);
        return null;
    }

    public static Object start(Environment environment, BObject listenerObj) {
        block5: {
            TaskListener listener = (TaskListener)listenerObj.getNativeData(NATIVE_LISTENER_KEY);
            try {
                if (listener != null) {
                    Object startTime = ListenerAction.civilToMillisIfNeeded(environment, listener.getConfig().get((Object)START_TIME));
                    Object endTime = ListenerAction.civilToMillisIfNeeded(environment, listener.getConfig().get((Object)END_TIME));
                    Object retryConfig = listener.getConfig().get((Object)RETRY_CONFIG);
                    if (listener.getConfig().containsKey((Object)WARM_BACKUP_CONFIG)) {
                        BMap warmBackupConfig = (BMap)listener.getConfig().get((Object)WARM_BACKUP_CONFIG);
                        listener.start(environment, listenerObj, (BDecimal)listener.getConfig().get((Object)INTERVAL), (Long)listener.getConfig().get((Object)MAX_COUNT), startTime, endTime, (BMap<BString, Object>)((BMap)listener.getConfig().get((Object)TASK_POLICY)), warmBackupConfig, retryConfig);
                    } else {
                        listener.start(environment, listenerObj, (BDecimal)listener.getConfig().get((Object)INTERVAL), (Long)listener.getConfig().get((Object)MAX_COUNT), startTime, endTime, (BMap<BString, Object>)((BMap)listener.getConfig().get((Object)TASK_POLICY)), retryConfig);
                    }
                    break block5;
                }
                return Utils.createTaskError(LISTENER_NOT_INITIALIZED_ERROR);
            }
            catch (Exception e) {
                return Utils.createTaskError(e.getMessage());
            }
        }
        return null;
    }

    private static Object civilToMillisIfNeeded(Environment env, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Object[] arguments = new Object[]{value};
        StrandMetadata strandMetadata = new StrandMetadata(true, null);
        Object result = env.getRuntime().callFunction(ModuleUtils.getModule(), GET_TIME_IN_MILLISECONDS, strandMetadata, arguments);
        if (result instanceof Throwable) {
            Throwable errorResult = (Throwable)result;
            throw new Exception("Error converting civil to milliseconds: " + errorResult.getMessage());
        }
        return result;
    }

    public static Object attachService(BObject listenerObj, BObject service, BString serviceName) {
        TaskListener listener = (TaskListener)listenerObj.getNativeData(NATIVE_LISTENER_KEY);
        service.addNativeData("jobId", (Object)serviceName);
        listener.registerService(serviceName.getValue(), service);
        return null;
    }

    public static Object detach(BObject listenerObj, BObject service) {
        try {
            TaskListener listener = (TaskListener)listenerObj.getNativeData(NATIVE_LISTENER_KEY);
            listener.unregisterService(service);
            return null;
        }
        catch (Exception e) {
            return Utils.createTaskError(e.getMessage());
        }
    }

    public static Object gracefulStop(BObject listenerObj) {
        try {
            TaskListener listener = (TaskListener)listenerObj.getNativeData(NATIVE_LISTENER_KEY);
            Map<String, BObject> services = listener.getServices();
            for (String entry : services.keySet()) {
                listener.getTaskManager().unScheduleJob(entry);
            }
            listener.unregisterAllServices();
        }
        catch (Exception e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }
}

