/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.objects;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.task.coordination.TokenAcquisition;
import io.ballerina.stdlib.task.exceptions.SchedulingException;
import io.ballerina.stdlib.task.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class TaskManager {
    public static final String TOKEN_HOLDER = "tokenholder";
    public static final String TASK_ID = "taskId";
    public static final String GROUP_ID = "groupId";
    public static final String DATABASE_CONFIG = "databaseConfig";
    public static final String LIVENESS_CHECK_INTERVAL = "livenessCheckInterval";
    public static final String INTERVAL = "interval";
    public static final String MAX_COUNT = "maxCount";
    public static final String MAX_ATTEMPTS = "maxAttempts";
    public static final String BACKOFF_STRATEGY = "backoffStrategy";
    public static final String RETRY_INTERVAL = "retryInterval";
    public static final String MAX_INTERVAL = "maxInterval";
    private Scheduler scheduler;
    private Runtime runtime = null;
    Map<Integer, JobDetail> jobInfoMap = new HashMap<Integer, JobDetail>();
    Map<Integer, Trigger> triggerInfoMap = new ConcurrentHashMap<Integer, Trigger>();
    Map<String, JobDetail> serviceInfoMap = new HashMap<String, JobDetail>();
    Map<String, Trigger> serviceTriggerInfoMap = new ConcurrentHashMap<String, Trigger>();
    Properties properties;
    boolean isConfiguredSchFactory = false;

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        return TaskManagerHelper.INSTANCE;
    }

    public void initializeScheduler(Properties properties, Environment env) throws SchedulingException, SchedulerException {
        this.getAllRunningJobs();
        this.getAllRunningServices();
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (!this.triggerInfoMap.isEmpty() || !this.serviceTriggerInfoMap.isEmpty()) {
            this.configureScheduler(properties, env);
        } else {
            this.properties = properties;
            this.isConfiguredSchFactory = true;
        }
    }

    public void rescheduleJobs() throws SchedulerException {
        this.startScheduler();
        for (Map.Entry<Integer, Trigger> entry : this.triggerInfoMap.entrySet()) {
            this.scheduler.scheduleJob(this.jobInfoMap.get(entry.getKey()), entry.getValue());
        }
    }

    public void rescheduleServiceJobs() throws SchedulerException {
        this.startScheduler();
        for (Map.Entry<String, Trigger> entry : this.serviceTriggerInfoMap.entrySet()) {
            this.scheduler.scheduleJob(this.serviceInfoMap.get(entry.getKey()), entry.getValue());
        }
    }

    public Scheduler getScheduler(Properties properties, Environment env) throws SchedulingException, SchedulerException {
        if (this.isConfiguredSchFactory) {
            this.scheduler = Utils.initializeScheduler(this.properties);
            this.isConfiguredSchFactory = false;
            this.setRuntime(env.getRuntime());
        } else if (this.scheduler == null || this.scheduler.isShutdown()) {
            this.scheduler = Utils.initializeScheduler(properties);
            this.setRuntime(env.getRuntime());
        }
        return this.scheduler;
    }

    private void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public Map<Integer, Trigger> getTriggerInfoMap() {
        return this.triggerInfoMap;
    }

    public Set<Integer> getAllRunningJobs() throws SchedulerException {
        for (Map.Entry<Integer, Trigger> entry : this.triggerInfoMap.entrySet()) {
            Trigger.TriggerState triggerState = this.scheduler.getTriggerState(entry.getValue().getKey());
            if (triggerState == null || !this.isTriggerCompleted(triggerState)) continue;
            this.triggerInfoMap.remove(entry.getKey());
        }
        return this.triggerInfoMap.keySet();
    }

    public Set<String> getAllRunningServices() throws SchedulerException {
        for (Map.Entry<String, Trigger> entry : this.serviceTriggerInfoMap.entrySet()) {
            Trigger.TriggerState triggerState = this.scheduler.getTriggerState(entry.getValue().getKey());
            if (triggerState == null || !this.isTriggerCompleted(triggerState)) continue;
            this.serviceTriggerInfoMap.remove(entry.getKey());
        }
        return this.serviceTriggerInfoMap.keySet();
    }

    public void scheduleOneTimeJob(JobDataMap jobDataMap, long time, Integer jobId) throws SchedulerException {
        this.scheduleJob(Utils.createJob(jobDataMap, jobId.toString()), Utils.getOneTimeTrigger(time, "trigger"), jobId);
    }

    public void scheduleListenerIntervalJob(JobDataMap jobDataMap, long interval, long maxCount, Object startTime, Object endTime, String waitingPolicy, String jobId, BObject service) throws SchedulerException {
        jobDataMap.put("job", (Object)service);
        JobDetail job = Utils.createListenerJob(jobDataMap, jobId);
        Trigger trigger = Utils.getIntervalTrigger(interval, maxCount, startTime, endTime, waitingPolicy, "trigger");
        this.scheduleListenerJob(job, trigger, jobId);
    }

    public void scheduleIntervalJob(JobDataMap jobDataMap, long interval, long maxCount, Object startTime, Object endTime, String waitingPolicy, Integer jobId) throws SchedulerException {
        JobDetail job = Utils.createJob(jobDataMap, jobId.toString());
        Trigger trigger = Utils.getIntervalTrigger(interval, maxCount, startTime, endTime, waitingPolicy, "trigger");
        this.scheduleJob(job, trigger, jobId);
    }

    private void scheduleJob(JobDetail job, Trigger trigger, Integer jobId) throws SchedulerException {
        this.scheduler.scheduleJob(job, trigger);
        this.triggerInfoMap.put(jobId, trigger);
        this.jobInfoMap.put(jobId, job);
        this.startScheduler();
    }

    private void scheduleListenerJob(JobDetail job, Trigger trigger, String jobId) throws SchedulerException {
        this.scheduler.scheduleJob(job, trigger);
        this.serviceTriggerInfoMap.put(jobId, trigger);
        this.serviceInfoMap.put(jobId, job);
        this.startScheduler();
    }

    public void scheduleListenerIntervalJobWithTokenCheck(JobDataMap jobDataMap, long interval, long maxCount, Object startTime, Object endTime, String waitingPolicy, String jobId, BMap response, BObject service) throws SchedulerException {
        jobDataMap.put("job", (Object)service);
        jobDataMap.put(TOKEN_HOLDER, (Object)response.getBooleanValue(TokenAcquisition.TOKEN_HOLDER));
        jobDataMap.put(TASK_ID, (Object)response.getStringValue(TokenAcquisition.TASK_ID));
        jobDataMap.put(GROUP_ID, (Object)response.getStringValue(TokenAcquisition.GROUP_ID));
        jobDataMap.put(DATABASE_CONFIG, response.get((Object)TokenAcquisition.DATABASE_CONFIG));
        jobDataMap.put(LIVENESS_CHECK_INTERVAL, response.get((Object)TokenAcquisition.LIVENESS_CHECK_INTERVAL));
        JobDetail job = Utils.createListenerJob(jobDataMap, jobId);
        Trigger trigger = Utils.getIntervalTrigger(interval, maxCount, startTime, endTime, waitingPolicy, "trigger");
        this.scheduleListenerJob(job, trigger, jobId);
    }

    private void startScheduler() throws SchedulerException {
        if (!this.scheduler.isStarted()) {
            this.scheduler.start();
        }
    }

    public void unScheduleJob(Integer jobId) throws SchedulerException, SchedulingException {
        this.scheduler.unscheduleJob(this.getTrigger(jobId).getKey());
        if (this.getAllRunningJobs().isEmpty()) {
            this.scheduler.shutdown();
        }
    }

    public void unScheduleJob(String serviceId) throws SchedulerException {
        if (this.serviceTriggerInfoMap.containsKey(serviceId)) {
            this.scheduler.unscheduleJob(this.serviceTriggerInfoMap.get(serviceId).getKey());
            if (this.getAllRunningServices().isEmpty()) {
                this.scheduler.shutdown();
            }
        }
    }

    public void pause() throws SchedulerException {
        this.scheduler.pauseAll();
    }

    public void resume() throws SchedulerException {
        this.scheduler.resumeAll();
    }

    public void pauseJob(Integer jobId) throws SchedulerException, SchedulingException {
        this.scheduler.pauseJob(this.getTrigger(jobId).getJobKey());
    }

    public void resumeJob(Integer jobId) throws SchedulerException, SchedulingException {
        this.scheduler.resumeJob(this.getTrigger(jobId).getJobKey());
    }

    private boolean isTriggerCompleted(Trigger.TriggerState triggerState) {
        return triggerState.equals((Object)Trigger.TriggerState.COMPLETE) || triggerState.equals((Object)Trigger.TriggerState.NONE);
    }

    private void configureScheduler(Properties properties, Environment env) throws SchedulerException, SchedulingException {
        this.scheduler = Utils.initializeScheduler(properties);
        this.setRuntime(env.getRuntime());
        if (!this.triggerInfoMap.isEmpty()) {
            this.rescheduleJobs();
        }
        if (!this.serviceTriggerInfoMap.isEmpty()) {
            this.rescheduleServiceJobs();
        }
    }

    private Trigger getTrigger(Integer jobId) throws SchedulingException {
        if (this.triggerInfoMap.get(jobId) == null) {
            throw new SchedulingException("Invalid job id: " + jobId);
        }
        return this.triggerInfoMap.get(jobId);
    }

    private static class TaskManagerHelper {
        private static final TaskManager INSTANCE = new TaskManager();

        private TaskManagerHelper() {
        }
    }
}

