/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.server;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.coordination.DatabaseConfig;
import io.ballerina.stdlib.task.coordination.TokenAcquisition;
import io.ballerina.stdlib.task.objects.TaskManager;
import io.ballerina.stdlib.task.utils.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class TaskServerJob
implements Job {
    public static final String GROUP_ID = "groupId";
    public static final String EXPONENTIAL_STRATEGY = "EXPONENTIAL";

    public void execute(JobExecutionContext jobExecutionContext) {
        Thread.startVirtualThread(() -> {
            Runtime runtime = TaskManager.getInstance().getRuntime();
            Boolean isTokenHolder = (Boolean)jobExecutionContext.getMergedJobDataMap().get((Object)"tokenholder");
            BObject job = (BObject)jobExecutionContext.getMergedJobDataMap().get((Object)"job");
            if (isTokenHolder == null) {
                this.executeJob(job, runtime, jobExecutionContext);
                return;
            }
            DatabaseConfig dbConfig = (DatabaseConfig)jobExecutionContext.getMergedJobDataMap().get((Object)"databaseConfig");
            String taskId = ((BString)jobExecutionContext.getMergedJobDataMap().get((Object)"taskId")).getValue();
            String groupId = ((BString)jobExecutionContext.getMergedJobDataMap().get((Object)GROUP_ID)).getValue();
            String jdbcUrl = TokenAcquisition.getJdbcUrl(dbConfig);
            this.processJobWithCoordination(job, runtime, jobExecutionContext, isTokenHolder, taskId, groupId, jdbcUrl, dbConfig);
        });
    }

    private void processJobWithCoordination(BObject job, Runtime runtime, JobExecutionContext jobExecutionContext, boolean isTokenHolder, String taskId, String groupId, String jdbcUrl, DatabaseConfig dbConfig) {
        Connection connection = null;
        boolean deadStatus = false;
        try {
            connection = DriverManager.getConnection(jdbcUrl, dbConfig.user(), dbConfig.password());
        }
        catch (Exception e) {
            deadStatus = true;
        }
        try {
            if (!deadStatus) {
                connection.setAutoCommit(false);
                boolean shouldExecuteJob = this.checkAndUpdateTokenStatus(connection, jobExecutionContext, taskId, groupId, isTokenHolder, dbConfig);
                connection.commit();
                if (shouldExecuteJob) {
                    this.executeJob(job, runtime, jobExecutionContext);
                }
            }
        }
        catch (SQLException e) {
            this.handleExecutionException(connection, jobExecutionContext, ErrorCreator.createError((BString)StringUtils.fromString((String)("Database error: " + e.getMessage()))));
        }
        catch (BError error) {
            this.handleExecutionException(connection, jobExecutionContext, error);
        }
        catch (Throwable t) {
            this.handleExecutionException(connection, jobExecutionContext, ErrorCreator.createError((Throwable)t));
        }
    }

    private boolean checkAndUpdateTokenStatus(Connection connection, JobExecutionContext jobExecutionContext, String taskId, String groupId, boolean isTokenHolder, DatabaseConfig dbConfig) throws SQLException {
        if (isTokenHolder) {
            return TokenAcquisition.hasActiveToken(connection, taskId, groupId);
        }
        int livenessInterval = (Integer)jobExecutionContext.getMergedJobDataMap().get((Object)"livenessCheckInterval");
        return TokenAcquisition.attemptTokenAcquisition(connection, taskId, groupId, false, livenessInterval, dbConfig.dbType());
    }

    private void handleExecutionException(Connection connection, JobExecutionContext jobExecutionContext, BError error) {
        try {
            TaskServerJob.handleRollback(connection);
            Utils.notifyFailure(jobExecutionContext, error);
        }
        catch (SQLException e) {
            Utils.notifyFailure(jobExecutionContext, error);
        }
    }

    private void executeJob(BObject job, Runtime runtime, JobExecutionContext jobExecutionContext) {
        ObjectType type = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)job));
        boolean isConcurrentSafe = type.isIsolated() && type.isIsolated("execute");
        StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, null);
        Object result = runtime.callMethod(job, "execute", metadata, new Object[0]);
        if (result instanceof BError) {
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            if (this.shouldRetry((Map<String, Object>)jobDataMap)) {
                Long maxCount = (Long)jobDataMap.get((Object)"maxCount");
                jobExecutionContext.getMergedJobDataMap().put("maxCount", maxCount - 1L);
                result = this.executeWithRetry(job, runtime, (Map<String, Object>)jobDataMap, metadata);
            }
            if (result instanceof BError) {
                Utils.notifyFailure(jobExecutionContext, (BError)((Object)result));
            }
        }
    }

    private Object executeWithRetry(BObject job, Runtime runtime, Map<String, Object> jobDataMap, StrandMetadata metadata) {
        Long maxAttempts = (Long)jobDataMap.get("maxAttempts");
        String backoffStrategy = jobDataMap.get("backoffStrategy").toString();
        Long retryInterval = (Long)jobDataMap.get("retryInterval");
        Long maxInterval = (Long)jobDataMap.get("maxInterval");
        Object result = null;
        long startTime = System.currentTimeMillis();
        long currentInterval = retryInterval;
        BDecimal taskInterval = (BDecimal)jobDataMap.get("interval");
        int attempt = 0;
        while ((long)attempt < maxAttempts) {
            TaskServerJob.setTimeout(currentInterval);
            if (maxInterval != null && (currentInterval > maxInterval || currentInterval >= taskInterval.intValue()) || (double)(System.currentTimeMillis() - startTime) >= taskInterval.floatValue() * 1000.0) break;
            result = runtime.callMethod(job, "execute", metadata, new Object[0]);
            currentInterval = this.calculateNextInterval(backoffStrategy, currentInterval, retryInterval, maxInterval);
            if (!(result instanceof BError)) break;
            ++attempt;
        }
        return result;
    }

    private long calculateNextInterval(String backoffStrategy, long currentInterval, long retryInterval, Object maxInterval) {
        return switch (backoffStrategy) {
            case EXPONENTIAL_STRATEGY -> {
                if (maxInterval != null) {
                    yield Math.min(currentInterval * 2L, (Long)maxInterval);
                }
                yield currentInterval * 2L;
            }
            default -> retryInterval;
        };
    }

    private boolean shouldRetry(Map<String, Object> jobDataMap) {
        BDecimal taskInterval = (BDecimal)jobDataMap.get("interval");
        if (!jobDataMap.containsKey("retryInterval")) {
            return false;
        }
        Long retryInterval = (Long)jobDataMap.get("retryInterval");
        if (retryInterval > taskInterval.intValue()) {
            return false;
        }
        Long maxAttempts = (Long)jobDataMap.get("maxAttempts");
        return maxAttempts != null && maxAttempts > 0L;
    }

    public static void setTimeout(long retryInterval) {
        try {
            Thread.sleep(retryInterval * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void handleRollback(Connection connection) throws SQLException {
        if (connection != null) {
            connection.rollback();
        }
    }
}

