/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.utils;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.task.objects.TaskManager;
import io.ballerina.stdlib.task.utils.Utils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class TaskJob
implements Job {
    public void execute(JobExecutionContext jobExecutionContext) {
        Thread.startVirtualThread(() -> {
            Runtime runtime = TaskManager.getInstance().getRuntime();
            BObject job = (BObject)jobExecutionContext.getMergedJobDataMap().get((Object)"job");
            try {
                ObjectType objectType = (ObjectType)job.getOriginalType();
                boolean isConcurrentSafe = objectType.isIsolated() && objectType.isIsolated("execute");
                StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, null);
                runtime.callMethod(job, "execute", metadata, new Object[0]);
            }
            catch (BError error) {
                Utils.notifyFailure(jobExecutionContext, error);
            }
            catch (Throwable t) {
                Utils.notifyFailure(jobExecutionContext, ErrorCreator.createError((Throwable)t));
            }
        });
    }
}

