/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ListenerInitExpressionNodeVisitor
extends NodeVisitor {
    private final List<ImplicitNewExpressionNode> implicitNewExpressionNodes = new ArrayList<ImplicitNewExpressionNode>();
    private final List<ExplicitNewExpressionNode> explicitNewExpressionNodes = new ArrayList<ExplicitNewExpressionNode>();
    private SyntaxNodeAnalysisContext ctx;

    public ListenerInitExpressionNodeVisitor(SyntaxNodeAnalysisContext ctx) {
        this.ctx = ctx;
    }

    public void visit(ImplicitNewExpressionNode node) {
        ListenerDeclarationNode parentNode;
        Optional parentTypeOpt;
        if (node.parent() instanceof ListenerDeclarationNode && (parentTypeOpt = (parentNode = (ListenerDeclarationNode)node.parent()).typeDescriptor()).isPresent()) {
            TypeSymbol typeSymbol;
            QualifiedNameReferenceNode parentType = (QualifiedNameReferenceNode)parentTypeOpt.get();
            Optional parentSymbolOpt = this.ctx.semanticModel().symbol((Node)parentType);
            if (parentSymbolOpt.isPresent() && parentSymbolOpt.get() instanceof TypeReferenceTypeSymbol && (typeSymbol = ((TypeReferenceTypeSymbol)parentSymbolOpt.get()).typeDescriptor()).typeKind() == TypeDescKind.OBJECT) {
                ObjectTypeSymbol objectSymbol = (ObjectTypeSymbol)typeSymbol;
                Optional<ModuleID> moduleId = objectSymbol.getModule().map(ModuleSymbol::id);
                String identifier = objectSymbol.getName().orElse("");
                if (moduleId.isPresent() && this.isWebSocketListener(moduleId.get(), identifier)) {
                    this.implicitNewExpressionNodes.add(node);
                }
            }
        }
    }

    public void visit(ExplicitNewExpressionNode node) {
        if (node.typeDescriptor() instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode nameRef = (QualifiedNameReferenceNode)node.typeDescriptor();
            Optional symbolOpt = this.ctx.semanticModel().symbol((Node)nameRef);
            if (symbolOpt.isPresent() && symbolOpt.get() instanceof TypeReferenceTypeSymbol) {
                TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)symbolOpt.get()).typeDescriptor();
                Optional<ModuleID> moduleId = typeDescriptor.getModule().map(ModuleSymbol::id);
                String identifier = typeDescriptor.getName().orElse("");
                if (moduleId.isPresent() && this.isWebSocketListener(moduleId.get(), identifier)) {
                    this.explicitNewExpressionNodes.add(node);
                }
            }
        }
    }

    private boolean isWebSocketListener(ModuleID moduleID, String identifier) {
        String orgName = moduleID.orgName();
        String packagePrefix = moduleID.modulePrefix();
        return "websocket".equals(packagePrefix) && "ballerina".equals(orgName) && "Listener".equals(identifier);
    }

    List<ImplicitNewExpressionNode> getImplicitNewExpressionNodes() {
        return this.implicitNewExpressionNodes;
    }

    List<ExplicitNewExpressionNode> getExplicitNewExpressionNodes() {
        return this.explicitNewExpressionNodes;
    }
}

