/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.websocket.plugin.PluginConstants;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Utils {
    public static final String PREFIX = "ballerina/websocket:";
    public static final String CALLER = "Caller";
    public static final String BYTE_ARRAY = "byte[]";
    public static final String STRING = "string";
    public static final String INT = "int";
    public static final String ERROR = "Error";
    public static final String GENERIC_ERROR = "error";
    public static final String OPTIONAL = "?";
    public static final String NODE_LOCATION = "node.location";

    public static String getPrefix(SyntaxNodeAnalysisContext ctx) {
        ModulePartNode modulePartNode = (ModulePartNode)ctx.syntaxTree().rootNode();
        for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
            if (((IdentifierToken)importDeclaration.moduleName().get(0)).toString().split(" ")[0].compareTo("websocket") != 0) continue;
            if (!importDeclaration.prefix().isPresent()) break;
            return ((ImportPrefixNode)importDeclaration.prefix().get()).children().get(1).toString();
        }
        return "websocket";
    }

    public static void validateOnOpenFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        for (ParameterSymbol inputParam : inputParams) {
            String paramSignature;
            if (inputParams.isEmpty() || (paramSignature = inputParam.typeDescriptor().signature()).startsWith(PREFIX) && paramSignature.endsWith(CALLER)) continue;
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_PARAMS_FOR_ON_OPEN, resourceNode.location(), resourceNode.location(), "websocket");
        }
        TypeSymbol returnTypeSymbol = (TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get();
        Utils.validateOnDataReturnTypes(returnTypeSymbol, "onOpen", resourceNode, ctx);
    }

    public static void validateOnBinaryMessageFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() == 1 && !((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature().equals(BYTE_ARRAY)) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_BINARY_WITH_ONE_PARAMS, resourceNode.location(), resourceNode.location(), ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature());
        } else {
            for (ParameterSymbol inputParam : inputParams) {
                String moduleId = Utils.getModuleId(inputParam);
                String paramSignature = inputParam.typeDescriptor().signature();
                if (paramSignature.equals(BYTE_ARRAY) || paramSignature.equals(moduleId + ":Caller") || inputParam.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION && paramSignature.contains(BYTE_ARRAY)) continue;
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_BINARY, resourceNode.location(), paramSignature);
            }
        }
        TypeSymbol returnStatement = (TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get();
        Utils.validateOnDataReturnTypes(returnStatement, "onBinaryMessage", resourceNode, ctx);
    }

    static void validateOnTextMessageFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() == 1 && !((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature().equals(STRING)) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_TEXT_WITH_ONE_PARAMS, resourceNode.location(), ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature());
        } else {
            for (ParameterSymbol inputParam : inputParams) {
                String moduleId = Utils.getModuleId(inputParam);
                String paramSignature = inputParam.typeDescriptor().signature();
                if (paramSignature.equals(STRING) || paramSignature.equals(moduleId + ":Caller")) continue;
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_TEXT, resourceNode.location(), paramSignature);
            }
        }
        TypeSymbol returnStatement = (TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get();
        Utils.validateOnDataReturnTypes(returnStatement, "onTextMessage", resourceNode, ctx);
    }

    public static void validateOnDataReturnTypes(TypeSymbol returnTypeSymbol, String functionName, FunctionDefinitionNode resourceNode, SyntaxNodeAnalysisContext ctx) {
        if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            for (TypeSymbol symbol : ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors()) {
                if (symbol.typeKind() == TypeDescKind.ERROR || symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && symbol.signature().contains(ERROR) || symbol.typeKind() == TypeDescKind.NIL || symbol.typeKind() == TypeDescKind.STRING || symbol.typeKind() == TypeDescKind.ARRAY || symbol.typeKind() == TypeDescKind.STREAM) continue;
                Utils.repoteDiagnostics(functionName, resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_ON_DATA, symbol.signature());
            }
            Utils.validateContradictingReturnTypes(returnTypeSymbol, functionName, resourceNode, ctx);
        } else if (returnTypeSymbol.typeKind() != TypeDescKind.NIL && returnTypeSymbol.typeKind() != TypeDescKind.ARRAY && returnTypeSymbol.typeKind() != TypeDescKind.STRING) {
            Utils.repoteDiagnostics(functionName, resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_ON_DATA, returnTypeSymbol.signature());
        }
    }

    public static void validateContradictingReturnTypes(TypeSymbol returnTypeSymbol, String functionName, FunctionDefinitionNode resourceNode, SyntaxNodeAnalysisContext ctx) {
        boolean hasStreamType = false;
        boolean hasOtherType = false;
        for (TypeSymbol symbol : ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors()) {
            if (symbol.typeKind() == TypeDescKind.STREAM) {
                hasStreamType = true;
                continue;
            }
            if (symbol.typeKind() == TypeDescKind.ERROR) continue;
            hasOtherType = true;
        }
        if (hasStreamType && hasOtherType) {
            Utils.repoteDiagnostics(functionName, resourceNode, ctx, PluginConstants.CompilationErrors.CONTRADICTING_RETURN_TYPES, returnTypeSymbol.signature());
        }
    }

    static void validateOnErrorFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() == 1) {
            ParameterSymbol inputParam = (ParameterSymbol)inputParams.get(0);
            String moduleId = Utils.getModuleId(inputParam);
            String inputParamTypeDescSignature = inputParam.typeDescriptor().signature();
            if (!inputParamTypeDescSignature.contains(GENERIC_ERROR) && !inputParamTypeDescSignature.equals(moduleId + ":Error")) {
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_ERROR_WITH_ONE_PARAMS, resourceNode.location(), inputParamTypeDescSignature);
            }
        } else {
            for (ParameterSymbol inputParam : inputParams) {
                String moduleId = Utils.getModuleId(inputParam);
                String paramSignature = inputParam.typeDescriptor().signature();
                if (paramSignature.contains(GENERIC_ERROR) || paramSignature.equals(moduleId + ":Caller") || paramSignature.equals(moduleId + ":Error")) continue;
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_ERROR, resourceNode.location(), paramSignature);
            }
        }
        Utils.validateErrorReturnTypes((TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get(), "onError", resourceNode, ctx);
    }

    private static void validateErrorReturnTypes(TypeSymbol returnTypeSymbol, String functionName, FunctionDefinitionNode resourceNode, SyntaxNodeAnalysisContext ctx) {
        if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            for (TypeSymbol symbol : ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors()) {
                if (symbol.typeKind() == TypeDescKind.ERROR || symbol.typeKind() == TypeDescKind.NIL || symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && symbol.signature().endsWith(SyntaxKind.COLON_TOKEN.stringValue() + ERROR)) continue;
                Utils.repoteDiagnostics(String.format("%s%s%s%s", "websocket", ":", ERROR, OPTIONAL), resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES, functionName);
            }
        } else if (returnTypeSymbol.typeKind() != TypeDescKind.NIL) {
            Utils.repoteDiagnostics(String.format("%s%s%s%s", "websocket", ":", ERROR, OPTIONAL), resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES, functionName);
        }
    }

    static void validateOnCloseFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() > 3 || inputParams.size() < 1) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_PARAMS_FOR_ON_CLOSE, resourceNode.location(), new Object[0]);
        } else if (inputParams.size() == 1 && ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature().equals(STRING)) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ONCLOSE_WITH_ONE_PARAMS, resourceNode.location(), ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature());
        } else {
            for (ParameterSymbol inputParam : inputParams) {
                String moduleId = Utils.getModuleId(inputParam);
                String paramSignature = inputParam.typeDescriptor().signature();
                if (paramSignature.equals(STRING) || paramSignature.equals(moduleId + ":Caller") || paramSignature.equals(INT)) continue;
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_PARAM_FOR_ON_CLOSE, resourceNode.location(), paramSignature);
            }
        }
        Utils.validateErrorReturnTypes((TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get(), "onClose", resourceNode, ctx);
    }

    public static void reportDiagnostics(SyntaxNodeAnalysisContext context, PluginConstants.CompilationErrors error, NodeLocation location, Object ... args) {
        String errorMessage = error.getError();
        String diagnosticCode = error.getErrorCode();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode, errorMessage, DiagnosticSeverity.ERROR);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        context.reportDiagnostic(diagnostic);
    }

    static void validateOnIdleTimeoutFunction(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() > 1) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_PARAMS_FOR_ON_IDLE_TIMEOUT, resourceNode.location(), new Object[0]);
        } else if (!(inputParams.size() != 1 || ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature().endsWith(":Caller") && ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature().startsWith(PREFIX))) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_PARAM_FOR_ON_IDLE_TIMEOUT, resourceNode.location(), ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature());
        }
        Utils.validateErrorReturnTypes((TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get(), "onIdleTimeout", resourceNode, ctx);
    }

    static void validateOnDataFunctions(FunctionTypeSymbol functionTypeSymbol, SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceNode) {
        List inputParams = (List)functionTypeSymbol.params().get();
        if (inputParams.size() == 1) {
            ParameterSymbol inputParam = (ParameterSymbol)inputParams.get(0);
            TypeDescKind kind = inputParam.typeDescriptor().typeKind();
            String paramSignature = inputParam.typeDescriptor().signature();
            if (!Utils.isValidInput(Utils.getModuleId(inputParam), paramSignature, kind) && ((ParameterSymbol)inputParams.get(0)).signature().contains(":Caller")) {
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_MESSAGE, resourceNode.location(), resourceNode.functionName(), ((ParameterSymbol)inputParams.get(0)).typeDescriptor().signature());
            }
        } else {
            for (ParameterSymbol inputParam : inputParams) {
                TypeDescKind kind;
                String paramSignature;
                String moduleId = Utils.getModuleId(inputParam);
                if (!Utils.isValidInput(moduleId, paramSignature = inputParam.typeDescriptor().signature(), kind = inputParam.typeDescriptor().typeKind())) continue;
                Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_INPUT_FOR_ON_MESSAGE, resourceNode.location(), resourceNode.functionName(), paramSignature);
            }
        }
        TypeSymbol returnStatement = (TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get();
        Utils.validateOnTextReturnTypes(returnStatement, "onTextMessage", resourceNode, ctx);
    }

    private static boolean isValidInput(String moduleId, String paramSignature, TypeDescKind kind) {
        return !kind.isStringType() && !paramSignature.equals(moduleId + ":Caller") && !kind.isXMLType() && !kind.equals((Object)TypeDescKind.JSON) && !kind.equals((Object)TypeDescKind.TYPE_REFERENCE) && !kind.equals((Object)TypeDescKind.ARRAY) && !kind.equals((Object)TypeDescKind.BOOLEAN) && !kind.equals((Object)TypeDescKind.INT) && !kind.equals((Object)TypeDescKind.DECIMAL) && !kind.equals((Object)TypeDescKind.FLOAT) && !kind.equals((Object)TypeDescKind.INTERSECTION) && !kind.equals((Object)TypeDescKind.ANYDATA) && !kind.equals((Object)TypeDescKind.UNION);
    }

    public static void validateOnTextReturnTypes(TypeSymbol returnTypeSymbol, String functionName, FunctionDefinitionNode resourceNode, SyntaxNodeAnalysisContext ctx) {
        if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            for (TypeSymbol symbol : ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors()) {
                if (!Utils.isInvalidReturnType(symbol)) continue;
                Utils.repoteDiagnostics(functionName, resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_ON_DATA, symbol.signature());
            }
            Utils.validateContradictingReturnTypes(returnTypeSymbol, functionName, resourceNode, ctx);
        } else if (Utils.isInvalidReturnType(returnTypeSymbol)) {
            Utils.repoteDiagnostics(functionName, resourceNode, ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_ON_DATA, returnTypeSymbol.signature());
        }
    }

    private static void repoteDiagnostics(String functionName, FunctionDefinitionNode resourceNode, SyntaxNodeAnalysisContext ctx, PluginConstants.CompilationErrors invalidReturnTypesOnData, String signature) {
        Utils.reportDiagnostics(ctx, invalidReturnTypesOnData, resourceNode.location(), signature, functionName);
    }

    private static boolean isInvalidReturnType(TypeSymbol symbol) {
        List<TypeDescKind> validReturnTypes = Arrays.asList(TypeDescKind.ERROR, TypeDescKind.TYPE_REFERENCE, TypeDescKind.STREAM, TypeDescKind.NIL, TypeDescKind.STRING, TypeDescKind.ARRAY, TypeDescKind.INT, TypeDescKind.BOOLEAN, TypeDescKind.DECIMAL, TypeDescKind.JSON, TypeDescKind.XML, TypeDescKind.FLOAT);
        return !validReturnTypes.contains(symbol.typeKind());
    }

    private static String getModuleId(ParameterSymbol inputParam) {
        String moduleId = "websocket";
        if (inputParam.typeDescriptor().typeKind() == TypeDescKind.TYPE_REFERENCE || inputParam.typeDescriptor().typeKind() == TypeDescKind.ERROR) {
            moduleId = ((ModuleSymbol)inputParam.typeDescriptor().getModule().get()).id().toString();
        }
        return moduleId;
    }

    public static boolean isWithinRange(LineRange lineRange, LinePosition pos) {
        int sLine = lineRange.startLine().line();
        int sCol = lineRange.startLine().offset();
        int eLine = lineRange.endLine().line();
        int eCol = lineRange.endLine().offset();
        return sLine == eLine && pos.line() == sLine && pos.offset() >= sCol && pos.offset() <= eCol || sLine != eLine && (pos.line() > sLine && pos.line() < eLine || pos.line() == eLine && pos.offset() <= eCol || pos.line() == sLine && pos.offset() >= sCol);
    }

    public static boolean equals(String actual, String expected) {
        return actual.compareTo(expected) == 0;
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        if (lineRange == null) {
            return null;
        }
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static LineRange getLineRange(CodeActionExecutionContext codeActionExecutionContext) {
        LineRange lineRange = null;
        for (CodeActionArgument argument : codeActionExecutionContext.arguments()) {
            if (!NODE_LOCATION.equals(argument.key())) continue;
            lineRange = (LineRange)argument.valueAs(LineRange.class);
        }
        return lineRange;
    }

    public static List<DocumentEdit> getDocumentEdits(CodeActionExecutionContext codeActionExecutionContext, String text) {
        TextRange onTextMessageTextRange;
        LineRange lineRange = Utils.getLineRange(codeActionExecutionContext);
        if (lineRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = codeActionExecutionContext.currentDocument().syntaxTree();
        NonTerminalNode node = Utils.findNode(syntaxTree, lineRange);
        if (!(node instanceof ClassDefinitionNode)) {
            return Collections.emptyList();
        }
        ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (classDefinitionNode.members().isEmpty()) {
            onTextMessageTextRange = TextRange.from((int)classDefinitionNode.openBrace().textRange().endOffset(), (int)(classDefinitionNode.closeBrace().textRange().startOffset() - classDefinitionNode.openBrace().textRange().endOffset()));
        } else {
            Node lastMember = classDefinitionNode.members().get(classDefinitionNode.members().size() - 1);
            onTextMessageTextRange = TextRange.from((int)lastMember.textRange().endOffset(), (int)(classDefinitionNode.closeBrace().textRange().startOffset() - lastMember.textRange().endOffset()));
        }
        textEdits.add(TextEdit.from((TextRange)onTextMessageTextRange, (String)text));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        return Collections.singletonList(new DocumentEdit(codeActionExecutionContext.fileUri(), SyntaxTree.from((SyntaxTree)syntaxTree, (TextDocumentChange)change)));
    }

    public static Optional<CodeActionInfo> getCodeActionInfo(CodeActionContext codeActionContext, String codeAction) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        if (diagnostic.location() == null) {
            return Optional.empty();
        }
        CodeActionArgument locationArg = CodeActionArgument.from((String)NODE_LOCATION, (Object)diagnostic.location().lineRange());
        return Optional.of(CodeActionInfo.from((String)codeAction, List.of(locationArg)));
    }
}

