/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websocket.plugin.PluginConstants;
import io.ballerina.stdlib.websocket.plugin.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;
import java.util.stream.Collectors;

public class WebSocketServiceValidator {
    public static final String GENERIC_FUNCTION = "generic function";
    private SyntaxNodeAnalysisContext ctx;

    WebSocketServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        this.ctx = syntaxNodeAnalysisContext;
    }

    public void validate() {
        ClassDefinitionNode classDefNode = (ClassDefinitionNode)this.ctx.node();
        Map<String, Boolean> functionSet = classDefNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).map(node -> {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            NodeList qualifierList = functionDefinitionNode.qualifierList();
            if (qualifierList.isEmpty()) {
                return GENERIC_FUNCTION;
            }
            String qualifier = ((Token)qualifierList.get(0)).text();
            if (qualifier.equals(Qualifier.REMOTE.getValue())) {
                this.filterRemoteFunctions(functionDefinitionNode);
                return functionDefinitionNode.functionName().toString();
            }
            if (qualifier.equals(Qualifier.RESOURCE.getValue())) {
                this.reportInvalidFunction(functionDefinitionNode);
            }
            return GENERIC_FUNCTION;
        }).collect(Collectors.toMap(node -> node, node -> true, (node1, node2) -> node1));
        if (functionSet.containsKey("onMessage") && functionSet.containsKey("onTextMessage")) {
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTIONS, classDefNode.location(), "onTextMessage");
        }
        if (functionSet.containsKey("onMessage") && functionSet.containsKey("onBinaryMessage")) {
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTIONS, classDefNode.location(), "onBinaryMessage");
        }
        if (!functionSet.containsKey("onTextMessage") && !functionSet.containsKey("onMessage")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_TEXT_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onBinaryMessage") && !functionSet.containsKey("onMessage")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_BINARY_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onClose")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_CLOSE_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onOpen")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_OPEN_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onPing")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_PING_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onPong")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_PONG_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onIdleTimeout")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_IDLE_TIMEOUT_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onError")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_ERROR_GENERATION_HINT);
        }
        if (!(functionSet.containsKey("onMessage") || functionSet.containsKey("onTextMessage") || functionSet.containsKey("onBinaryMessage"))) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_MESSAGE_GENERATION_HINT);
        }
    }

    private void filterRemoteFunctions(FunctionDefinitionNode functionDefinitionNode) {
        FunctionTypeSymbol functionTypeSymbol = ((MethodSymbol)this.ctx.semanticModel().symbol((Node)functionDefinitionNode).get()).typeDescriptor();
        switch (functionDefinitionNode.functionName().toString()) {
            case "onOpen": {
                Utils.validateOnOpenFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onClose": {
                Utils.validateOnCloseFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onError": {
                Utils.validateOnErrorFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onIdleTimeout": {
                Utils.validateOnIdleTimeoutFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onTextMessage": {
                Utils.validateOnTextMessageFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onBinaryMessage": {
                Utils.validateOnBinaryMessageFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            default: {
                Utils.validateOnDataFunctions(functionTypeSymbol, this.ctx, functionDefinitionNode);
            }
        }
    }

    private void reportDiagnostic(ClassDefinitionNode classDefNode, PluginConstants.CompilationErrors hint) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(hint.getErrorCode(), hint.getError(), DiagnosticSeverity.INTERNAL);
        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)classDefNode.location(), (Object[])new Object[0]));
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.FUNCTION_NOT_ACCEPTED_BY_THE_SERVICE, functionDefinitionNode.location(), functionDefinitionNode.functionName().toString());
    }
}

