/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websocket.plugin.Utils;
import io.ballerina.stdlib.websocket.plugin.WebSocketServiceValidator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;

public class WebSocketServiceValidatorTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ClassDefinitionNode classDefNode = (ClassDefinitionNode)syntaxNodeAnalysisContext.node();
        String modulePrefix = Utils.getPrefix(syntaxNodeAnalysisContext);
        classDefNode.members().stream().filter(child -> child.kind() == SyntaxKind.TYPE_REFERENCE).forEach(node -> {
            TypeReferenceNode wsServiceNode = (TypeReferenceNode)node;
            if (wsServiceNode.typeName().toString().equals(modulePrefix + SyntaxKind.COLON_TOKEN.stringValue() + "Service")) {
                WebSocketServiceValidator webSocketServiceValidator = new WebSocketServiceValidator(syntaxNodeAnalysisContext);
                webSocketServiceValidator.validate();
            }
        });
    }
}

