// Copyright (c) 2018 WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// WSO2 Inc. licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except
// in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//Package defines the canonical error codes used by gRPC.

# The gRPC error status code: 0 OK.
const int OK = 0;
# The gRPC error status code: 1 Canceled.
const int CANCELED = 1;
# The gRPC error status code: 2 Unknown.
const int UNKNOWN = 2;
# The gRPC error status code: 3 Invalid Argument.
const int INVALID_ARGUMENT = 3;
# The gRPC error status code: 4 Deadline Exceeded.
const int DEADLINE_EXCEEDED = 4;
# The gRPC error status code: 5 Not Found.
const int NOT_FOUND = 5;
# The gRPC error status code: 6 Already Exists.
const int ALREADY_EXISTS = 6;
# The gRPC error status code: 7 Permission Denied.
const int PERMISSION_DENIED = 7;
# The gRPC error status code: 8 Resource Exhausted.
const int RESOURCE_EXHAUSTED = 8;
# The gRPC error status code: 9 Failed Precondition.
const int FAILED_PRECONDITION = 9;
# The gRPC error status code: 10 Aborted.
const int ABORTED = 10;
# The gRPC error status code: 11 Out of Range.
const int OUT_OF_RANGE = 11;
# The gRPC error status code: 12 Unimplemented.
const int UNIMPLEMENTED = 12;
# The gRPC error status code: 13 Internal.
const int INTERNAL = 13;
# The gRPC error status code: 14 Unavailable.
const int UNAVAILABLE = 14;
# The gRPC error status code: 15 Data Loss.
const int DATA_LOSS = 15;
# The gRPC error status code: 16 Unauthenticated.
const int UNAUTHENTICATED = 16;
