// Copyright (c) 2022 WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// WSO2 Inc. licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except
// in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

# Possible return types of the data provider function.
public type DataProviderReturnType error|map<AnyOrError[]>|AnyOrError[][];

type AnyOrError any|error;

# Represents errors generated by the Testerina module.
public type TestError distinct error;

type ExecutionError distinct error<record {|string functionName;|}>;

type ModuleRerunJson record {|
    string[] testNames;
    map<string?> testModuleNames;
    map<string[]> subTestNames;
|};

enum TestType {
    GENERAL_TEST,
    DATA_DRIVEN_TUPLE_OF_TUPLE,
    DATA_DRIVEN_MAP_OF_TUPLE
}

enum TestCompletionStatus {
    YET_TO_COMPLETE,
    SUSPENDED,
    COMPLETED
}
