// Copyright (c) 2022, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

# Represents a token generated by the Lexer.
#
# + token - TOML token type
# + value - Lexeme of the token. Empty string if not exists.
public type Token record {|
    TOMLToken token;
    string value = "";
|};

public enum TOMLToken {
    DUMMY = "",
    KEY_VALUE_SEPARATOR = "=",
    DOT = ".",
    UNQUOTED_KEY = "<unquoted-key>",
    BASIC_STRING = "<basic-string>",
    LITERAL_STRING = "<literal-string>",
    DECIMAL = "<decimal>",
    BINARY = "<binary>",
    OCTAL = "<octal>",
    HEXADECIMAL = "<hexadecimal>",
    BOOLEAN = "<boolean>",
    EOL = "<end-of-line>",
    MULTILINE_BASIC_STRING_DELIMITER = "\"\"\"",
    MULTILINE_BASIC_STRING_ESCAPE = "\\",
    MULTILINE_BASIC_STRING_LINE = "<multiline-basic-string>",
    MULTILINE_LITERAL_STRING_DELIMITER = "'''",
    MULTILINE_LITERAL_STRING_LINE = "<multiline-literal-string>",
    INFINITY = "inf",
    EXPONENTIAL = "e",
    NAN = "nan",
    OPEN_BRACKET = "[",
    CLOSE_BRACKET = "]",
    SEPARATOR = ",",
    ARRAY_TABLE_OPEN = "[[",
    ARRAY_TABLE_CLOSE = "]]",
    INLINE_TABLE_OPEN = "{",
    INLINE_TABLE_CLOSE = "}",
    MINUS = "-",
    PLUS = "+",
    TIME_DELIMITER = "T",
    ZULU = "Z",
    COLON = ":"
}
