/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ServiceDatabaseManager;
import io.ballerina.modelgenerator.commons.ServiceDeclaration;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.Project;
import io.ballerina.servicemodelgenerator.extension.OpenApiServiceGenerator;
import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.Listener;
import io.ballerina.servicemodelgenerator.extension.model.Service;
import io.ballerina.servicemodelgenerator.extension.model.ServiceClass;
import io.ballerina.servicemodelgenerator.extension.model.TriggerBasicInfo;
import io.ballerina.servicemodelgenerator.extension.model.TriggerProperty;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.request.AddFieldRequest;
import io.ballerina.servicemodelgenerator.extension.request.ClassFieldModifierRequest;
import io.ballerina.servicemodelgenerator.extension.request.ClassModelFromSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.CommonModelFromSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.FunctionModelRequest;
import io.ballerina.servicemodelgenerator.extension.request.FunctionModifierRequest;
import io.ballerina.servicemodelgenerator.extension.request.FunctionSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.ListenerDiscoveryRequest;
import io.ballerina.servicemodelgenerator.extension.request.ListenerModelRequest;
import io.ballerina.servicemodelgenerator.extension.request.ListenerModifierRequest;
import io.ballerina.servicemodelgenerator.extension.request.ListenerSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.ServiceClassSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.ServiceModelRequest;
import io.ballerina.servicemodelgenerator.extension.request.ServiceModifierRequest;
import io.ballerina.servicemodelgenerator.extension.request.ServiceSourceRequest;
import io.ballerina.servicemodelgenerator.extension.request.TriggerListRequest;
import io.ballerina.servicemodelgenerator.extension.request.TriggerRequest;
import io.ballerina.servicemodelgenerator.extension.response.AddOrGetDefaultListenerResponse;
import io.ballerina.servicemodelgenerator.extension.response.CommonSourceResponse;
import io.ballerina.servicemodelgenerator.extension.response.FunctionModelResponse;
import io.ballerina.servicemodelgenerator.extension.response.ListenerDiscoveryResponse;
import io.ballerina.servicemodelgenerator.extension.response.ListenerFromSourceResponse;
import io.ballerina.servicemodelgenerator.extension.response.ListenerModelResponse;
import io.ballerina.servicemodelgenerator.extension.response.ServiceClassModelResponse;
import io.ballerina.servicemodelgenerator.extension.response.ServiceFromSourceResponse;
import io.ballerina.servicemodelgenerator.extension.response.ServiceModelResponse;
import io.ballerina.servicemodelgenerator.extension.response.TriggerListResponse;
import io.ballerina.servicemodelgenerator.extension.response.TriggerResponse;
import io.ballerina.servicemodelgenerator.extension.util.HttpUtil;
import io.ballerina.servicemodelgenerator.extension.util.ListenerUtil;
import io.ballerina.servicemodelgenerator.extension.util.ServiceClassUtil;
import io.ballerina.servicemodelgenerator.extension.util.ServiceModelUtils;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="serviceDesign")
public class ServiceModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private final Map<String, TriggerProperty> triggerProperties;
    private static final Type propertyMapType = new TypeToken<Map<String, TriggerProperty>>(){}.getType();

    public ServiceModelGeneratorService() {
        InputStream newPropertiesStream = this.getClass().getClassLoader().getResourceAsStream("trigger_properties.json");
        Map newTriggerProperties = Map.of();
        if (newPropertiesStream != null) {
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(newPropertiesStream, StandardCharsets.UTF_8));){
                newTriggerProperties = (Map)new Gson().fromJson(reader, propertyMapType);
                reader.close();
                newPropertiesStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.triggerProperties = newTriggerProperties;
    }

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<ListenerDiscoveryResponse> getListeners(ListenerDiscoveryRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package currentPackage = project.currentPackage();
                Module module = currentPackage.module(ModuleName.from((PackageName)currentPackage.packageName()));
                ModuleId moduleId = module.moduleId();
                SemanticModel semanticModel = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(moduleId);
                Set<String> listeners = ListenerUtil.getCompatibleListeners(request.moduleName(), semanticModel, project);
                return new ListenerDiscoveryResponse(listeners);
            }
            catch (Throwable e) {
                return new ListenerDiscoveryResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<ListenerModelResponse> getListenerModel(ListenerModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ListenerUtil.getListenerModelByName(request.moduleName()).map(ListenerModelResponse::new).orElseGet(ListenerModelResponse::new);
            }
            catch (Throwable e) {
                return new ListenerModelResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addListener(ListenerSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                LineRange lineRange = modulePartNode.lineRange();
                Listener listener = request.listener();
                if (!Utils.importExists(modulePartNode, listener.getOrgName(), listener.getModuleName())) {
                    String importText = Utils.getImportStmt(listener.getOrgName(), listener.getModuleName());
                    edits.add(new TextEdit(Utils.toRange(lineRange.startLine()), importText));
                }
                String listenerDeclaration = listener.getDeclaration();
                edits.add(new TextEdit(Utils.toRange(lineRange.endLine()), ServiceModelGeneratorConstants.NEW_LINE + listenerDeclaration));
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<AddOrGetDefaultListenerResponse> addOrGetDefaultListener(ListenerDiscoveryRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                AddOrGetDefaultListenerResponse response = new AddOrGetDefaultListenerResponse();
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package currentPackage = project.currentPackage();
                Module module = currentPackage.module(ModuleName.from((PackageName)currentPackage.packageName()));
                ModuleId moduleId = module.moduleId();
                SemanticModel semanticModel = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(moduleId);
                Optional<String> httpDefaultListenerNameRef = ListenerUtil.getHttpDefaultListenerNameRef(semanticModel, project);
                if (httpDefaultListenerNameRef.isPresent()) {
                    response.setDefaultListenerRef(httpDefaultListenerNameRef.get());
                    return response;
                }
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return response;
                }
                ModulePartNode node = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                LineRange lineRange = node.lineRange();
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                if (!Utils.importExists(node, "ballerina", "http")) {
                    String importText = Utils.getImportStmt("ballerina", "http");
                    edits.add(new TextEdit(Utils.toRange(lineRange.startLine()), importText));
                }
                ListenerUtil.DefaultListener defaultListener = ListenerUtil.defaultListener(semanticModel, (Document)document.get(), node, "http");
                String stmt = ListenerUtil.getDefaultListenerDeclarationStmt(defaultListener);
                edits.add(new TextEdit(Utils.toRange(defaultListener.linePosition()), stmt));
                response.setTextEdits(Map.of(request.filePath(), edits));
                return response;
            }
            catch (Throwable e) {
                return new AddOrGetDefaultListenerResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<ServiceModelResponse> getServiceModel(ServiceModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Optional<Service> service = ServiceModelUtils.getEmptyServiceModel(request.moduleName());
                if (service.isEmpty()) {
                    return new ServiceModelResponse();
                }
                Service serviceModel = service.get();
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package currentPackage = project.currentPackage();
                Module module = currentPackage.module(ModuleName.from((PackageName)currentPackage.packageName()));
                SemanticModel semanticModel = currentPackage.getCompilation().getSemanticModel(module.moduleId());
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new ServiceModelResponse();
                }
                Set<String> listenersList = ListenerUtil.getCompatibleListeners(request.moduleName(), semanticModel, project);
                serviceModel.getListener().setItems(listenersList.stream().toList());
                return new ServiceModelResponse(serviceModel);
            }
            catch (Throwable e) {
                return new ServiceModelResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addService(ServiceSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Utils.FunctionAddContext context;
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return new CommonSourceResponse();
                }
                ModulePartNode node = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                LineRange lineRange = node.lineRange();
                Service service = request.service();
                Utils.populateRequiredFuncsDesignApproachAndServiceType(service);
                ListenerUtil.DefaultListener defaultListener = ListenerUtil.getDefaultListener(service.getListener(), (SemanticModel)semanticModel.get(), (Document)document.get(), node, service.getModuleName());
                if (Objects.nonNull(service.getOpenAPISpec())) {
                    OpenApiServiceGenerator oasSvcGenerator = new OpenApiServiceGenerator(Path.of(service.getOpenAPISpec().getValue(), new String[0]), project.sourceRoot(), this.workspaceManager);
                    return new CommonSourceResponse(oasSvcGenerator.generateService(service, defaultListener));
                }
                HashSet<String> importStmts = new HashSet<String>();
                if (Utils.isAiAgentModule(service.getOrgName(), service.getModuleName()) && !Utils.importExists(node, "ballerina", "http")) {
                    importStmts.add(Utils.getImportStmt("ballerina", "http"));
                }
                if (!Utils.importExists(node, service.getOrgName(), service.getModuleName())) {
                    importStmts.add(Utils.getImportStmt(service.getOrgName(), service.getModuleName()));
                }
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                if (Objects.nonNull(defaultListener)) {
                    String stmt = ListenerUtil.getDefaultListenerDeclarationStmt(defaultListener);
                    edits.add(new TextEdit(Utils.toRange(defaultListener.linePosition()), stmt));
                }
                if ((context = Utils.getTriggerAddContext(service.getOrgName(), service.getPackageName())).equals((Object)Utils.FunctionAddContext.TCP_SERVICE_ADD)) {
                    String serviceName = Utils.generateTypeIdentifier((SemanticModel)semanticModel.get(), (Document)document.get(), lineRange.endLine(), "TcpEchoService");
                    service.getProperties().put("returningServiceClass", Value.getTcpValue(serviceName));
                }
                ServiceModelUtils.populateRequiredFunctionsForServiceType(service);
                HashMap<String, String> imports = new HashMap<String, String>();
                String serviceDeclaration = Utils.getServiceDeclarationNode(service, context, imports);
                edits.add(new TextEdit(Utils.toRange(lineRange.endLine()), ServiceModelGeneratorConstants.NEW_LINE + serviceDeclaration));
                ModulePartNode rootNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                imports.values().forEach(moduleId -> {
                    String moduleName;
                    String[] importParts = moduleId.split("/");
                    String orgName = importParts[0];
                    if (!Utils.importExists(rootNode, orgName, moduleName = importParts[1].split(":")[0])) {
                        importStmts.add(Utils.getImportStmt(orgName, moduleName));
                    }
                });
                if (!importStmts.isEmpty()) {
                    String importsStmts = String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, importStmts);
                    edits.addFirst(new TextEdit(Utils.toRange(rootNode.lineRange().startLine()), importsStmts));
                }
                if (context.equals((Object)Utils.FunctionAddContext.TCP_SERVICE_ADD)) {
                    String serviceName = service.getProperties().get("returningServiceClass").getValue();
                    String serviceClass = ServiceClassUtil.getTcpConnectionServiceTemplate().formatted(serviceName);
                    edits.add(new TextEdit(Utils.toRange(lineRange.endLine()), serviceClass));
                }
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TriggerListResponse> getTriggerModels(TriggerListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            List<TriggerBasicInfo> triggerBasicInfoList = this.triggerProperties.values().stream().filter(triggerProperty -> Utils.filterTriggers(triggerProperty, request)).map(trigger -> this.getTriggerBasicInfoByName(trigger.name())).flatMap(Optional::stream).toList();
            return new TriggerListResponse(triggerBasicInfoList);
        });
    }

    @JsonRequest
    public CompletableFuture<FunctionModelResponse> getFunctionModel(FunctionModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Utils.getFunctionModel(request.type(), request.functionName()).map(FunctionModelResponse::new).orElseGet(FunctionModelResponse::new);
            }
            catch (Throwable e) {
                return new FunctionModelResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addResource(FunctionSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.codedata(), (Document)document.get());
                if (node.kind() != SyntaxKind.SERVICE_DECLARATION) {
                    return new CommonSourceResponse();
                }
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)node;
                ArrayList<String> newStatusCodeTypesDef = new ArrayList<String>();
                HashMap<String, String> imports = new HashMap<String, String>();
                String functionDefinition = ServiceModelGeneratorConstants.NEW_LINE_WITH_TAB + Utils.generateFunctionDefSource(request.function(), newStatusCodeTypesDef, Utils.FunctionAddContext.RESOURCE_ADD, Utils.FunctionSignatureContext.HTTP_RESOURCE_ADD, imports).replace(ServiceModelGeneratorConstants.NEW_LINE, ServiceModelGeneratorConstants.NEW_LINE_WITH_TAB) + ServiceModelGeneratorConstants.NEW_LINE;
                ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
                ArrayList importStmts = new ArrayList();
                ModulePartNode rootNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                imports.values().forEach(moduleId -> {
                    String moduleName;
                    String[] importParts = moduleId.split("/");
                    String orgName = importParts[0];
                    if (!Utils.importExists(rootNode, orgName, moduleName = importParts[1].split(":")[0])) {
                        importStmts.add(Utils.getImportStmt(orgName, moduleName));
                    }
                });
                if (!importStmts.isEmpty()) {
                    String importsStmts = String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, importStmts);
                    textEdits.add(new TextEdit(Utils.toRange(rootNode.lineRange().startLine()), importsStmts));
                }
                LineRange serviceEnd = serviceNode.closeBraceToken().lineRange();
                textEdits.add(new TextEdit(Utils.toRange(serviceEnd.startLine()), functionDefinition));
                if (!newStatusCodeTypesDef.isEmpty()) {
                    String statusCodeResEdits = String.join((CharSequence)ServiceModelGeneratorConstants.TWO_NEW_LINES, newStatusCodeTypesDef);
                    textEdits.add(new TextEdit(Utils.toRange(serviceEnd.endLine()), ServiceModelGeneratorConstants.NEW_LINE + statusCodeResEdits));
                }
                return new CommonSourceResponse(Map.of(request.filePath(), textEdits));
            }
            catch (Exception e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<ServiceFromSourceResponse> getServiceFromSource(CommonModelFromSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Optional document;
            Optional semanticModelOp;
            Project project;
            Path filePath = Path.of(request.filePath(), new String[0]);
            try {
                project = this.workspaceManager.loadProject(filePath);
                semanticModelOp = this.workspaceManager.semanticModel(filePath);
                document = this.workspaceManager.document(filePath);
            }
            catch (Exception e) {
                return new ServiceFromSourceResponse(e);
            }
            if (Objects.isNull(project) || document.isEmpty() || semanticModelOp.isEmpty()) {
                return new ServiceFromSourceResponse();
            }
            NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.codedata(), (Document)document.get());
            if (node.kind() != SyntaxKind.SERVICE_DECLARATION) {
                return new ServiceFromSourceResponse();
            }
            ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)node;
            SemanticModel semanticModel = (SemanticModel)semanticModelOp.get();
            ModuleAndServiceType moduleAndServiceType = ServiceModelGeneratorService.deriveServiceType(serviceNode, semanticModel);
            if (Objects.isNull(moduleAndServiceType.moduleName())) {
                return new ServiceFromSourceResponse();
            }
            String moduleName = moduleAndServiceType.moduleName();
            if (moduleName.equals("http")) {
                ModulePartNode contractModulePartNode;
                Optional<TypeDefinitionNode> serviceContractType;
                Path contractPath;
                Optional contractDoc;
                Optional<Symbol> httpServiceContractSym;
                Optional<Service> service = ServiceModelUtils.getHttpService();
                if (service.isEmpty()) {
                    return new ServiceFromSourceResponse();
                }
                Service serviceModel = service.get();
                serviceModel.setFunctions(new ArrayList<Function>());
                boolean serviceContractExists = false;
                if (serviceNode.typeDescriptor().isPresent() && (httpServiceContractSym = Utils.getHttpServiceContractSym(semanticModel, (TypeDescriptorNode)serviceNode.typeDescriptor().get())).isPresent() && httpServiceContractSym.get().getLocation().isPresent() && (contractDoc = this.workspaceManager.document(contractPath = project.sourceRoot().toAbsolutePath().resolve(((Location)httpServiceContractSym.get().getLocation().get()).lineRange().fileName()))).isPresent() && (serviceContractType = (contractModulePartNode = (ModulePartNode)((Document)contractDoc.get()).syntaxTree().rootNode()).members().stream().filter(member -> member.kind().equals((Object)SyntaxKind.TYPE_DEFINITION)).map(member -> (TypeDefinitionNode)member).filter(member -> member.typeDescriptor().kind().equals((Object)SyntaxKind.OBJECT_TYPE_DESC)).findFirst()).isPresent()) {
                    serviceContractExists = true;
                    HttpUtil.updateHttpServiceContractModel(serviceModel, serviceContractType.get(), serviceNode, semanticModel);
                }
                if (!serviceContractExists) {
                    HttpUtil.updateHttpServiceModel(serviceModel, serviceNode, semanticModel);
                }
                ServiceModelUtils.updateListenerItems(moduleName, semanticModel, project, serviceModel);
                return new ServiceFromSourceResponse(serviceModel);
            }
            String serviceType = ServiceModelGeneratorService.serviceTypeWithoutPrefix(moduleAndServiceType);
            Optional<Service> service = ServiceModelUtils.getServiceModelWithFunctions(moduleName, serviceType);
            if (service.isEmpty()) {
                return new ServiceFromSourceResponse();
            }
            Service serviceModel = service.get();
            ServiceModelUtils.updateGenericServiceModel(serviceModel, serviceNode, semanticModel);
            ServiceModelUtils.updateListenerItems(moduleName, semanticModel, project, serviceModel);
            return new ServiceFromSourceResponse(serviceModel);
        });
    }

    private static String serviceTypeWithoutPrefix(ModuleAndServiceType moduleAndServiceType) {
        String[] serviceTypeNames = moduleAndServiceType.serviceType().split(":");
        String serviceType = "Service";
        if (serviceTypeNames.length > 1) {
            serviceType = serviceTypeNames[1];
        }
        return serviceType;
    }

    @JsonRequest
    public CompletableFuture<ListenerFromSourceResponse> getListenerFromSource(CommonModelFromSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package currentPackage = project.currentPackage();
                Module module = currentPackage.module(ModuleName.from((PackageName)currentPackage.packageName()));
                ModuleId moduleId = module.moduleId();
                SemanticModel semanticModel = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(moduleId);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new ListenerFromSourceResponse();
                }
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.codedata(), (Document)document.get());
                if (!(node instanceof ListenerDeclarationNode)) {
                    return new ListenerFromSourceResponse();
                }
                ListenerDeclarationNode listenerNode = (ListenerDeclarationNode)node;
                Optional<Listener> listenerModelOp = ListenerUtil.getListenerFromSource(listenerNode, semanticModel);
                if (listenerModelOp.isEmpty()) {
                    return new ListenerFromSourceResponse();
                }
                Listener listenerModel = listenerModelOp.get();
                return new ListenerFromSourceResponse(listenerModel);
            }
            catch (Exception e) {
                return new ListenerFromSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TriggerResponse> getTriggerModel(TriggerRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (Utils.expectsTriggerByName(request)) {
                return new TriggerResponse(this.getTriggerBasicInfoByName(request.packageName()).orElse(null));
            }
            TriggerProperty triggerProperty = this.triggerProperties.get(request.id());
            if (triggerProperty == null) {
                return new TriggerResponse();
            }
            return new TriggerResponse(this.getTriggerBasicInfoByName(triggerProperty.name()).orElse(null));
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addFunction(FunctionSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                NodeList members;
                LineRange functionLineRange;
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.codedata(), (Document)document.get());
                if (!(node instanceof ServiceDeclarationNode) && !(node instanceof ClassDefinitionNode)) {
                    return new CommonSourceResponse();
                }
                if (node instanceof ServiceDeclarationNode) {
                    ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
                    functionLineRange = serviceDeclarationNode.openBraceToken().lineRange();
                    members = serviceDeclarationNode.members();
                } else {
                    ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
                    functionLineRange = classDefinitionNode.openBrace().lineRange();
                    members = classDefinitionNode.members();
                }
                if (!members.isEmpty()) {
                    functionLineRange = members.get(members.size() - 1).lineRange();
                }
                HashMap<String, String> imports = new HashMap<String, String>();
                String functionNode = ServiceModelGeneratorConstants.NEW_LINE_WITH_TAB + Utils.generateFunctionDefSource(request.function(), List.of(), Utils.FunctionAddContext.FUNCTION_ADD, Utils.FunctionSignatureContext.FUNCTION_ADD, imports).replace(ServiceModelGeneratorConstants.NEW_LINE, ServiceModelGeneratorConstants.NEW_LINE_WITH_TAB);
                ArrayList importStmts = new ArrayList();
                ModulePartNode rootNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                imports.values().forEach(moduleId -> {
                    String moduleName;
                    String[] importParts = moduleId.split("/");
                    String orgName = importParts[0];
                    if (!Utils.importExists(rootNode, orgName, moduleName = importParts[1].split(":")[0])) {
                        importStmts.add(Utils.getImportStmt(orgName, moduleName));
                    }
                });
                if (!importStmts.isEmpty()) {
                    String importsStmts = String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, importStmts);
                    edits.add(new TextEdit(Utils.toRange(rootNode.lineRange().startLine()), importsStmts));
                }
                edits.add(new TextEdit(Utils.toRange(functionLineRange.endLine()), functionNode));
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateFunction(FunctionModifierRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                Function function = request.function();
                LineRange lineRange = function.getCodedata().getLineRange();
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(function.getCodedata(), (Document)document.get());
                if (!(node instanceof FunctionDefinitionNode)) {
                    return new CommonSourceResponse();
                }
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                NonTerminalNode parentNode = functionDefinitionNode.parent();
                if (!(parentNode instanceof ServiceDeclarationNode) && !(parentNode instanceof ClassDefinitionNode)) {
                    return new CommonSourceResponse();
                }
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Utils.addFunctionAnnotationTextEdits(function, functionDefinitionNode, edits);
                String functionName = functionDefinitionNode.functionName().text().trim();
                LineRange nameRange = functionDefinitionNode.functionName().lineRange();
                String functionKind = function.getKind();
                boolean isRemote = functionKind.equals("REMOTE") || functionKind.equals("MUTATION");
                String newFunctionName = function.getName().getValue();
                if (isRemote && !functionName.equals(newFunctionName)) {
                    edits.add(new TextEdit(Utils.toRange(nameRange), newFunctionName));
                }
                if (!isRemote) {
                    NodeList path;
                    if (!functionName.equals(function.getAccessor().getValue())) {
                        edits.add(new TextEdit(Utils.toRange(nameRange), function.getAccessor().getValue()));
                    }
                    if (Objects.nonNull(path = functionDefinitionNode.relativeResourcePath()) && !newFunctionName.equals(Utils.getPath((NodeList<Node>)path))) {
                        LinePosition startPos = path.get(0).lineRange().startLine();
                        LinePosition endPos = path.get(path.size() - 1).lineRange().endLine();
                        LineRange pathLineRange = LineRange.from((String)lineRange.fileName(), (LinePosition)startPos, (LinePosition)endPos);
                        TextEdit pathEdit = new TextEdit(Utils.toRange(pathLineRange), newFunctionName);
                        edits.add(pathEdit);
                    }
                }
                HashMap<String, String> imports = new HashMap<String, String>();
                LineRange signatureRange = functionDefinitionNode.functionSignature().lineRange();
                ArrayList<String> newStatusCodeTypesDef = new ArrayList<String>();
                String functionSignature = Utils.generateFunctionSignatureSource(function, newStatusCodeTypesDef, Utils.FunctionSignatureContext.FUNCTION_UPDATE, imports);
                ArrayList importStmts = new ArrayList();
                ModulePartNode rootNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                imports.values().forEach(moduleId -> {
                    String moduleName;
                    String[] importParts = moduleId.split("/");
                    String orgName = importParts[0];
                    if (!Utils.importExists(rootNode, orgName, moduleName = importParts[1].split(":")[0])) {
                        importStmts.add(Utils.getImportStmt(orgName, moduleName));
                    }
                });
                if (!importStmts.isEmpty()) {
                    String importsStmts = String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, importStmts);
                    edits.addFirst(new TextEdit(Utils.toRange(rootNode.lineRange().startLine()), importsStmts));
                }
                edits.add(new TextEdit(Utils.toRange(signatureRange), functionSignature));
                if (!newStatusCodeTypesDef.isEmpty() && parentNode instanceof ServiceDeclarationNode) {
                    ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)parentNode;
                    String statusCodeResEdits = String.join((CharSequence)ServiceModelGeneratorConstants.TWO_NEW_LINES, newStatusCodeTypesDef);
                    edits.add(new TextEdit(Utils.toRange(serviceNode.closeBraceToken().lineRange().endLine()), ServiceModelGeneratorConstants.NEW_LINE + statusCodeResEdits));
                }
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateService(ServiceModifierRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Value stringLiteral;
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Service service = request.service();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return new CommonSourceResponse();
                }
                ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                LineRange lineRange = service.getCodedata().getLineRange();
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(service.getCodedata(), (Document)document.get());
                if (node.kind() != SyntaxKind.SERVICE_DECLARATION) {
                    return new CommonSourceResponse();
                }
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)node;
                Utils.addServiceAnnotationTextEdits(service, serviceNode, edits);
                Value basePathValue = service.getBasePath();
                if (Objects.nonNull(basePathValue) && basePathValue.isEnabledWithValue()) {
                    String basePath = basePathValue.getValue();
                    NodeList nodes = serviceNode.absoluteResourcePath();
                    String currentPath = Utils.getPath((NodeList<Node>)nodes);
                    if (!currentPath.equals(basePath) && !nodes.isEmpty()) {
                        LinePosition startPos = nodes.get(0).lineRange().startLine();
                        LinePosition endPos = nodes.get(nodes.size() - 1).lineRange().endLine();
                        LineRange basePathLineRange = LineRange.from((String)lineRange.fileName(), (LinePosition)startPos, (LinePosition)endPos);
                        TextEdit basePathEdit = new TextEdit(Utils.toRange(basePathLineRange), basePath);
                        edits.add(basePathEdit);
                    }
                }
                if (Objects.nonNull(stringLiteral = service.getStringLiteralProperty()) && stringLiteral.isEnabledWithValue()) {
                    String stringLiteralValue = stringLiteral.getValue();
                    NodeList nodes = serviceNode.absoluteResourcePath();
                    String currentPath = Utils.getPath((NodeList<Node>)nodes);
                    if (!currentPath.equals(stringLiteralValue) && !nodes.isEmpty()) {
                        LinePosition startPos = nodes.get(0).lineRange().startLine();
                        LinePosition endPos = nodes.get(nodes.size() - 1).lineRange().endLine();
                        LineRange basePathLineRange = LineRange.from((String)lineRange.fileName(), (LinePosition)startPos, (LinePosition)endPos);
                        TextEdit basePathEdit = new TextEdit(Utils.toRange(basePathLineRange), stringLiteralValue);
                        edits.add(basePathEdit);
                    }
                }
                Value listener = service.getListener();
                ListenerUtil.DefaultListener defaultListener = null;
                if (Objects.nonNull(listener) && listener.isEnabledWithValue()) {
                    defaultListener = ListenerUtil.getDefaultListener(service.getListener(), (SemanticModel)semanticModel.get(), (Document)document.get(), modulePartNode, service.getModuleName());
                    String listenerName = listener.getValue();
                    Optional<ExpressionNode> listenerExpression = Utils.getListenerExpression(serviceNode);
                    if (listenerExpression.isPresent()) {
                        LineRange listenerLineRange = listenerExpression.get().lineRange();
                        TextEdit listenerEdit = new TextEdit(Utils.toRange(listenerLineRange), listenerName);
                        edits.add(listenerEdit);
                    }
                }
                if (Objects.nonNull(defaultListener)) {
                    String stmt = ListenerUtil.getDefaultListenerDeclarationStmt(defaultListener);
                    edits.add(new TextEdit(Utils.toRange(defaultListener.linePosition()), stmt));
                }
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateListener(ListenerModifierRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Listener listener = request.listener();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                LineRange lineRange = listener.getCodedata().getLineRange();
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(listener.getCodedata(), (Document)document.get());
                if (node.kind() != SyntaxKind.LISTENER_DECLARATION) {
                    return new CommonSourceResponse();
                }
                String listenerDeclaration = listener.getDeclaration();
                TextEdit basePathEdit = new TextEdit(Utils.toRange(lineRange), listenerDeclaration);
                edits.add(basePathEdit);
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<ServiceClassModelResponse> getServiceClassModelFromSource(ClassModelFromSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                try {
                    this.workspaceManager.loadProject(filePath);
                }
                catch (Exception e) {
                    return new ServiceClassModelResponse(e);
                }
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new ServiceClassModelResponse();
                }
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.codedata(), (Document)document.get());
                if (!(node instanceof ClassDefinitionNode)) {
                    return new ServiceClassModelResponse();
                }
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
                ServiceClassUtil.ServiceClassContext context = ServiceClassUtil.ServiceClassContext.valueOf(request.context());
                ServiceClass serviceClass = ServiceClassUtil.getServiceClass(classDefinitionNode, context);
                return new ServiceClassModelResponse(serviceClass);
            }
            catch (Throwable e) {
                return new ServiceClassModelResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateServiceClass(ServiceClassSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                int end;
                LineRange lineRange;
                TextDocument textDocument;
                int start;
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                ServiceClass serviceClass = request.serviceClass();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                SyntaxTree syntaxTree = ((Document)document.get()).syntaxTree();
                ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
                NonTerminalNode node = modulePartNode.findNode(TextRange.from((int)(start = (textDocument = syntaxTree.textDocument()).textPositionFrom((lineRange = serviceClass.codedata().getLineRange()).startLine())), (int)((end = textDocument.textPositionFrom(lineRange.endLine())) - start)), true);
                if (node.kind() != SyntaxKind.CLASS_DEFINITION) {
                    return new CommonSourceResponse();
                }
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
                Value className = serviceClass.className();
                if (Objects.nonNull(className) && className.isEnabledWithValue() && !className.getValue().equals(classDefinitionNode.className().text().trim())) {
                    LineRange nameRange = classDefinitionNode.className().lineRange();
                    edits.add(new TextEdit(Utils.toRange(nameRange), className.getValue()));
                }
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addField(AddFieldRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                LineRange functionLineRange;
                int end;
                LineRange lineRange;
                TextDocument textDocument;
                int start;
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                SyntaxTree syntaxTree = ((Document)document.get()).syntaxTree();
                ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
                NonTerminalNode node = modulePartNode.findNode(TextRange.from((int)(start = (textDocument = syntaxTree.textDocument()).textPositionFrom((lineRange = request.codedata().getLineRange()).startLine())), (int)((end = textDocument.textPositionFrom(lineRange.endLine())) - start)), true);
                if (!(node instanceof ClassDefinitionNode) && !(node instanceof ServiceDeclarationNode)) {
                    return new CommonSourceResponse();
                }
                if (node instanceof ServiceDeclarationNode) {
                    ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
                    functionLineRange = serviceDeclarationNode.openBraceToken().lineRange();
                } else {
                    ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
                    functionLineRange = classDefinitionNode.openBrace().lineRange();
                }
                String functionNode = ServiceModelGeneratorConstants.NEW_LINE_WITH_TAB + ServiceClassUtil.buildObjectFiledString(request.field());
                edits.add(new TextEdit(Utils.toRange(functionLineRange.endLine()), functionNode));
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateClassField(ClassFieldModifierRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                LineRange lineRange = request.field().codedata().getLineRange();
                NonTerminalNode node = ServiceModelGeneratorService.findNonTerminalNode(request.field().codedata(), (Document)document.get());
                if (!(node instanceof ObjectFieldNode)) {
                    return new CommonSourceResponse();
                }
                TextEdit fieldEdit = new TextEdit(Utils.toRange(lineRange), ServiceClassUtil.buildObjectFiledString(request.field()));
                edits.add(fieldEdit);
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    public static ModuleAndServiceType deriveServiceType(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Optional serviceTypeDesc = serviceNode.typeDescriptor();
        Optional module = Optional.empty();
        String serviceType = "Service";
        if (serviceTypeDesc.isPresent()) {
            TypeDescriptorNode typeDescriptorNode = (TypeDescriptorNode)serviceTypeDesc.get();
            serviceType = typeDescriptorNode.toString().trim();
            Optional typeSymbol = semanticModel.typeOf((Node)typeDescriptorNode);
            if (typeSymbol.isPresent()) {
                module = ((TypeSymbol)typeSymbol.get()).getModule();
            }
        }
        if (module.isEmpty()) {
            Object t;
            NameReferenceNode nameReferenceNode;
            Optional symbol;
            SeparatedNodeList expressions = serviceNode.expressions();
            if (expressions.isEmpty()) {
                return new ModuleAndServiceType(null, serviceType);
            }
            ExpressionNode expressionNode = (ExpressionNode)expressions.get(0);
            if (expressionNode instanceof ExplicitNewExpressionNode) {
                ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)expressionNode;
                Optional symbol2 = semanticModel.symbol((Node)explicitNewExpressionNode.typeDescriptor());
                if (symbol2.isEmpty()) {
                    return new ModuleAndServiceType(null, serviceType);
                }
                module = ((Symbol)symbol2.get()).getModule();
            } else if (expressionNode instanceof NameReferenceNode && (symbol = semanticModel.symbol((Node)(nameReferenceNode = (NameReferenceNode)expressionNode))).isPresent() && (t = symbol.get()) instanceof VariableSymbol) {
                VariableSymbol variableSymbol = (VariableSymbol)t;
                module = variableSymbol.typeDescriptor().getModule();
            }
        }
        if (module.isEmpty()) {
            return new ModuleAndServiceType(null, serviceType);
        }
        return new ModuleAndServiceType(((ModuleSymbol)module.get()).getName().orElse(null), serviceType);
    }

    private Optional<TriggerBasicInfo> getTriggerBasicInfoByName(String name) {
        Optional serviceDeclaration = ServiceDatabaseManager.getInstance().getServiceDeclaration(name);
        if (serviceDeclaration.isEmpty()) {
            return Optional.empty();
        }
        ServiceDeclaration serviceTemplate = (ServiceDeclaration)serviceDeclaration.get();
        ServiceDeclaration.Package pkg = serviceTemplate.packageInfo();
        String protocol = ServiceModelUtils.getProtocol(name);
        String label = serviceTemplate.displayName();
        String icon = CommonUtils.generateIcon((String)pkg.org(), (String)pkg.name(), (String)pkg.version());
        TriggerBasicInfo triggerBasicInfo = new TriggerBasicInfo(pkg.packageId(), label, pkg.org(), pkg.name(), pkg.name(), pkg.version(), serviceTemplate.kind(), label, "", protocol, icon);
        return Optional.of(triggerBasicInfo);
    }

    private static NonTerminalNode findNonTerminalNode(Codedata codedata, Document document) {
        SyntaxTree syntaxTree = document.syntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        TextDocument textDocument = syntaxTree.textDocument();
        LineRange lineRange = codedata.getLineRange();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return modulePartNode.findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public record ModuleAndServiceType(String moduleName, String serviceType) {
    }
}

