/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.servicemodelgenerator.extension.model.Value;

public class HttpResponse {
    private Value statusCode;
    private Value body;
    private Value name;
    private Value type;
    private Value headers;
    private boolean enabled = true;
    private boolean editable = false;
    private boolean advanced = false;
    private boolean isHttpResponseType = false;

    public HttpResponse() {
    }

    public HttpResponse(Value statusCode, Value body, Value name, Value type, Value headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.name = name;
        this.type = type;
        this.headers = headers;
    }

    public HttpResponse(String type) {
        this.type = new Value(type, "EXPRESSION", true);
    }

    public HttpResponse(String statusCode, String body, String name) {
        this.statusCode = new Value(statusCode, "SINGLE_SELECT", true);
        this.body = new Value(body, "EXPRESSION", true);
        this.name = new Value(name, "EXPRESSION", true);
    }

    public HttpResponse(String statusCode, String type) {
        this.statusCode = new Value(statusCode, "SINGLE_SELECT", true);
        this.body = new Value(type, "TYPE", true);
        this.name = new Value("", "IDENTIFIER", true);
        this.type = new Value(type, "TYPE", true);
        this.headers = new Value("", "MULTIPLE_SELECT", true);
    }

    public HttpResponse(String statusCode, String type, boolean editable) {
        this.statusCode = new Value(statusCode, "SINGLE_SELECT", true);
        this.body = new Value("", "TYPE", true);
        this.name = new Value("", "IDENTIFIER", true);
        this.type = new Value(type, "TYPE", true);
        this.headers = new Value("", "MULTIPLE_SELECT", true);
        this.editable = editable;
    }

    public static HttpResponse getAnonResponse(String code, String typeStr) {
        Value statusCode = new Value(code, "SINGLE_SELECT", true);
        Value body = new Value("", "EXPRESSION", true);
        Value name = new Value("", "EXPRESSION", true);
        Value type = new Value(typeStr, "EXPRESSION", true);
        Value headers = new Value("", "MULTIPLE_SELECT", true);
        return new HttpResponse(statusCode, body, name, type, headers);
    }

    public Value getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Value statusCode) {
        this.statusCode = statusCode;
    }

    public Value getBody() {
        return this.body;
    }

    public void setBody(Value body) {
        this.body = body;
    }

    public Value getName() {
        return this.name;
    }

    public void setName(Value name) {
        this.name = name;
    }

    public Value getType() {
        return this.type;
    }

    public void setType(Value type) {
        this.type = type;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Value getHeaders() {
        return this.headers;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isHttpResponseType() {
        return this.isHttpResponseType;
    }

    public void setHttpResponseType(boolean httpResponseType) {
        this.isHttpResponseType = httpResponseType;
    }
}

