/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.modelgenerator.commons.ServiceDatabaseManager;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Project;
import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.DisplayAnnotation;
import io.ballerina.servicemodelgenerator.extension.model.Listener;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.ListenerDeclAnalyzer;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ListenerUtil {
    public static Set<String> getCompatibleListeners(String moduleName, SemanticModel semanticModel, Project project) {
        LinkedHashSet<String> listeners = new LinkedHashSet<String>();
        boolean isHttpDefaultListenerDefined = false;
        boolean isHttp = "http".equals(moduleName);
        boolean isKafka = "kafka".equals(moduleName);
        for (Symbol moduleSymbol : semanticModel.moduleSymbols()) {
            Optional module;
            VariableSymbol variableSymbol;
            if (!(moduleSymbol instanceof VariableSymbol) || !(variableSymbol = (VariableSymbol)moduleSymbol).qualifiers().contains(Qualifier.LISTENER) || (module = variableSymbol.typeDescriptor().getModule()).isEmpty() || !((ModuleSymbol)module.get()).id().moduleName().equals(moduleName) || variableSymbol.getName().isEmpty() || isKafka && semanticModel.references((Symbol)variableSymbol).size() > 1) continue;
            String listenerName = (String)variableSymbol.getName().get();
            if (isHttp && variableSymbol.getLocation().isPresent()) {
                TextRange range;
                ModulePartNode node;
                NonTerminalNode foundNode;
                Location location = (Location)variableSymbol.getLocation().get();
                Path path = project.sourceRoot().resolve(location.lineRange().fileName());
                DocumentId documentId = project.documentId(path);
                Document document = project.currentPackage().getDefaultModule().document(documentId);
                if (document != null && (foundNode = (node = (ModulePartNode)document.syntaxTree().rootNode()).findNode(range = TextRange.from((int)location.textRange().startOffset(), (int)location.textRange().length()))) != null) {
                    while (foundNode != null && !(foundNode instanceof ListenerDeclarationNode)) {
                        foundNode = foundNode.parent();
                    }
                    if (foundNode != null) {
                        ListenerDeclarationNode listenerDeclarationNode = (ListenerDeclarationNode)foundNode;
                        isHttpDefaultListenerDefined = listenerDeclarationNode.initializer().toSourceCode().trim().contains("http:getDefaultListener()");
                    }
                }
            }
            listeners.add(listenerName);
        }
        if (isHttp && !isHttpDefaultListenerDefined) {
            listeners.add("(+) Create and use the default HTTP listener (port: 9090)");
        }
        if (moduleName.equals("graphql")) {
            listeners.add("(+) Create and use a %s listener with default configurations".formatted(ListenerUtil.moduleName(moduleName)));
        }
        return listeners;
    }

    public static Optional<String> getHttpDefaultListenerNameRef(SemanticModel semanticModel, Project project) {
        for (Symbol moduleSymbol : semanticModel.moduleSymbols()) {
            ListenerDeclarationNode listenerDeclarationNode;
            boolean found;
            TextRange range;
            ModulePartNode node;
            NonTerminalNode foundNode;
            Optional module;
            VariableSymbol variableSymbol;
            if (!(moduleSymbol instanceof VariableSymbol) || !(variableSymbol = (VariableSymbol)moduleSymbol).qualifiers().contains(Qualifier.LISTENER) || (module = variableSymbol.typeDescriptor().getModule()).isEmpty() || !((ModuleSymbol)module.get()).id().moduleName().equals("http") || variableSymbol.getName().isEmpty()) continue;
            String listenerName = ((String)variableSymbol.getName().get()).trim();
            if (!variableSymbol.getLocation().isPresent()) continue;
            Location location = (Location)variableSymbol.getLocation().get();
            Path path = project.sourceRoot().resolve(location.lineRange().fileName());
            DocumentId documentId = project.documentId(path);
            Document document = project.currentPackage().getDefaultModule().document(documentId);
            if (document == null || (foundNode = (node = (ModulePartNode)document.syntaxTree().rootNode()).findNode(range = TextRange.from((int)location.textRange().startOffset(), (int)location.textRange().length()))) == null) continue;
            while (foundNode != null && !(foundNode instanceof ListenerDeclarationNode)) {
                foundNode = foundNode.parent();
            }
            if (foundNode == null || !(found = (listenerDeclarationNode = (ListenerDeclarationNode)foundNode).initializer().toSourceCode().trim().contains("http:getDefaultListener()"))) continue;
            return Optional.of(listenerName);
        }
        return Optional.empty();
    }

    public static DefaultListener getDefaultListener(Value listener, SemanticModel semanticModel, Document document, ModulePartNode node, String moduleName) {
        if (Objects.nonNull(listener) && listener.isEnabledWithValue()) {
            final List<String> values = listener.getValues();
            if (Objects.nonNull(values) && !values.isEmpty()) {
                ArrayList<String> valuesList = new ArrayList<String>(){
                    {
                        this.addAll(values);
                    }
                };
                for (int i = 0; i < values.size(); ++i) {
                    String selection = values.get(i);
                    if (!selection.equals("(+) Create and use the default HTTP listener (port: 9090)") && !selection.equals("(+) Create and use a %s listener with default configurations".formatted(ListenerUtil.moduleName(moduleName)))) continue;
                    DefaultListener defaultListener = ListenerUtil.defaultListener(semanticModel, document, node, moduleName);
                    valuesList.set(i, defaultListener.variableName());
                    listener.setValues((List<String>)valuesList);
                    return defaultListener;
                }
            } else {
                String selection = listener.getValue();
                if (selection.equals("(+) Create and use the default HTTP listener (port: 9090)") || selection.equals("(+) Create and use a %s listener with default configurations".formatted(ListenerUtil.moduleName(moduleName)))) {
                    DefaultListener defaultListener = ListenerUtil.defaultListener(semanticModel, document, node, moduleName);
                    listener.setValue(defaultListener.variableName());
                    return defaultListener;
                }
            }
        }
        return null;
    }

    public static DefaultListener defaultListener(SemanticModel semanticModel, Document document, ModulePartNode node, String moduleName) {
        List importsList = node.imports().stream().toList();
        LinePosition linePosition = importsList.isEmpty() ? node.lineRange().endLine() : ((ImportDeclarationNode)importsList.getLast()).lineRange().endLine();
        String variableName = Utils.generateVariableIdentifier(semanticModel, document, linePosition, "%sDefaultListener".formatted(ListenerUtil.moduleName(moduleName)));
        return new DefaultListener(moduleName, variableName, linePosition);
    }

    public static String getDefaultListenerDeclarationStmt(DefaultListener defaultListener) {
        String stmt = ServiceModelGeneratorConstants.NEW_LINE + "listener %s:Listener %s = %s;" + ServiceModelGeneratorConstants.NEW_LINE;
        String expression = switch (defaultListener.moduleName()) {
            case "http" -> "http:getDefaultListener()";
            case "graphql" -> "new (listenTo = 8080)";
            case "tcp" -> "new (localPort = 8080)";
            case "kafka" -> "new (bootstrapServers = \"\")";
            case "rabbitmq" -> "new (host = \"localhost\", port = 5672)";
            case "mqtt" -> "new(\"tcp://localhost:1883\", \"listener-unique-id\", \"mqtt/topic\")";
            case "asb" -> "new (connectionString = \"\", entityConfig = {queueName: \"test-queue\"}, autoComplete = false)";
            case "salesforce" -> "new (auth = {username: \"\", password: \"\"})";
            case "trigger.github" -> "new ()";
            case "ftp" -> "new ()";
            case "file" -> "new (path = \"\")";
            default -> "";
        };
        return stmt.formatted(ListenerUtil.moduleName(defaultListener.moduleName()), defaultListener.variableName(), expression);
    }

    private static String moduleName(String moduleName) {
        String[] parts = moduleName.split("\\.");
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return moduleName;
    }

    public static Listener getListenerModelWithoutParamProps(FunctionData functionData) {
        LinkedHashMap<String, Value> properties = new LinkedHashMap<String, Value>();
        String formattedModuleName = Utils.upperCaseFirstLetter(functionData.packageName());
        String icon = CommonUtils.generateIcon((String)functionData.org(), (String)functionData.packageName(), (String)functionData.version());
        Listener.ListenerBuilder listenerBuilder = new Listener.ListenerBuilder();
        listenerBuilder.setId(functionData.packageId()).setName(formattedModuleName + " Listener").setType(functionData.packageName()).setDisplayName(formattedModuleName).setDescription(functionData.description()).setListenerProtocol(ListenerUtil.getListenerProtocol(functionData.packageName())).setModuleName(functionData.packageName()).setOrgName(functionData.org()).setPackageName(functionData.packageName()).setVersion(functionData.version()).setIcon(icon).setDisplayAnnotation(new DisplayAnnotation(formattedModuleName, icon)).setProperties(properties);
        properties.put("name", ListenerUtil.nameProperty());
        return listenerBuilder.build();
    }

    private static String getListenerProtocol(String packageName) {
        String pkgName = packageName.toLowerCase(Locale.ROOT);
        String[] split = pkgName.split("\\.");
        return split[split.length - 1];
    }

    public static Optional<Listener> getListenerModelByName(String moduleName) {
        ServiceDatabaseManager dbManager = ServiceDatabaseManager.getInstance();
        Optional optFunctionResult = dbManager.getListener(moduleName);
        if (optFunctionResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionData functionData = (FunctionData)optFunctionResult.get();
        LinkedHashMap parameters = dbManager.getFunctionParametersAsMap(functionData.functionId());
        functionData.setParameters((Map)parameters);
        Listener listener = ListenerUtil.getListenerModelWithoutParamProps(functionData);
        ListenerUtil.setParameterProperties(functionData, listener.getProperties());
        return Optional.of(listener);
    }

    public static Optional<Listener> getDefaultListenerModel(ListenerDeclarationNode listenerNode) {
        ServiceDatabaseManager dbManager = ServiceDatabaseManager.getInstance();
        Optional optFunctionResult = dbManager.getListener("http");
        if (optFunctionResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionData functionData = (FunctionData)optFunctionResult.get();
        LinkedHashMap parameters = dbManager.getFunctionParametersAsMap(functionData.functionId());
        functionData.setParameters((Map)parameters);
        Listener listener = ListenerUtil.getListenerModelWithoutParamProps(functionData);
        listener.getProperties().put("defaultListener", ListenerUtil.getHttpDefaultListenerValue());
        Value nameProperty = listener.getProperty("name");
        nameProperty.setValue(listenerNode.variableName().text().trim());
        nameProperty.setCodedata(new Codedata(listenerNode.variableName().lineRange()));
        nameProperty.setEditable(false);
        listener.setCodedata(new Codedata(listenerNode.lineRange()));
        return Optional.of(listener);
    }

    private static Value getHttpDefaultListenerValue() {
        Value value = new Value();
        value.setMetadata(new MetaData("HTTP Default Listener", "The default HTTP listener"));
        value.setEnabled(true);
        value.setEditable(false);
        value.setAdvanced(false);
        value.setOptional(false);
        value.setValueType("EXPRESSION");
        value.setValue("http:getDefaultListener()");
        return value;
    }

    private static void setParameterProperties(FunctionData function, Map<String, Value> properties) {
        for (ParameterData paramResult : function.parameters().values()) {
            if (paramResult.kind().equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramResult.kind().equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
            String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
            Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
            codedata.setOriginalName(paramResult.name());
            Value.ValueBuilder valueBuilder = new Value.ValueBuilder().setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value("").valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
            properties.put(unescapedParamName, valueBuilder.build());
        }
    }

    public static Optional<Listener> getListenerFromSource(ListenerDeclarationNode listenerDeclarationNode, SemanticModel semanticModel) {
        TypeSymbol typeSymbol;
        Object t;
        if (ListenerUtil.isHttpDefaultListener(listenerDeclarationNode)) {
            return ListenerUtil.getDefaultListenerModel(listenerDeclarationNode);
        }
        Optional symbol = semanticModel.symbol((Node)listenerDeclarationNode.typeDescriptor().get());
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof TypeSymbol) || (typeSymbol = (TypeSymbol)t).getModule().isEmpty()) {
            return Optional.empty();
        }
        String moduleName = ((ModuleSymbol)typeSymbol.getModule().get()).id().moduleName();
        ServiceDatabaseManager dbManager = ServiceDatabaseManager.getInstance();
        Optional optFunctionResult = dbManager.getListener(moduleName);
        if (optFunctionResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionData functionData = (FunctionData)optFunctionResult.get();
        LinkedHashMap parameters = dbManager.getFunctionParametersAsMap(functionData.functionId());
        functionData.setParameters((Map)parameters);
        Listener listener = ListenerUtil.getListenerModelWithoutParamProps(functionData);
        Value nameProperty = listener.getProperty("name");
        nameProperty.setValue(listenerDeclarationNode.variableName().text().trim());
        nameProperty.setCodedata(new Codedata(listenerDeclarationNode.variableName().lineRange()));
        nameProperty.setEditable(false);
        listener.setCodedata(new Codedata(listenerDeclarationNode.lineRange()));
        Node initializer = listenerDeclarationNode.initializer();
        if (initializer instanceof NewExpressionNode) {
            NewExpressionNode newExpressionNode = (NewExpressionNode)initializer;
            TypeSymbol rawType = CommonUtils.getRawType((TypeSymbol)typeSymbol);
            if (rawType instanceof ClassSymbol) {
                ClassSymbol classSymbol = (ClassSymbol)rawType;
                SeparatedNodeList<FunctionArgumentNode> arguments = ListenerUtil.getArgList(newExpressionNode);
                if (classSymbol.initMethod().isEmpty()) {
                    return Optional.of(listener);
                }
                ListenerDeclAnalyzer analyzer = new ListenerDeclAnalyzer(listener.getProperties());
                analyzer.analyze(arguments, (FunctionSymbol)classSymbol.initMethod().get(), functionData);
            }
        }
        return Optional.of(listener);
    }

    private static SeparatedNodeList<FunctionArgumentNode> getArgList(NewExpressionNode newExpressionNode) {
        if (newExpressionNode instanceof ExplicitNewExpressionNode) {
            ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)newExpressionNode;
            return explicitNewExpressionNode.parenthesizedArgList().arguments();
        }
        Optional parenthesizedArgList = ((ImplicitNewExpressionNode)newExpressionNode).parenthesizedArgList();
        return parenthesizedArgList.isPresent() ? ((ParenthesizedArgList)parenthesizedArgList.get()).arguments() : NodeFactory.createSeparatedNodeList((Node[])new Node[0]);
    }

    public static boolean isHttpDefaultListener(ListenerDeclarationNode listenerNode) {
        return listenerNode.initializer().toSourceCode().trim().contains("http:getDefaultListener()");
    }

    public static Value nameProperty() {
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData("Name", "The name of the listener")).setCodedata(new Codedata("LISTENER_VAR_NAME")).value("").valueType("IDENTIFIER").setValueTypeConstraint("Global").isType(false).editable(true).enabled(true).optional(false).setAdvanced(false);
        return valueBuilder.build();
    }

    public record DefaultListener(String moduleName, String variableName, LinePosition linePosition) {
    }
}

