/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.Field;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.FunctionReturnType;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Parameter;
import io.ballerina.servicemodelgenerator.extension.model.ServiceClass;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ServiceClassUtil {
    public static String buildObjectFiledString(Field field) {
        StringBuilder builder = new StringBuilder();
        if (field.isPrivate()) {
            builder.append("private ");
        }
        if (field.isFinal()) {
            builder.append("final ");
        }
        builder.append(field.getType().getValue()).append(" ").append(field.getName().getValue());
        if (Objects.nonNull(field.getDefaultValue().getValue()) && !field.getDefaultValue().getValue().isEmpty()) {
            builder.append(" = ").append(field.getDefaultValue().getValue());
        }
        builder.append(";");
        return builder.toString();
    }

    public static ServiceClass getServiceClass(ClassDefinitionNode classDef, ServiceClassContext context) {
        ServiceClass.ServiceClassBuilder builder = new ServiceClass.ServiceClassBuilder();
        ArrayList<Function> functions = new ArrayList<Function>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ServiceClassUtil.populateFunctionsAndFields(classDef, functions, fields, context);
        builder.name(classDef.className().text().trim()).type(ServiceClassUtil.getClassType(classDef)).properties(Map.of("name", ServiceClassUtil.buildClassNameProperty(classDef.className().text().trim(), classDef.className().lineRange(), context))).codedata(new Codedata(classDef.lineRange())).functions(functions).fields(fields);
        return builder.build();
    }

    private static String getClassType(ClassDefinitionNode classDef) {
        if (classDef.classTypeQualifiers().isEmpty()) {
            return "default";
        }
        return ((Token)classDef.classTypeQualifiers().get(0)).text().trim();
    }

    private static Value buildClassNameProperty(String className, LineRange lineRange, ServiceClassContext context) {
        Value value = new Value();
        value.setMetadata(context == ServiceClassContext.TYPE_DIAGRAM ? ServiceModelGeneratorConstants.SERCVICE_CLASS_NAME_METADATA : ServiceModelGeneratorConstants.GRAPHQL_CLASS_NAME_METADATA);
        value.setCodedata(new Codedata(lineRange));
        value.setEnabled(true);
        value.setEditable(false);
        value.setValue(className);
        value.setValueType("IDENTIFIER");
        value.setValueTypeConstraint("Global");
        value.setPlaceholder("");
        return value;
    }

    private static void populateFunctionsAndFields(ClassDefinitionNode classDef, List<Function> functions, List<Field> fields, ServiceClassContext context) {
        classDef.members().forEach(member -> {
            if (member instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
                FunctionKind functionKind = ServiceClassUtil.getFunctionKind(functionDefinitionNode);
                if (context.equals((Object)ServiceClassContext.GRAPHQL_DIAGRAM) && !functionKind.equals((Object)FunctionKind.RESOURCE)) {
                    return;
                }
                functions.add(ServiceClassUtil.buildMemberFunction(functionDefinitionNode, functionKind, context));
            } else if (context == ServiceClassContext.TYPE_DIAGRAM && member instanceof ObjectFieldNode) {
                ObjectFieldNode objectFieldNode = (ObjectFieldNode)member;
                fields.add(ServiceClassUtil.buildClassField(objectFieldNode));
            }
        });
    }

    private static Function buildMemberFunction(FunctionDefinitionNode functionDef, FunctionKind kind, ServiceClassContext context) {
        FunctionReturnType returnType;
        Function functionModel = Function.getNewFunctionModel(context);
        ServiceClassUtil.updateMetadata(functionModel, kind);
        functionModel.setKind(kind.name());
        if (kind == FunctionKind.INIT) {
            functionModel.getName().setMetadata(ServiceModelGeneratorConstants.FUNCTION_NAME_METADATA);
            functionModel.getReturnType().setMetadata(ServiceModelGeneratorConstants.FUNCTION_RETURN_TYPE_METADATA);
        }
        if (kind.equals((Object)FunctionKind.RESOURCE)) {
            functionModel.getAccessor().setValue(functionDef.functionName().text().trim());
            ServiceClassUtil.setFunctionNameAndLineRange(functionModel.getName(), Utils.getPath((NodeList<Node>)functionDef.relativeResourcePath()), functionDef.functionName().lineRange());
        } else {
            ServiceClassUtil.setFunctionNameAndLineRange(functionModel.getName(), functionDef.functionName().text().trim(), functionDef.functionName().lineRange());
        }
        FunctionSignatureNode functionSignatureNode = functionDef.functionSignature();
        Optional returnTypeDesc = functionSignatureNode.returnTypeDesc();
        if (returnTypeDesc.isPresent() && Objects.nonNull(returnType = functionModel.getReturnType())) {
            returnType.setValue(((ReturnTypeDescriptorNode)returnTypeDesc.get()).type().toString().trim());
            returnType.setValueType("TYPE");
            returnType.setEnabled(true);
            returnType.setEditable(true);
            returnType.setOptional(true);
        }
        SeparatedNodeList parameters = functionSignatureNode.parameters();
        ArrayList<Parameter> parameterModels = new ArrayList<Parameter>();
        parameters.forEach(parameterNode -> {
            Optional<Parameter> parameterModel = Utils.getParameterModel(parameterNode, false, context == ServiceClassContext.GRAPHQL_DIAGRAM);
            parameterModel.ifPresent(parameterModels::add);
        });
        functionModel.setParameters(parameterModels);
        functionModel.setEditable(true);
        functionModel.setCodedata(new Codedata(functionDef.lineRange()));
        return functionModel;
    }

    private static Field buildClassField(ObjectFieldNode objectField) {
        Parameter parameterModel = Parameter.getNewField();
        Value type = parameterModel.getType();
        type.setValue(objectField.typeName().toSourceCode().trim());
        type.setValueType("TYPE");
        type.setType(true);
        type.setEnabled(true);
        Value name = parameterModel.getName();
        name.setValue(objectField.fieldName().text().trim());
        name.setValueType("IDENTIFIER");
        name.setEnabled(true);
        name.setEditable(false);
        name.setCodedata(new Codedata(objectField.fieldName().lineRange()));
        parameterModel.setEnabled(true);
        if (objectField.expression().isPresent()) {
            Value defaultValue = parameterModel.getDefaultValue();
            defaultValue.setValue(((ExpressionNode)objectField.expression().get()).toString().trim());
            defaultValue.setValueType("EXPRESSION");
            defaultValue.setEnabled(true);
        }
        boolean isPrivate = objectField.visibilityQualifier().isPresent() && ((Token)objectField.visibilityQualifier().get()).text().trim().equals("private");
        boolean isFinal = objectField.qualifierList().stream().anyMatch(qualifier -> qualifier.text().trim().equals("final"));
        return new Field(parameterModel, isPrivate, isFinal, new Codedata(objectField.lineRange()));
    }

    private static FunctionKind getFunctionKind(FunctionDefinitionNode functionDefinitionNode) {
        for (Token qualifier : functionDefinitionNode.qualifierList()) {
            if (qualifier.text().trim().matches("remote")) {
                return FunctionKind.REMOTE;
            }
            if (!qualifier.text().trim().matches("resource")) continue;
            return FunctionKind.RESOURCE;
        }
        if (functionDefinitionNode.functionName().text().trim().equals("init")) {
            return FunctionKind.INIT;
        }
        return FunctionKind.DEFAULT;
    }

    private static void setFunctionNameAndLineRange(Value value, String functionName, LineRange lineRange) {
        value.setValue(functionName);
        value.setCodedata(new Codedata(lineRange));
    }

    private static void updateMetadata(Function function, FunctionKind kind) {
        switch (kind.ordinal()) {
            case 0: {
                function.setMetadata(new MetaData("Init Method", "Init Method"));
                break;
            }
            case 1: {
                function.setMetadata(new MetaData("Remote Method", "Remote Method"));
                break;
            }
            case 2: {
                function.setMetadata(new MetaData("Resource Method", "Resource Method"));
                break;
            }
            case 3: {
                function.setMetadata(new MetaData("Object Method", "Object Method"));
            }
        }
    }

    public static String getTcpConnectionServiceTemplate() {
        return "%nservice class %s {%n    *tcp:ConnectionService;%n%n    remote function onBytes(tcp:Caller caller, readonly & byte[] data) returns tcp:Error? {%n        do {%n%n        } on fail error err {%n            // handle error%n            return error(\"unhandled error\", err);%n        }%n    }%n%n    remote function onError(tcp:Error tcpError) returns tcp:Error? {%n        do {%n%n        } on fail error err {%n            // handle error%n            return error(\"unhandled error\", err);%n        }%n    }%n%n    remote function onClose() returns tcp:Error? {%n        do {%n%n        } on fail error err {%n            // handle error%n            return error(\"unhandled error\", err);%n        }%n    }%n}%n%n";
    }

    public static enum ServiceClassContext {
        TYPE_DIAGRAM,
        GRAPHQL_DIAGRAM,
        SERVICE_DIAGRAM,
        HTTP_DIAGRAM;

    }

    public static enum FunctionKind {
        INIT,
        REMOTE,
        RESOURCE,
        DEFAULT;

    }
}

