/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.decimal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;

public class FromString {
    private static final BString ERROR_REASON = ErrorReasons.getModulePrefixedReason((String)"lang.decimal", (String)"NumberParsingError");

    private FromString() {
    }

    public static Object fromString(BString s) {
        String decimalFloatingPointNumber = s.getValue();
        try {
            return TypeConverter.stringToDecimal((String)decimalFloatingPointNumber);
        }
        catch (NumberFormatException e) {
            return FromString.getTypeConversionError(decimalFloatingPointNumber);
        }
    }

    private static BError getTypeConversionError(String value) {
        return ErrorCreator.createError((BString)ERROR_REASON, (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, (Object[])new Object[]{PredefinedTypes.TYPE_STRING, value, PredefinedTypes.TYPE_DECIMAL}));
    }
}

