/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.AtomicType;
import io.ballerina.runtime.api.types.semtype.PredefinedTypeEnv;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeAtom;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.FunctionAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public final class Env {
    private static final Env INSTANCE = new Env();
    private final AtomTable atomTable;
    private final ReadWriteLock recListLock = new ReentrantReadWriteLock();
    final List<ListAtomicType> recListAtoms;
    private final ReadWriteLock recMapLock = new ReentrantReadWriteLock();
    final List<MappingAtomicType> recMappingAtoms;
    private final ReadWriteLock recFunctionLock = new ReentrantReadWriteLock();
    private final List<FunctionAtomicType> recFunctionAtoms;
    private final ReadWriteLock cellTypeCacheLock = new ReentrantReadWriteLock();
    private final Map<CellSemTypeCacheKey, SemType> cellTypeCache = new HashMap<CellSemTypeCacheKey, SemType>();
    private final AtomicInteger distinctAtomCount = new AtomicInteger(0);

    private Env() {
        this.atomTable = new AtomTable();
        this.recListAtoms = new ArrayList<ListAtomicType>();
        this.recMappingAtoms = new ArrayList<MappingAtomicType>();
        this.recFunctionAtoms = new ArrayList<FunctionAtomicType>();
        PredefinedTypeEnv.getInstance().initializeEnv(this);
    }

    public static Env getInstance() {
        return INSTANCE;
    }

    public TypeAtom cellAtom(CellAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    private TypeAtom typeAtom(AtomicType atomicType) {
        return this.atomTable.getOrCreate(atomicType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemType getCachedCellType(SemType ty, CellAtomicType.CellMutability mut, Supplier<SemType> semTypeCreator) {
        SemType cached;
        if (ty.some() != 0) {
            return semTypeCreator.get();
        }
        CellSemTypeCacheKey key = new CellSemTypeCacheKey(ty.all(), mut);
        this.cellTypeCacheLock.readLock().lock();
        try {
            cached = this.cellTypeCache.get(key);
            if (cached != null) {
                SemType semType = cached;
                return semType;
            }
        }
        finally {
            this.cellTypeCacheLock.readLock().unlock();
        }
        this.cellTypeCacheLock.writeLock().lock();
        try {
            cached = this.cellTypeCache.get(key);
            if (cached != null) {
                SemType semType = cached;
                return semType;
            }
            SemType result = semTypeCreator.get();
            this.cellTypeCache.put(key, result);
            SemType semType = result;
            return semType;
        }
        finally {
            this.cellTypeCacheLock.writeLock().unlock();
        }
    }

    public RecAtom recListAtom() {
        return Env.allocateRecAtom(this.recListLock, this.recListAtoms);
    }

    public void setRecListAtomType(RecAtom rec, ListAtomicType atomicType) {
        Env.setRecAtomType(this.recListLock, this.recListAtoms, rec, atomicType);
    }

    public Atom listAtom(ListAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    private ListAtomicType getRecListAtomType(RecAtom ra) {
        return Env.getRecAtomType(this.recListLock, this.recListAtoms, ra);
    }

    public ListAtomicType listAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecListAtomType(recAtom);
        }
        return (ListAtomicType)((TypeAtom)atom).atomicType();
    }

    public RecAtom recMappingAtom() {
        return Env.allocateRecAtom(this.recMapLock, this.recMappingAtoms);
    }

    public void setRecMappingAtomType(RecAtom rec, MappingAtomicType atomicType) {
        Env.setRecAtomType(this.recMapLock, this.recMappingAtoms, rec, atomicType);
    }

    public TypeAtom mappingAtom(MappingAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    private MappingAtomicType getRecMappingAtomType(RecAtom recAtom) {
        return Env.getRecAtomType(this.recMapLock, this.recMappingAtoms, recAtom);
    }

    public MappingAtomicType mappingAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecMappingAtomType(recAtom);
        }
        return (MappingAtomicType)((TypeAtom)atom).atomicType();
    }

    public RecAtom recFunctionAtom() {
        return Env.allocateRecAtom(this.recFunctionLock, this.recFunctionAtoms);
    }

    public void setRecFunctionAtomType(RecAtom rec, FunctionAtomicType atomicType) {
        Env.setRecAtomType(this.recFunctionLock, this.recFunctionAtoms, rec, atomicType);
    }

    private FunctionAtomicType getRecFunctionAtomType(RecAtom recAtom) {
        return Env.getRecAtomType(this.recFunctionLock, this.recFunctionAtoms, recAtom);
    }

    public FunctionAtomicType functionAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecFunctionAtomType(recAtom);
        }
        return (FunctionAtomicType)((TypeAtom)atom).atomicType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends AtomicType> void setRecAtomType(ReadWriteLock lock, List<E> recAtomList, RecAtom rec, E atomicType) {
        lock.readLock().lock();
        try {
            recAtomList.set(rec.index(), atomicType);
            rec.ready();
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends AtomicType> E getRecAtomType(ReadWriteLock lock, List<E> recAtomList, RecAtom rec) {
        rec.waitUntilReady();
        lock.readLock().lock();
        try {
            assert (recAtomList.get(rec.index()) != null);
            AtomicType atomicType = (AtomicType)recAtomList.get(rec.index());
            return (E)atomicType;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends AtomicType> RecAtom allocateRecAtom(ReadWriteLock lock, List<E> recAtomList) {
        lock.writeLock().lock();
        try {
            int result = recAtomList.size();
            recAtomList.add(null);
            RecAtom recAtom = RecAtom.createRecAtom(result);
            return recAtom;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public Atom functionAtom(FunctionAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    public int distinctAtomCountGetAndIncrement() {
        return this.distinctAtomCount.getAndIncrement();
    }

    private static final class AtomTable {
        private final ReadWriteLock cellLock = new ReentrantReadWriteLock();
        private final ReadWriteLock functionLock = new ReentrantReadWriteLock();
        private final ReadWriteLock listLock = new ReentrantReadWriteLock();
        private final ReadWriteLock mappingLock = new ReentrantReadWriteLock();
        private final Map<AtomicType, Reference<TypeAtom>> cellTable = new WeakHashMap<AtomicType, Reference<TypeAtom>>();
        private final Map<AtomicType, Reference<TypeAtom>> listTable = new WeakHashMap<AtomicType, Reference<TypeAtom>>();
        private final Map<AtomicType, Reference<TypeAtom>> functionTable = new WeakHashMap<AtomicType, Reference<TypeAtom>>();
        private final Map<AtomicType, Reference<TypeAtom>> mappingTable = new WeakHashMap<AtomicType, Reference<TypeAtom>>();
        private final AtomicInteger nextCellIndex = new AtomicInteger(0);
        private final AtomicInteger nextListIndex = new AtomicInteger(0);
        private final AtomicInteger nextFunctionIndex = new AtomicInteger(0);
        private final AtomicInteger nextMappingIndex = new AtomicInteger(0);

        private AtomTable() {
        }

        public TypeAtom getOrCreate(AtomicType atomicType) {
            AtomicType atomicType2 = atomicType;
            Objects.requireNonNull(atomicType2);
            AtomicType atomicType3 = atomicType2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CellAtomicType.class, FunctionAtomicType.class, ListAtomicType.class, MappingAtomicType.class}, (Object)atomicType3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    CellAtomicType cellAtomicType = (CellAtomicType)atomicType3;
                    return AtomTable.getOrCreateInner(this.cellLock, this.cellTable, this.nextCellIndex, cellAtomicType);
                }
                case 1: {
                    FunctionAtomicType functionAtomicType = (FunctionAtomicType)atomicType3;
                    return AtomTable.getOrCreateInner(this.functionLock, this.functionTable, this.nextFunctionIndex, functionAtomicType);
                }
                case 2: {
                    ListAtomicType listAtomicType = (ListAtomicType)atomicType3;
                    return AtomTable.getOrCreateInner(this.listLock, this.listTable, this.nextListIndex, listAtomicType);
                }
                case 3: 
            }
            MappingAtomicType mappingAtomicType = (MappingAtomicType)atomicType3;
            return AtomTable.getOrCreateInner(this.mappingLock, this.mappingTable, this.nextMappingIndex, mappingAtomicType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static TypeAtom getOrCreateInner(ReadWriteLock rwLock, Map<AtomicType, Reference<TypeAtom>> table, AtomicInteger nextIndex, AtomicType atomicType) {
            rwLock.readLock().lock();
            try {
                TypeAtom atom;
                Reference<TypeAtom> ref = table.get(atomicType);
                if (ref != null && (atom = ref.get()) != null) {
                    TypeAtom typeAtom = atom;
                    return typeAtom;
                }
            }
            finally {
                rwLock.readLock().unlock();
            }
            int index = nextIndex.getAndIncrement();
            TypeAtom result = TypeAtom.createTypeAtom(index, atomicType);
            AtomicType key = result.atomicType();
            WeakReference<TypeAtom> value = new WeakReference<TypeAtom>(result);
            rwLock.writeLock().lock();
            try {
                table.put(key, value);
                TypeAtom typeAtom = result;
                return typeAtom;
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    private record CellSemTypeCacheKey(int all, CellAtomicType.CellMutability mut) {
    }
}

