/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.semtype.ImmutableSemType;
import io.ballerina.runtime.internal.types.semtype.MutableSemType;
import io.ballerina.runtime.internal.types.semtype.SemTypeHelper;

public sealed class SemType
extends BasicTypeBitSet
permits BType, ImmutableSemType {
    private int some;
    private SubType[] subTypeData;
    private static final SemType NEVER = new SemType(0, 0, null);

    protected SemType(int all, int some, SubType[] subTypeData) {
        super(all);
        this.some = some;
        this.subTypeData = subTypeData;
    }

    protected SemType() {
        this(-1, -1, null);
    }

    public static SemType from(int all) {
        if (all == 0) {
            return NEVER;
        }
        return new SemType(all, 0, null);
    }

    public static SemType from(int all, int some, SubType[] subTypes) {
        return new SemType(all, some, subTypes);
    }

    public final int some() {
        return this.some;
    }

    public final SubType[] subTypeData() {
        return this.subTypeData;
    }

    public final SubType subTypeByCode(int code) {
        if ((this.some() & 1 << code) == 0) {
            return null;
        }
        int someMask = (1 << code) - 1;
        int some = this.some() & someMask;
        return this.subTypeData()[Integer.bitCount(some)];
    }

    protected void setSome(int some, SubType[] subTypeData) {
        this.some = some;
        this.subTypeData = subTypeData;
    }

    public static SemType tryInto(Context cx, Type type) {
        if (type instanceof MutableSemType) {
            MutableSemType mutableSemType = (MutableSemType)((Object)type);
            mutableSemType.updateInnerSemTypeIfNeeded(cx);
        }
        return (SemType)((Object)type);
    }

    public String toString() {
        return SemTypeHelper.stringRepr(this);
    }
}

