/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.configurable.ConfigProvider;
import io.ballerina.runtime.internal.configurable.ConfigValue;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class ConfigResolver {
    private final Map<Module, VariableKey[]> configVarMap;
    private final List<ConfigProvider> supportedConfigProviders;
    private final List<ConfigProvider> runtimeConfigProviders;
    private final RuntimeDiagnosticLog diagnosticLog;

    public ConfigResolver(Map<Module, VariableKey[]> configVarMap, RuntimeDiagnosticLog diagnosticLog, List<ConfigProvider> supportedConfigProviders) {
        this.configVarMap = configVarMap;
        this.supportedConfigProviders = supportedConfigProviders;
        this.runtimeConfigProviders = new LinkedList<ConfigProvider>();
        this.diagnosticLog = diagnosticLog;
    }

    public Map<VariableKey, ConfigValue> resolveConfigs() {
        HashMap<VariableKey, ConfigValue> configValueMap = new HashMap<VariableKey, ConfigValue>();
        if (this.configVarMap.isEmpty()) {
            return configValueMap;
        }
        for (ConfigProvider configProvider : this.supportedConfigProviders) {
            try {
                configProvider.initialize();
                if (!configProvider.hasConfigs()) continue;
                this.runtimeConfigProviders.add(configProvider);
            }
            catch (ConfigException e) {
                this.diagnosticLog.warn(e.getErrorCode(), null, e.getArgs());
            }
        }
        for (Map.Entry entry : this.configVarMap.entrySet()) {
            VariableKey[] variableKeys;
            Module module = (Module)entry.getKey();
            for (VariableKey varKey : variableKeys = (VariableKey[])entry.getValue()) {
                Optional<?> configValue = this.getConfigValue(module, varKey);
                configValue.ifPresent(o -> configValueMap.put(varKey, (ConfigValue)o));
            }
        }
        for (ConfigProvider configProvider : this.runtimeConfigProviders) {
            configProvider.complete(this.diagnosticLog);
        }
        return configValueMap;
    }

    private Optional<?> getConfigValue(Module module, VariableKey key) {
        Function<ConfigProvider, Optional<?>> function = this.getValueFunction(module, key, key.type);
        if (function != null) {
            return this.getConfigValue(key, function);
        }
        return Optional.empty();
    }

    private Function<ConfigProvider, Optional<?>> getValueFunction(Module module, VariableKey key, Type type) {
        switch (type.getTag()) {
            case 14: {
                return null;
            }
            case 1: {
                return configProvider -> configProvider.getAsIntAndMark(module, key);
            }
            case 2: {
                return configProvider -> configProvider.getAsByteAndMark(module, key);
            }
            case 6: {
                return configProvider -> configProvider.getAsBooleanAndMark(module, key);
            }
            case 3: {
                return configProvider -> configProvider.getAsFloatAndMark(module, key);
            }
            case 4: {
                return configProvider -> configProvider.getAsDecimalAndMark(module, key);
            }
            case 5: {
                return configProvider -> configProvider.getAsStringAndMark(module, key);
            }
            case 24: {
                return configProvider -> configProvider.getAsRecordAndMark(module, key);
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return configProvider -> configProvider.getAsXmlAndMark(module, key);
            }
            case 46: {
                return configProvider -> configProvider.getAsFiniteAndMark(module, key);
            }
            case 32: {
                return configProvider -> configProvider.getAsArrayAndMark(module, key);
            }
            case 27: {
                return configProvider -> configProvider.getAsMapAndMark(module, key);
            }
            case 17: {
                return configProvider -> configProvider.getAsTableAndMark(module, key);
            }
            case 15: 
            case 23: 
            case 33: {
                return configProvider -> configProvider.getAsUnionAndMark(module, key);
            }
            case 44: {
                return configProvider -> configProvider.getAsTupleAndMark(module, key);
            }
            case 53: {
                return this.getValueFunction(module, key, ((ReferenceType)type).getReferredType());
            }
            case 34: {
                Type effectiveType = ((IntersectionType)type).getEffectiveType();
                return this.getValueFunction(module, key, effectiveType);
            }
        }
        this.diagnosticLog.error(ErrorCodes.CONFIG_TYPE_NOT_SUPPORTED, key.location, key.variable, Utils.decodeIdentifier(type.toString()));
        return null;
    }

    private Optional<?> getConfigValue(VariableKey key, Function<ConfigProvider, Optional<?>> getConfigFunc) {
        Optional<Object> configValue = Optional.empty();
        ArrayList<ConfigException> exceptionList = new ArrayList<ConfigException>(this.runtimeConfigProviders.size());
        for (ConfigProvider configProvider : this.runtimeConfigProviders) {
            try {
                Optional<?> value = getConfigFunc.apply(configProvider);
                if (!value.isPresent()) continue;
                configValue = value;
            }
            catch (ConfigException e2) {
                exceptionList.add(e2);
            }
        }
        if (configValue.isPresent()) {
            exceptionList.forEach(e -> this.diagnosticLog.warn(e.getErrorCode(), key.location, e.getArgs()));
            return configValue;
        }
        if (exceptionList.isEmpty() && key.isRequired) {
            this.diagnosticLog.error(ErrorCodes.CONFIG_VALUE_NOT_PROVIDED, key.location, key.variable);
            return configValue;
        }
        exceptionList.forEach(e -> this.diagnosticLog.error(e.getErrorCode(), key.location, e.getArgs()));
        return configValue;
    }
}

