/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.Type;
import java.util.Objects;

public class VariableKey {
    public final Module module;
    public final String variable;
    public final Type type;
    public final boolean isRequired;
    public final String location;

    public VariableKey(String org, String module, String version, String variable, Type type) {
        this(new Module(org, module, version), variable, type, null, false);
    }

    public VariableKey(Module module, String variable, Type type, boolean isRequired) {
        this(module, variable, type, null, isRequired);
    }

    public VariableKey(Module module, String variable, Type type, String location, boolean isRequired) {
        this.module = module;
        this.variable = variable;
        this.type = type;
        this.location = location;
        this.isRequired = isRequired;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableKey variableKey = (VariableKey)o;
        return Objects.equals(this.module, variableKey.module) && Objects.equals(this.variable, variableKey.variable);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.variable);
    }

    public String toString() {
        return this.module.getOrg() + "/" + this.module.getName() + ":" + this.variable;
    }
}

