/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BUnionType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static BString getFiniteValue(VariableKey key, BUnionType unionType, String value, String variable) {
        BString stringVal = StringUtils.fromString(value);
        List<Type> memberTypes = unionType.getMemberTypes();
        for (Type type : memberTypes) {
            if (!((BFiniteType)type).valueSpace.contains(stringVal)) continue;
            return stringVal;
        }
        throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, variable, key.variable, Utils.decodeIdentifier(unionType.toString()), value);
    }

    public static Object getFiniteBalValue(String strValue, BFiniteType finiteType, VariableKey key, String arg) {
        ArrayList<Object> matchingValues = new ArrayList<Object>();
        for (Object value : finiteType.getValueSpace()) {
            String stringValue = value.toString();
            if (!stringValue.equals(strValue)) continue;
            matchingValues.add(value);
        }
        if (matchingValues.size() == 1) {
            return matchingValues.get(0);
        }
        String typeName = Utils.decodeIdentifier(finiteType.toString());
        if (matchingValues.isEmpty()) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, arg, key.variable, typeName, strValue);
        }
        throw new ConfigException(ErrorCodes.CONFIG_UNION_VALUE_AMBIGUOUS_TARGET, arg, key.variable, typeName);
    }

    public static boolean containsUnsupportedMembers(BUnionType unionType) {
        for (Type memberType : unionType.getMemberTypes()) {
            if (ConfigUtils.isPrimitiveOrSequenceType(TypeUtils.getImpliedType(memberType).getTag())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveOrSequenceType(int tag) {
        return tag == 14 || tag <= 6 || TypeTags.isXMLTypeTag(tag);
    }

    public static Object getUnionValue(VariableKey key, BUnionType unionType, String value, String arg) {
        List<Object> matchingValues = ConfigUtils.getConvertibleMemberValues(value, unionType);
        if (matchingValues.size() == 1) {
            return matchingValues.get(0);
        }
        String typeName = Utils.decodeIdentifier(unionType.toString());
        if (matchingValues.isEmpty()) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, arg, key.variable, typeName, value);
        }
        throw new ConfigException(ErrorCodes.CONFIG_UNION_VALUE_AMBIGUOUS_TARGET, arg, key.variable, typeName);
    }

    private static List<Object> getConvertibleMemberValues(String value, UnionType unionType) {
        ArrayList<Object> matchingValues = new ArrayList<Object>();
        block9: for (Type type : unionType.getMemberTypes()) {
            switch (TypeUtils.getImpliedType(type).getTag()) {
                case 14: {
                    continue block9;
                }
                case 2: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToByte, value);
                    continue block9;
                }
                case 1: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToInt, value);
                    continue block9;
                }
                case 6: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToBoolean, value);
                    continue block9;
                }
                case 3: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToFloat, value);
                    continue block9;
                }
                case 4: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToDecimal, value);
                    continue block9;
                }
                case 5: {
                    ConfigUtils.convertAndGetValuesFromString(matchingValues, StringUtils::fromString, value);
                    continue block9;
                }
            }
            ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToXml, value);
        }
        return matchingValues;
    }

    private static void convertAndGetValuesFromString(List<Object> matchingValues, Function<String, Object> convertFunc, String value) {
        Object unionValue;
        try {
            unionValue = convertFunc.apply(value);
        }
        catch (BError | NumberFormatException e) {
            return;
        }
        matchingValues.add(unionValue);
    }
}

