/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.cli;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.configurable.ConfigProvider;
import io.ballerina.runtime.internal.configurable.ConfigValue;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.configurable.providers.ConfigUtils;
import io.ballerina.runtime.internal.configurable.providers.cli.CliArg;
import io.ballerina.runtime.internal.configurable.providers.cli.CliConfigValue;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BUnionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CliProvider
implements ConfigProvider {
    private final Map<String, String> cliVarKeyValueMap;
    private final Map<String, VariableKey> markedCliKeyVariableMap;
    private final Module rootModule;

    public CliProvider(Module rootModule, String ... cliConfigArgs) {
        this.rootModule = rootModule;
        this.cliVarKeyValueMap = this.filterCliArgs(cliConfigArgs);
        this.markedCliKeyVariableMap = new HashMap<String, VariableKey>();
    }

    private Map<String, String> filterCliArgs(String[] cliConfigArgs) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (String cliConfigArg : cliConfigArgs) {
            String configKeyValue;
            String[] keyValuePair;
            if (!cliConfigArg.startsWith("-C") || (keyValuePair = (configKeyValue = cliConfigArg.substring(2)).split("(?<!\\\\)=", 2)).length != 2) continue;
            Object key = keyValuePair[0].trim();
            if (((String)key).endsWith("\\")) {
                key = (String)key + " ";
            }
            argMap.put((String)key, keyValuePair[1]);
        }
        return argMap;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean hasConfigs() {
        return !this.cliVarKeyValueMap.isEmpty();
    }

    @Override
    public Optional<ConfigValue> getAsIntAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToInt(cliArg.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, key.type, cliArg.value);
        }
    }

    private Optional<ConfigValue> getCliConfigValue(Object value) {
        return Optional.of(new CliConfigValue(value));
    }

    @Override
    public Optional<ConfigValue> getAsByteAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToByte(cliArg.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, key.type, cliArg.value);
        }
        catch (BError e) {
            throw new ConfigException(ErrorCodes.CONFIG_INVALID_BYTE_RANGE, cliArg, key.variable, cliArg.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsBooleanAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToBoolean(cliArg.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, key.type, cliArg.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsFloatAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToFloat(cliArg.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, key.type, cliArg.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsDecimalAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToDecimal(cliArg.value));
        }
        catch (BError | NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, key.type, cliArg.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsStringAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        return this.getCliConfigValue(StringUtils.fromString(cliArg.value));
    }

    @Override
    public Optional<ConfigValue> getAsArrayAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsRecordAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsMapAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsTableAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsUnionAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        BUnionType unionType = (BUnionType)((BIntersectionType)key.type).getEffectiveType();
        boolean isEnum = SymbolFlags.isFlagOn(unionType.getFlags(), 0x200000000L);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        if (!isEnum && ConfigUtils.containsUnsupportedMembers(unionType)) {
            throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, unionType);
        }
        if (isEnum) {
            return this.getCliConfigValue(ConfigUtils.getFiniteValue(key, unionType, cliArg.value, cliArg.toString()));
        }
        return this.getCliConfigValue(ConfigUtils.getUnionValue(key, unionType, cliArg.value, cliArg.toString()));
    }

    @Override
    public Optional<ConfigValue> getAsFiniteAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        BFiniteType type = key.type.getTag() == 34 ? (BFiniteType)((IntersectionType)key.type).getEffectiveType() : (BFiniteType)key.type;
        Object value = ConfigUtils.getFiniteBalValue(cliArg.value, type, key, cliArg.toString());
        return this.getCliConfigValue(value);
    }

    @Override
    public Optional<ConfigValue> getAsXmlAndMark(Module module, VariableKey key) {
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        try {
            return this.getCliConfigValue(TypeConverter.stringToXml(cliArg.value));
        }
        catch (BError e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, cliArg, key.variable, effectiveType, cliArg.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsTupleAndMark(Module module, VariableKey key) {
        CliArg cliArg = this.getCliArg(module, key);
        if (cliArg.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_CLI_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public void complete(RuntimeDiagnosticLog diagnosticLog) {
        Set<String> varKeySet = this.cliVarKeyValueMap.keySet();
        varKeySet.removeAll(this.markedCliKeyVariableMap.keySet());
        if (varKeySet.isEmpty()) {
            return;
        }
        for (String key : varKeySet) {
            diagnosticLog.error(ErrorCodes.CONFIG_CLI_UNUSED_CLI_ARGS, null, key + "=" + this.cliVarKeyValueMap.get(key));
        }
    }

    private CliArg getCliArg(Module module, VariableKey variableKey) {
        String key = module.getOrg() + "." + module.getName() + "." + variableKey.variable;
        String value = this.cliVarKeyValueMap.get(key);
        if (value != null || !this.rootModule.getOrg().equals(module.getOrg())) {
            return this.markAndGetCliArg(key, variableKey, value);
        }
        String rootOrgValue = null;
        if (this.rootModule.getName().equals(module.getName())) {
            rootOrgValue = this.cliVarKeyValueMap.get(variableKey.variable);
        }
        String moduleKey = module.getName() + "." + variableKey.variable;
        String rootModuleValue = this.cliVarKeyValueMap.get(moduleKey);
        return this.checkAmbiguitiesAndGetCliArg(variableKey, key, moduleKey, rootOrgValue, rootModuleValue);
    }

    private CliArg checkAmbiguitiesAndGetCliArg(VariableKey variableKey, String key, String moduleKey, String rootOrgValue, String rootModuleValue) {
        if (rootOrgValue == null && rootModuleValue == null) {
            return this.markAndGetCliArg(key, variableKey, null);
        }
        if (rootOrgValue != null && rootModuleValue == null) {
            return this.markAndGetCliArg(variableKey.variable, variableKey, rootOrgValue);
        }
        if (rootOrgValue == null) {
            return this.markAndGetCliArg(moduleKey, variableKey, rootModuleValue);
        }
        StringBuilder errorString = new StringBuilder();
        errorString.append("[").append(variableKey.variable).append("=").append(rootOrgValue);
        this.markedCliKeyVariableMap.put(variableKey.variable, variableKey);
        this.markedCliKeyVariableMap.put(moduleKey, variableKey);
        errorString.append(", ").append(moduleKey).append("=").append(rootModuleValue);
        errorString.append("]");
        throw new ConfigException(ErrorCodes.CONFIG_CLI_ARGS_AMBIGUITY, variableKey.variable, errorString);
    }

    private CliArg markAndGetCliArg(String key, VariableKey variableKey, String value) {
        VariableKey existingKey = this.markedCliKeyVariableMap.get(key);
        if (existingKey != null) {
            Module module = variableKey.module;
            String fullQualifiedKey = module.getOrg() + "." + module.getName() + "." + variableKey.variable;
            throw new ConfigException(ErrorCodes.CONFIG_CLI_VARIABLE_AMBIGUITY, variableKey.toString(), existingKey.toString(), "-C" + fullQualifiedKey + "=<value>");
        }
        this.markedCliKeyVariableMap.put(key, variableKey);
        return new CliArg(key, value);
    }
}

