/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.diagnostics;

import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLocation;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;

public class RuntimeDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final Object[] args;
    private final RuntimeDiagnosticLocation location;

    public RuntimeDiagnostic(DiagnosticInfo diagnosticInfo, String location, Object[] args) {
        this.diagnosticInfo = diagnosticInfo;
        this.args = args;
        this.location = new RuntimeDiagnosticLocation(location);
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    public String message() {
        return ErrorHelper.getErrorMessage(this.diagnosticInfo.messageFormat(), this.args).getValue();
    }

    public List<DiagnosticProperty<?>> properties() {
        return null;
    }

    public String toString() {
        String prefix = "error";
        if (this.diagnosticInfo.severity().equals((Object)DiagnosticSeverity.WARNING)) {
            prefix = "warning";
        }
        if (this.location.getLocation() == null) {
            return String.format("%s: %s", prefix, this.message());
        }
        return String.format("%s: %s\n\tat %s", prefix, this.message(), this.location.getLocation());
    }
}

