/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.json;

import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.StreamingJsonValue;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;

public class JsonGenerator
implements Closeable {
    private static final int DEFAULT_DEPTH = 10;
    private final Writer writer;
    private boolean[] levelInit = new boolean[10];
    private int currentLevel;
    private boolean fieldActive;
    private static final boolean[] ESC_CHARS = new boolean[93];

    public JsonGenerator(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    public JsonGenerator(OutputStream out, Charset charset) {
        this(new BufferedWriter(new OutputStreamWriter(out, charset)));
    }

    public JsonGenerator(Writer writer) {
        this.writer = writer;
    }

    private void setLevelInit(int index, boolean init) {
        this.checkAndResizeLevels(index);
        this.levelInit[index] = init;
    }

    private boolean getLevelInit(int index) {
        this.checkAndResizeLevels(index);
        return this.levelInit[index];
    }

    private void checkAndResizeLevels(int index) {
        if (index >= this.levelInit.length) {
            boolean[] oldLI = this.levelInit;
            this.levelInit = new boolean[(int)Math.ceil((double)oldLI.length * 1.5)];
            System.arraycopy(oldLI, 0, this.levelInit, 0, oldLI.length);
        }
    }

    private void processStartLevel() throws IOException {
        if (!this.fieldActive) {
            if (this.getLevelInit(this.currentLevel)) {
                this.writer.write(", ");
            } else {
                this.setLevelInit(this.currentLevel, true);
            }
        } else {
            this.fieldActive = false;
        }
        ++this.currentLevel;
    }

    private void processEndLevel() {
        this.setLevelInit(this.currentLevel - 1, true);
        this.setLevelInit(this.currentLevel, false);
        --this.currentLevel;
    }

    private void processFieldInit() throws IOException {
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
        this.fieldActive = true;
    }

    private void processValueInit() throws IOException {
        if (this.fieldActive) {
            this.fieldActive = false;
            return;
        }
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
    }

    public void startObject() throws IOException {
        this.processStartLevel();
        this.writer.write(123);
    }

    public void endObject() throws IOException {
        this.writer.write(125);
        this.processEndLevel();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this.processFieldInit();
        this.writeStringValue(fieldName);
        this.writer.write(":");
    }

    private void writeStringValue(String value) throws IOException {
        this.writer.write("\"");
        int count = value.length();
        boolean escaped = false;
        char[] chs = value.toCharArray();
        for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            if (ch >= ESC_CHARS.length || !ESC_CHARS[ch]) continue;
            escaped = true;
            break;
        }
        if (escaped) {
            this.writeStringEsc(chs);
        } else {
            this.writer.write(chs);
        }
        this.writer.write("\"");
    }

    public void writeString(String value) throws IOException {
        this.processValueInit();
        this.writeStringValue(value);
    }

    public void writeStringEsc(char[] chs) throws IOException {
        int count = chs.length;
        int index = 0;
        block10: for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '\"': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\"");
                    index = i + 1;
                    continue block10;
                }
                case '\\': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\\");
                    index = i + 1;
                    continue block10;
                }
                case '/': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\/");
                    index = i + 1;
                    continue block10;
                }
                case '\b': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\b");
                    index = i + 1;
                    continue block10;
                }
                case '\n': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\n");
                    index = i + 1;
                    continue block10;
                }
                case '\r': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\r");
                    index = i + 1;
                    continue block10;
                }
                case '\f': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\f");
                    index = i + 1;
                    continue block10;
                }
                case '\t': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\t");
                    index = i + 1;
                    continue block10;
                }
            }
        }
        if (count - index > 0) {
            this.writer.write(chs, index, count - index);
        }
    }

    public void writeNumber(long value) throws IOException {
        this.processValueInit();
        this.writer.write(Long.toString(value));
    }

    public void writeNumber(double value) throws IOException {
        this.processValueInit();
        this.writer.write(Double.toString(value));
    }

    public void writeNumber(BigDecimal value) throws IOException {
        this.processValueInit();
        this.writer.write(value.toString());
    }

    public void writeBoolean(boolean value) throws IOException {
        this.processValueInit();
        this.writer.write(Boolean.toString(value));
    }

    public void writeNull() throws IOException {
        this.processValueInit();
        this.writer.write("null");
    }

    public void writeStartArray() throws IOException {
        this.processStartLevel();
        this.writer.write("[");
    }

    public void writeEndArray() throws IOException {
        this.writer.write("]");
        this.processEndLevel();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void serialize(Object json) throws IOException {
        if (json == null) {
            this.writeNull();
            return;
        }
        switch (TypeUtils.getImpliedType(TypeChecker.getType(json)).getTag()) {
            case 32: 
            case 44: {
                if (json instanceof StreamingJsonValue) {
                    StreamingJsonValue streamingJsonValue = (StreamingJsonValue)json;
                    streamingJsonValue.serialize(this);
                    break;
                }
                this.writeStartArray();
                ArrayValue jsonArray = (ArrayValue)json;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.serialize(jsonArray.get(i));
                }
                this.writeEndArray();
                break;
            }
            case 6: {
                this.writeBoolean((Boolean)json);
                break;
            }
            case 3: {
                this.writeNumber(((Number)json).doubleValue());
                break;
            }
            case 4: {
                this.writeNumber(((DecimalValue)json).value());
                break;
            }
            case 1: {
                this.writeNumber(((Number)json).longValue());
                break;
            }
            case 2: {
                this.writeNumber(((Number)json).intValue());
                break;
            }
            case 15: 
            case 24: 
            case 27: {
                this.startObject();
                for (Map.Entry entry : ((MapValueImpl)json).entrySet()) {
                    this.writeFieldName(((BString)entry.getKey()).getValue());
                    this.serialize(entry.getValue());
                }
                this.endObject();
                break;
            }
            case 5: {
                this.writeString(json.toString());
                break;
            }
        }
    }

    static {
        JsonGenerator.ESC_CHARS[34] = true;
        JsonGenerator.ESC_CHARS[92] = true;
        JsonGenerator.ESC_CHARS[8] = true;
        JsonGenerator.ESC_CHARS[10] = true;
        JsonGenerator.ESC_CHARS[13] = true;
        JsonGenerator.ESC_CHARS[9] = true;
    }
}

