/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.types.DistinctIdSupplier;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.ErrorUtils;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.util.Optional;
import java.util.Set;

public class BErrorType
extends BAnnotatableType
implements ErrorType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getErrorType();
    public Type detailType = PredefinedTypes.TYPE_DETAIL;
    public BTypeIdSet typeIdSet;
    private IntersectionType intersectionType = null;
    private volatile DistinctIdSupplier distinctIdSupplier;

    public BErrorType(String typeName, Module pkg, Type detailType) {
        super(typeName, pkg, ErrorValue.class);
        this.detailType = detailType;
    }

    public BErrorType(String typeName, Module pkg) {
        super(typeName, pkg, ErrorValue.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeIdSet(BTypeIdSet typeIdSet) {
        this.typeIdSet = typeIdSet;
        BErrorType bErrorType = this;
        synchronized (bErrorType) {
            this.distinctIdSupplier = null;
        }
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 42;
    }

    public void setDetailType(Type detailType) {
        this.detailType = detailType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BErrorType)) {
            return false;
        }
        BErrorType other = (BErrorType)obj;
        if (this.detailType == other.detailType) {
            return true;
        }
        return this.detailType.equals(other.detailType);
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.typeName);
    }

    @Override
    public Type getDetailType() {
        return this.detailType;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public BTypeIdSet getTypeIdSet() {
        return this.typeIdSet;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        SemType err = this.detailType == null || this.isTopType() ? Builder.getErrorType() : ErrorUtils.errorDetail(BErrorType.tryInto(cx, this.getDetailType()));
        this.initializeDistinctIdSupplierIfNeeded(cx);
        return this.distinctIdSupplier.get().stream().map(ErrorUtils::errorDistinct).reduce(err, Core::intersect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDistinctIdSupplierIfNeeded(Context cx) {
        if (this.distinctIdSupplier == null) {
            BErrorType bErrorType = this;
            synchronized (bErrorType) {
                if (this.distinctIdSupplier == null) {
                    this.distinctIdSupplier = new DistinctIdSupplier(cx.env, this.getTypeIdSet());
                }
            }
        }
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType mayBeDependentType;
        Type type = this.detailType;
        return type instanceof MayBeDependentType && (mayBeDependentType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }

    private boolean isTopType() {
        return this.detailType == PredefinedTypes.TYPE_DETAIL;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        BError errorValue = (BError)object;
        Object details = errorValue.getDetails();
        if (!(details instanceof MapValueImpl)) {
            return Optional.empty();
        }
        MapValueImpl errorDetails = (MapValueImpl)details;
        this.initializeDistinctIdSupplierIfNeeded(cx);
        return BMapType.shapeOfInner(cx, shapeSupplier, errorDetails).map(ErrorUtils::errorDetail).map(err -> this.distinctIdSupplier.get().stream().map(ErrorUtils::errorDistinct).reduce((SemType)err, Core::intersect));
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        BError errorValue = (BError)object;
        Object details = errorValue.getDetails();
        if (!(details instanceof MapValueImpl)) {
            return Optional.empty();
        }
        MapValueImpl errorDetails = (MapValueImpl)details;
        return BMapType.shapeOfInner(cx, shapeSupplierFn, errorDetails).map(ErrorUtils::errorDetail);
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        return this.getSemType(cx);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return true;
    }
}

