/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.FunctionDefinition;
import io.ballerina.runtime.internal.types.semtype.FunctionQualifiers;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class BFunctionType
extends BAnnotatableType
implements FunctionType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getFunctionType();
    public Type restType;
    public Type retType;
    public long flags;
    public Parameter[] parameters;
    private final DefinitionContainer<FunctionDefinition> defn = new DefinitionContainer();

    public BFunctionType(Module pkg) {
        super("function ()", pkg, Object.class);
        this.parameters = new Parameter[0];
        this.retType = PredefinedTypes.TYPE_NULL;
        this.flags = 0L;
    }

    public BFunctionType(Module pkg, long flags) {
        super("function", pkg, Object.class);
        this.parameters = null;
        this.retType = null;
        this.flags = flags;
        if (this.isFunctionTop()) {
            this.resetTypeCheckCaches();
        }
    }

    @Deprecated
    public BFunctionType(Module pkg, Type[] paramTypes, Type restType, Type retType, long flags) {
        super("function ()", pkg, Object.class);
        this.restType = restType;
        this.retType = retType;
        this.flags = flags;
        if (this.isFunctionTop()) {
            this.resetTypeCheckCaches();
        }
    }

    public BFunctionType(Module pkg, Parameter[] parameters, Type restType, Type retType, long flags, String name) {
        super(name, pkg, Object.class);
        this.parameters = parameters;
        this.restType = restType;
        this.retType = retType;
        this.flags = flags;
        if (this.isFunctionTop()) {
            this.resetTypeCheckCaches();
        }
    }

    protected void resetTypeCheckCaches() {
        this.typeCheckCache = TypeCheckCacheFactory.create();
        this.typeId = TypeIdSupplier.getAnonId();
    }

    public Type[] getParameterTypes() {
        Type[] types = new Type[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            types[i] = this.parameters[i].type;
        }
        return types;
    }

    @Override
    public Type getReturnParameterType() {
        return this.retType;
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 49;
    }

    private static void addParamListToString(Parameter[] parameters, StringBuilder stringRep) {
        String prefix = "";
        for (Parameter parameter : parameters) {
            stringRep.append(prefix);
            prefix = ",";
            stringRep.append(parameter.type.toString());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFunctionType)) {
            return false;
        }
        BFunctionType that = (BFunctionType)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.flags != that.flags) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        return Objects.equals(this.retType, that.retType) && Objects.equals(this.restType, that.restType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (SymbolFlags.isFlagOn(this.flags, 0x8000000000L)) {
            return result;
        }
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + this.retType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder stringRep = new StringBuilder();
        if (SymbolFlags.isFlagOn(this.flags, 0x2000000L)) {
            stringRep.append("transactional ");
        }
        if (SymbolFlags.isFlagOn(this.flags, 0x20000000L)) {
            stringRep.append("isolated ");
        }
        if (SymbolFlags.isFlagOn(this.flags, 0x8000000000L)) {
            stringRep.append("function");
        } else {
            Type type;
            stringRep.append("function (");
            if (this.parameters != null) {
                BFunctionType.addParamListToString(this.parameters, stringRep);
            }
            if ((type = this.restType) instanceof BArrayType) {
                BArrayType bArrayType = (BArrayType)type;
                stringRep.append(",");
                stringRep.append(bArrayType.getElementType().toString());
                stringRep.append("...");
            }
            stringRep.append(")");
            if (this.retType != null) {
                stringRep.append(" returns (").append(this.retType).append(")");
            }
        }
        return stringRep.toString();
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.typeName);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Type getRestType() {
        return this.restType;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Type getReturnType() {
        return this.retType;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    private static SemType createIsolatedTop(Env env) {
        FunctionDefinition fd = new FunctionDefinition();
        SemType ret = Builder.getValType();
        return fd.define(env, Builder.getNeverType(), ret, FunctionQualifiers.create(true, false));
    }

    @Override
    public SemType createSemType(Context cx) {
        SemType rest;
        if (this.isFunctionTop()) {
            return this.getTopType(cx);
        }
        Env env = cx.env;
        if (this.defn.isDefinitionReady()) {
            return this.defn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<FunctionDefinition> result = this.defn.trySetDefinition(FunctionDefinition::new);
        if (!result.updated()) {
            return this.defn.getSemType(env);
        }
        FunctionDefinition fd = result.definition();
        SemType[] params = new SemType[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            params[i] = this.getSemType(cx, this.parameters[i].type);
        }
        Type type = this.restType;
        if (type instanceof BArrayType) {
            BArrayType arrayType = (BArrayType)type;
            rest = this.getSemType(cx, arrayType.getElementType());
        } else {
            rest = Builder.getNeverType();
        }
        SemType returnType = this.resolveReturnType(cx);
        ListDefinition paramListDefinition = new ListDefinition();
        SemType paramType = paramListDefinition.defineListTypeWrapped(env, params, params.length, rest, CellAtomicType.CellMutability.CELL_MUT_NONE);
        return fd.define(env, paramType, returnType, this.getQualifiers());
    }

    private SemType getTopType(Context cx) {
        if (SymbolFlags.isFlagOn(this.flags, 0x20000000L)) {
            return BFunctionType.createIsolatedTop(cx.env);
        }
        return Builder.getFunctionType();
    }

    FunctionQualifiers getQualifiers() {
        return FunctionQualifiers.create(SymbolFlags.isFlagOn(this.flags, 0x20000000L), SymbolFlags.isFlagOn(this.flags, 0x2000000L));
    }

    private SemType getSemType(Context cx, Type type) {
        return BFunctionType.tryInto(cx, type);
    }

    protected boolean isFunctionTop() {
        return this.parameters == null && this.restType == null && this.retType == null;
    }

    @Override
    public synchronized void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        BType ret;
        BType rest;
        Type type = this.restType;
        return type instanceof BType && (rest = (BType)type).isDependentlyTyped(visited) || (type = this.retType) instanceof BType && (ret = (BType)type).isDependentlyTyped(visited) || this.isDependentlyTypeParameters(visited);
    }

    private boolean isDependentlyTypeParameters(Set<MayBeDependentType> visited) {
        if (this.parameters == null) {
            return false;
        }
        return Arrays.stream(this.parameters).map(each -> each.type).filter(each -> each instanceof MayBeDependentType).anyMatch(each -> ((MayBeDependentType)((Object)each)).isDependentlyTyped(visited));
    }

    private SemType resolveReturnType(Context cx) {
        if (this.retType == null) {
            return Builder.getNilType();
        }
        MayBeDependentType retBType = (MayBeDependentType)((Object)this.retType);
        SemType returnType = this.getSemType(cx, this.retType);
        ListDefinition ld = new ListDefinition();
        SemType dependentlyTypedBit = retBType.isDependentlyTyped() ? Builder.getBooleanConst(true) : Builder.getBooleanType();
        SemType[] innerType = new SemType[]{dependentlyTypedBit, returnType};
        return ld.defineListTypeWrapped(cx.env, innerType, 2, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_NONE);
    }
}

