/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.NetworkObjectType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.internal.types.BMethodType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BResourceMethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public class BNetworkObjectType
extends BObjectType
implements NetworkObjectType {
    private ResourceMethodType[] resourceMethods;
    private volatile RemoteMethodType[] remoteMethods;

    public BNetworkObjectType(String typeName, Module pkg, long flags) {
        super(typeName, pkg, flags);
    }

    public void setResourceMethods(ResourceMethodType[] resourceMethods) {
        this.resourceMethods = resourceMethods;
    }

    @Override
    public RemoteMethodType[] getRemoteMethods() {
        if (this.remoteMethods == null) {
            RemoteMethodType[] funcs = this.getRemoteMethods(this.getMethods());
            if (this.remoteMethods == null) {
                this.remoteMethods = funcs;
            }
        }
        return this.remoteMethods;
    }

    private RemoteMethodType[] getRemoteMethods(MethodType[] methodTypes) {
        ArrayList<MethodType> functions = new ArrayList<MethodType>();
        for (MethodType funcType : methodTypes) {
            if (!SymbolFlags.isFlagOn(((BMethodType)funcType).flags, 32768L)) continue;
            functions.add(funcType);
        }
        return functions.toArray(new RemoteMethodType[0]);
    }

    @Override
    public ResourceMethodType[] getResourceMethods() {
        return this.resourceMethods;
    }

    @Override
    protected Collection<BObjectType.MethodData> allMethods(Context cx) {
        Stream<BObjectType.MethodData> methodStream = Arrays.stream(this.getMethods()).filter(methodType -> !SymbolFlags.isFlagOn(methodType.getFlags(), 32768L) && !SymbolFlags.isFlagOn(methodType.getFlags(), 131072L)).map(type -> BObjectType.MethodData.fromMethod(cx, type));
        Stream<BObjectType.MethodData> remoteMethodStream = Arrays.stream(this.getRemoteMethods()).map(type -> BObjectType.MethodData.fromRemoteMethod(cx, type));
        Stream<BObjectType.MethodData> resourceMethodStream = Arrays.stream(this.getResourceMethods()).map(method -> BObjectType.MethodData.fromResourceMethod(cx, (BResourceMethodType)method));
        return Stream.concat(methodStream, Stream.concat(remoteMethodStream, resourceMethodStream)).toList();
    }
}

