/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ReadonlyType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.RefValue;

public final class BReadonlyType
extends BSemTypeWrapper<BReadonlyTypeImpl>
implements ReadonlyType {
    private static final BasicTypeBitSet BASIC_TYPE;

    public BReadonlyType(String typeName, Module pkg) {
        super(new ConcurrentLazySupplier<BReadonlyTypeImpl>(() -> new BReadonlyTypeImpl(typeName, pkg)), typeName, pkg, 51, Builder.getReadonlyType());
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public boolean isAnydata() {
        return false;
    }

    static {
        SemType roType = Builder.getReadonlyType();
        BASIC_TYPE = new BasicTypeBitSet(roType.all() | roType.some());
    }

    protected static final class BReadonlyTypeImpl
    extends BType
    implements ReadonlyType {
        private BReadonlyTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, RefValue.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return null;
        }

        @Override
        public <V> V getEmptyValue() {
            return null;
        }

        @Override
        public int getTag() {
            return 51;
        }

        @Override
        public boolean isNilable() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }
    }
}

