/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BMethodType;
import io.ballerina.runtime.internal.types.BObjectType;
import java.util.StringJoiner;

public class BResourceMethodType
extends BMethodType
implements ResourceMethodType {
    public final String accessor;
    public final String[] resourcePath;
    public Type[] pathSegmentTypes;

    public BResourceMethodType(String funcName, Module pkg, BObjectType parent, BFunctionType type, Type[] pathSegmentTypes, long flags, String accessor, String[] resourcePath) {
        super(funcName, pkg, parent, type, flags);
        this.type = type;
        this.pathSegmentTypes = pathSegmentTypes;
        this.flags = flags;
        this.accessor = accessor;
        this.resourcePath = resourcePath;
    }

    @Override
    public String toString() {
        StringJoiner rp = new StringJoiner("/");
        for (String p : this.resourcePath) {
            rp.add(p);
        }
        StringJoiner sj = new StringJoiner(",", "resource function " + this.accessor + " " + rp.toString() + "(", ") returns (" + String.valueOf(this.type.retType) + ")");
        for (Parameter parameter : this.parameters) {
            Type type = parameter.type;
            sj.add(type.getName() + " " + parameter.name);
        }
        return sj.toString();
    }

    @Override
    @Deprecated
    public String[] getParamNames() {
        String[] paramNames = new String[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            paramNames[i] = this.parameters[i].name;
        }
        return paramNames;
    }

    @Override
    public String getAccessor() {
        return this.accessor;
    }

    @Override
    public String[] getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public <T extends MethodType> MethodType duplicate() {
        return new BResourceMethodType(this.funcName, this.pkg, this.parentObjectType, this.type, this.pathSegmentTypes, this.flags, this.accessor, this.resourcePath);
    }

    @Override
    @Deprecated
    public Boolean[] getParamDefaultability() {
        Boolean[] paramDefaults = new Boolean[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            paramDefaults[i] = this.parameters[i].isDefault;
        }
        return paramDefaults;
    }
}

